/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.tables;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableValueType;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.tables.EntityIdBinding;
import jetbrains.exodus.entitystore.tables.PropertyValue;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertyTypes {
    private final IntHashMap<ComparableValueType> typesById = new IntHashMap();
    private final HashMap<Class<? extends Comparable>, ComparableValueType> typesByClass = new HashMap();

    public PropertyTypes() {
        this.clear();
    }

    public void clear() {
        this.typesById.clear();
        this.typesByClass.clear();
        for (ComparableValueType predefinedType : ComparableValueType.PREDEFINED_COMPARABLE_VALUE_TYPES) {
            this.typesById.put(predefinedType.getTypeId(), (Object)predefinedType);
            this.typesByClass.put((Object)predefinedType.getClazz(), (Object)predefinedType);
        }
    }

    @NotNull
    public ComparableValueType getPropertyType(int typeId) {
        ComparableValueType result = (ComparableValueType)this.typesById.get(typeId);
        if (result == null) {
            throw new EntityStoreException("Unsupported property type id " + typeId);
        }
        return result;
    }

    @NotNull
    public ComparableValueType getPropertyType(@NotNull Class<? extends Comparable> clazz) {
        ComparableValueType result = (ComparableValueType)this.typesByClass.get(clazz);
        if (result == null) {
            throw new EntityStoreException("Unsupported property type " + clazz);
        }
        return result;
    }

    public void registerCustomPropertyType(int typeId, @NotNull Class<? extends Comparable> clazz, @NotNull ComparableBinding binding) {
        ComparableValueType propType;
        if (this.typesById.put(typeId += ComparableValueType.PREDEFINED_COMPARABLE_VALUE_TYPES.length, (Object)(propType = new ComparableValueType(typeId, binding, clazz))) != null) {
            throw new EntityStoreException("Already registered property type id " + typeId);
        }
        if (this.typesByClass.put(clazz, (Object)propType) != null) {
            throw new EntityStoreException("Already registered property type " + clazz);
        }
    }

    public PropertyValue entryToPropertyValue(@NotNull ByteIterable entry) {
        ByteIterableBase it = (ByteIterableBase)entry;
        byte[] bytes = it.getBytesUnsafe();
        ComparableValueType type = this.getPropertyType((byte)(bytes[0] ^ 0x80));
        Comparable data = type.getBinding().readObject(new ByteArrayInputStream(bytes, 1, it.getLength() - 1));
        return new PropertyValue(type, data);
    }

    public PropertyValue dataToPropertyValue(@NotNull Comparable data) {
        return new PropertyValue(this.getPropertyType(data.getClass()), data);
    }

    public ArrayByteIterable dataArrayToEntry(@NotNull Comparable[] dataArray) {
        LightOutputStream out = new LightOutputStream();
        for (Comparable data : dataArray) {
            if (data instanceof Entity) {
                EntityIdBinding.objectToEntry(((Entity)data).getId()).writeTo(out);
                continue;
            }
            PropertyTypes.writePropertyValue(out, this.dataToPropertyValue(PropertyTypes.toLowerCase(data)));
        }
        return out.asArrayByteIterable();
    }

    public static ArrayByteIterable propertyValueToEntry(@NotNull PropertyValue object) {
        LightOutputStream output = new LightOutputStream();
        PropertyTypes.writePropertyValue(output, object);
        return output.asArrayByteIterable();
    }

    public static Comparable toLowerCase(@Nullable Comparable value) {
        if (!(value instanceof String)) {
            return value;
        }
        return ((String)((Object)value)).toLowerCase();
    }

    private static void writePropertyValue(@NotNull LightOutputStream output, @NotNull PropertyValue object) {
        output.write(object.getType().getTypeId() ^ 0x80);
        object.getBinding().writeObject(output, object.getData());
    }
}

