/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.tables;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.tables.Table;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TwoColumnTable
extends Table {
    private final Store first;
    private final Store second;

    public TwoColumnTable(@NotNull PersistentStoreTransaction txn, @NotNull String name, @NotNull StoreConfig config) {
        PersistentEntityStoreImpl store = txn.getStore();
        Transaction envTxn = txn.getEnvironmentTransaction();
        Environment env = store.getEnvironment();
        this.first = env.openStore(name, config, envTxn);
        this.second = env.openStore(TwoColumnTable.secondColumnDatabaseName(name), config, envTxn);
        store.trackTableCreation(this.first, txn);
        store.trackTableCreation(this.second, txn);
    }

    public static String secondColumnDatabaseName(@NotNull String name) {
        return name + "#reverse";
    }

    @Nullable
    public ByteIterable get(@NotNull Transaction txn, @NotNull ByteIterable first) {
        return this.first.get(txn, first);
    }

    @Nullable
    public ByteIterable get2(@NotNull Transaction txn, @NotNull ByteIterable second) {
        return this.second.get(txn, second);
    }

    public boolean contains(@NotNull Transaction txn, @NotNull ByteIterable first, @NotNull ByteIterable second) {
        try (Cursor cursor = this.getFirstIndexCursor(txn);){
            boolean bl = cursor.getSearchBoth(first, second);
            return bl;
        }
    }

    public boolean contains2(@NotNull Transaction txn, @NotNull ByteIterable first, @NotNull ByteIterable second) {
        try (Cursor cursor = this.getSecondIndexCursor(txn);){
            boolean bl = cursor.getSearchBoth(second, first);
            return bl;
        }
    }

    public boolean put(@NotNull Transaction txn, @NotNull ByteIterable first, @NotNull ByteIterable second) {
        boolean result = this.first.put(txn, first, second);
        this.second.put(txn, second, first);
        return result;
    }

    public boolean delete(@NotNull Transaction txn, @NotNull ByteIterable first, @NotNull ByteIterable second) {
        boolean success;
        try (Cursor cursor = this.getFirstIndexCursor(txn);){
            success = cursor.getSearchBoth(first, second);
            if (!success) {
                boolean bl = false;
                return bl;
            }
            success = cursor.deleteCurrent();
            TwoColumnTable.checkStatus(success, "Failed to delete");
        }
        cursor = this.getSecondIndexCursor(txn);
        var6_5 = null;
        try {
            success = cursor.getSearchBoth(second, first);
            TwoColumnTable.checkStatus(success, "Failed to delete: data mismatch in TwoColumnTable's stores");
            success = cursor.deleteCurrent();
            TwoColumnTable.checkStatus(success, "Failed to delete");
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var6_5 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable) {
                        var6_5.addSuppressed(throwable);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        return true;
    }

    @NotNull
    public Cursor getFirstIndexCursor(@NotNull Transaction txn) {
        return this.first.openCursor(txn);
    }

    @NotNull
    public Cursor getSecondIndexCursor(@NotNull Transaction txn) {
        return this.second.openCursor(txn);
    }

    @Override
    public boolean canBeCached() {
        return !this.first.getConfig().temporaryEmpty && !this.second.getConfig().temporaryEmpty;
    }
}

