/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.util;

import java.util.Iterator;
import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityIdSet
implements Iterable<EntityId> {
    public static final EntityIdSet EMPTY_SET = new EntityIdSet();
    private final IntHashMap<LongSet> set = new IntHashMap();
    private int singleTypeId;
    private LongSet singleTypeLocalIds;
    private boolean holdsNull;

    public void add(@Nullable EntityId id) {
        if (id == null) {
            this.holdsNull = true;
            return;
        }
        int typeId = id.getTypeId();
        long localId = id.getLocalId();
        this.add(typeId, localId);
    }

    public void add(int typeId, long localId) {
        LongSet localIds = this.singleTypeLocalIds;
        if (localIds != null) {
            if (typeId != this.singleTypeId) {
                localIds = null;
            }
        } else {
            localIds = (LongSet)this.set.get(typeId);
        }
        if (localIds == null) {
            localIds = new LongHashSet(100, 3.0f);
            this.set.put(typeId, (Object)localIds);
            if (this.set.size() > 1) {
                this.singleTypeLocalIds = null;
            } else {
                this.singleTypeId = typeId;
                this.singleTypeLocalIds = localIds;
            }
        }
        localIds.add(localId);
    }

    public boolean contains(@Nullable EntityId id) {
        if (id == null) {
            return this.holdsNull;
        }
        return this.contains(id.getTypeId(), id.getLocalId());
    }

    public boolean contains(int typeId, long localId) {
        LongSet localIds = this.singleTypeLocalIds;
        if (localIds == null) {
            localIds = (LongSet)this.set.get(typeId);
            return localIds != null && localIds.contains(localId);
        }
        return this.singleTypeId == typeId && localIds.contains(localId);
    }

    public boolean remove(@Nullable EntityId id) {
        if (id == null) {
            boolean result = this.holdsNull;
            this.holdsNull = false;
            return result;
        }
        return this.remove(id.getTypeId(), id.getLocalId());
    }

    public boolean remove(int typeId, long localId) {
        LongSet localIds = this.singleTypeLocalIds;
        if (localIds == null) {
            localIds = (LongSet)this.set.get(typeId);
            return localIds != null && localIds.remove(localId);
        }
        return this.singleTypeId == typeId && localIds.remove(localId);
    }

    @Nullable
    public LongSet getTypeSet(int typeId) {
        return (LongSet)this.set.get(typeId);
    }

    @Override
    public Iterator<EntityId> iterator() {
        final Iterator entries = this.set.entrySet().iterator();
        return new Iterator<EntityId>(){
            private int typeId = -1;
            @NotNull
            private LongIterator it = LongIterator.EMPTY;
            private boolean hasNull = EntityIdSet.access$000(EntityIdSet.this);

            @Override
            public boolean hasNext() {
                while (!this.it.hasNext()) {
                    if (!entries.hasNext()) {
                        return this.hasNull;
                    }
                    Map.Entry nextTypeSet = (Map.Entry)entries.next();
                    this.typeId = (Integer)nextTypeSet.getKey();
                    this.it = ((LongSet)nextTypeSet.getValue()).iterator();
                }
                return true;
            }

            @Override
            public EntityId next() {
                if (!this.it.hasNext()) {
                    if (!this.hasNull) {
                        throw new IllegalStateException();
                    }
                    this.hasNull = false;
                    return null;
                }
                return new PersistentEntityId(this.typeId, (Long)this.it.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static /* synthetic */ boolean access$000(EntityIdSet x0) {
        return x0.holdsNull;
    }
}

