/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.replication;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u00060\rR\u00020\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/entitystore/replication/GcTransaction;", "", "env", "Ljetbrains/exodus/env/Environment;", "(Ljetbrains/exodus/env/Environment;)V", "getEnv", "()Ljetbrains/exodus/env/Environment;", "id", "", "getId", "()J", "thread", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljetbrains/exodus/entitystore/replication/GcTransaction$MyThread;", "start", "", "stop", "Companion", "MyThread", "xodus-multinode"})
public final class GcTransaction {
    private final AtomicReference<MyThread> thread;
    private final long id;
    @NotNull
    private final Environment env;
    private static final AtomicLong idSequence;
    public static final Companion Companion;

    public final long getId() {
        return this.id;
    }

    public final boolean start() {
        MyThread t;
        if (this.thread.get() == null && this.thread.compareAndSet(null, t = new MyThread(this.env, new Semaphore(0)))) {
            t.start();
            return true;
        }
        return false;
    }

    public final boolean stop() {
        MyThread t = this.thread.get();
        if (t != null && this.thread.compareAndSet(t, null)) {
            t.getSema().release();
            return true;
        }
        return false;
    }

    @NotNull
    public final Environment getEnv() {
        return this.env;
    }

    public GcTransaction(@NotNull Environment env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        this.env = env;
        this.thread = new AtomicReference();
        this.id = idSequence.incrementAndGet();
    }

    static {
        Companion = new Companion(null);
        idSequence = new AtomicLong();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ljetbrains/exodus/entitystore/replication/GcTransaction$MyThread;", "Ljava/lang/Thread;", "environment", "Ljetbrains/exodus/env/Environment;", "sema", "Ljava/util/concurrent/Semaphore;", "(Ljetbrains/exodus/entitystore/replication/GcTransaction;Ljetbrains/exodus/env/Environment;Ljava/util/concurrent/Semaphore;)V", "getSema", "()Ljava/util/concurrent/Semaphore;", "xodus-multinode"})
    private final class MyThread
    extends Thread {
        @NotNull
        private final Semaphore sema;

        @NotNull
        public final Semaphore getSema() {
            return this.sema;
        }

        public MyThread(final @NotNull Environment environment, final Semaphore sema) {
            Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
            Intrinsics.checkParameterIsNotNull((Object)sema, (String)"sema");
            super(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public final void run() {
                    Transaction txn = environment.beginTransaction();
                    try {
                        sema.acquire();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        ie.printStackTrace();
                    }
                    finally {
                        txn.abort();
                    }
                }
            }, "Thread with transaction preventing files from being deleted #" + GcTransaction.this.getId());
            this.sema = sema;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/exodus/entitystore/replication/GcTransaction$Companion;", "", "()V", "idSequence", "Ljava/util/concurrent/atomic/AtomicLong;", "xodus-multinode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

