/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.replication;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.entitystore.BlobHandleGenerator;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.BlobVaultItem;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.replication.S3BlobVault;
import jetbrains.exodus.entitystore.replication.S3BlobVault$flushBlobs$;
import jetbrains.exodus.entitystore.replication.S3BlobVaultItem;
import jetbrains.exodus.entitystore.replication.S3MissedBlobVaultItem;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.replication.MiscKt;
import jetbrains.exodus.log.replication.S3FactoryBoilerplate;
import jetbrains.exodus.util.DeferredIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 82\u00020\u00012\u00020\u0002:\u00018BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J:\u0010!\u001a\u00020\u001b2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010#2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010/\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u00100\u001a\u0004\u0018\u00010$2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0016J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\nH\u0002J\u0018\u00104\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u00105\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0016J\b\u00106\u001a\u00020\u001eH\u0016J\b\u00107\u001a\u00020 H\u0016R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00069"}, d2={"Ljetbrains/exodus/entitystore/replication/S3BlobVault;", "Ljetbrains/exodus/entitystore/BlobVault;", "Ljetbrains/exodus/log/replication/S3FactoryBoilerplate;", "store", "Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;", "blobHandleGenerator", "Ljetbrains/exodus/entitystore/BlobHandleGenerator;", "s3", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "bucket", "", "location", "blobExtension", "requestOverrideConfig", "Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "(Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;Ljetbrains/exodus/entitystore/BlobHandleGenerator;Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;)V", "getBlobExtension", "()Ljava/lang/String;", "getBlobHandleGenerator", "()Ljetbrains/exodus/entitystore/BlobHandleGenerator;", "getBucket", "getLocation", "getRequestOverrideConfig", "()Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "getS3", "()Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "clear", "", "close", "delete", "", "blobHandle", "", "flushBlobs", "blobStreams", "Ljetbrains/exodus/core/dataStructures/hash/LongHashMap;", "Ljava/io/InputStream;", "blobFiles", "Ljava/io/File;", "deferredBlobsToDelete", "Ljetbrains/exodus/core/dataStructures/hash/LongSet;", "txn", "Ljetbrains/exodus/env/Transaction;", "getBackupStrategy", "Ljetbrains/exodus/backup/BackupStrategy;", "getBlob", "Ljetbrains/exodus/entitystore/BlobVaultItem;", "getBlobKey", "getContent", "getS3BlobObject", "Lsoftware/amazon/awssdk/services/s3/model/S3Object;", "blobKey", "getSize", "nextHandle", "requiresTxn", "size", "Companion", "xodus-multinode"})
public final class S3BlobVault
extends BlobVault
implements S3FactoryBoilerplate {
    @NotNull
    private final BlobHandleGenerator blobHandleGenerator;
    @NotNull
    private final S3AsyncClient s3;
    @NotNull
    private final String bucket;
    @NotNull
    private final String location;
    @NotNull
    private final String blobExtension;
    @Nullable
    private final AwsRequestOverrideConfiguration requestOverrideConfig;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public BlobVaultItem getBlob(long blobHandle) {
        String blobKey = this.getBlobKey(blobHandle);
        S3Object blob = this.getS3BlobObject(blobKey);
        if (blob != null) {
            return new S3BlobVaultItem(blobHandle, blob);
        }
        return new S3MissedBlobVaultItem(blobHandle, blobKey);
    }

    @NotNull
    public String getBlobKey(long blobHandle) {
        return this.location + super.getBlobKey(blobHandle) + this.blobExtension;
    }

    @NotNull
    public BackupStrategy getBackupStrategy() {
        BackupStrategy backupStrategy = BackupStrategy.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)backupStrategy, (String)"BackupStrategy.EMPTY");
        return backupStrategy;
    }

    @Nullable
    public InputStream getContent(long blobHandle, @NotNull Transaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        String blobKey = this.getBlobKey(blobHandle);
        return ((ResponseBytes)this.getS3().getObject((GetObjectRequest)GetObjectRequest.builder().overrideConfiguration(this.getRequestOverrideConfig()).bucket(this.getBucket()).key(blobKey).build(), AsyncResponseTransformer.toBytes()).get()).asInputStream();
    }

    public long getSize(long blobHandle, @NotNull Transaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        String blobKey = this.getBlobKey(blobHandle);
        Object object = this.getS3BlobObject(blobKey);
        return object != null && (object = object.size()) != null ? (Long)object : 0L;
    }

    public long size() {
        return -1L;
    }

    public boolean requiresTxn() {
        return false;
    }

    public long nextHandle(@NotNull Transaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        return this.blobHandleGenerator.nextHandle(txn);
    }

    public void flushBlobs(@Nullable LongHashMap<InputStream> blobStreams, @Nullable LongHashMap<File> blobFiles, @Nullable LongSet deferredBlobsToDelete, @NotNull Transaction txn) {
        block4: {
            String key;
            Map.Entry it;
            Iterable $receiver$iv;
            LongSet longSet;
            Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
            LongHashMap<InputStream> longHashMap = blobStreams;
            if (longHashMap != null) {
                longSet = longHashMap;
                LongHashMap<InputStream> streams = longSet;
                Set set = streams.entrySet();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"streams.entries");
                $receiver$iv = set;
                for (Object element$iv : $receiver$iv) {
                    it = (Map.Entry)element$iv;
                    Object k = it.getKey();
                    Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
                    key = this.getBlobKey(((Number)k).longValue());
                    S3AsyncClient s3AsyncClient = this.getS3();
                    PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.getBucket()).overrideConfiguration(this.getRequestOverrideConfig()).key(key).build();
                    Object v = it.getValue();
                    Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
                    s3AsyncClient.putObject(putObjectRequest, AsyncRequestBody.fromBytes((byte[])ByteStreamsKt.readBytes$default((InputStream)((InputStream)v), (int)0, (int)1, null)));
                }
            }
            LongHashMap<File> longHashMap2 = blobFiles;
            if (longHashMap2 != null) {
                longSet = longHashMap2;
                Object files = longSet;
                Set set = files.entrySet();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"files.entries");
                $receiver$iv = set;
                for (Object element$iv : $receiver$iv) {
                    it = (Map.Entry)element$iv;
                    Object k = it.getKey();
                    Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
                    key = this.getBlobKey(((Number)k).longValue());
                    this.getS3().putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.getBucket()).overrideConfiguration(this.getRequestOverrideConfig()).key(key).build(), AsyncRequestBody.fromFile((File)((File)it.getValue())));
                }
            }
            LongSet longSet2 = deferredBlobsToDelete;
            if (longSet2 == null) break block4;
            LongSet blobHandles = longSet = longSet2;
            List copyHandles = CollectionsKt.toList((Iterable)((Iterable)blobHandles));
            Environment environment = txn.getEnvironment();
            environment.executeTransactionSafeTask(new Runnable(copyHandles, environment, this, txn){
                final /* synthetic */ List $copyHandles;
                final /* synthetic */ Environment $environment;
                final /* synthetic */ S3BlobVault this$0;
                final /* synthetic */ Transaction $txn$inlined;
                {
                    this.$copyHandles = list;
                    this.$environment = environment;
                    this.this$0 = s3BlobVault;
                    this.$txn$inlined = transaction;
                }

                public final void run() {
                    JobProcessorAdapter jobProcessorAdapter = DeferredIO.getJobProcessor();
                    Job job = new Job(this){
                        final /* synthetic */ flushBlobs$$inlined$let$lambda$1 this$0;
                        {
                            this.this$0 = $outer;
                        }

                        protected void execute() {
                            Iterable $receiver$iv = this.this$0.$copyHandles;
                            for (T element$iv : $receiver$iv) {
                                Long it = (Long)element$iv;
                                S3BlobVault s3BlobVault = this.this$0.this$0;
                                Long l = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"it");
                                s3BlobVault.delete(l);
                            }
                        }

                        @NotNull
                        public String getName() {
                            return "Delete obsolete blob files";
                        }

                        @NotNull
                        public String getGroup() {
                            Environment environment = this.this$0.$environment;
                            Intrinsics.checkExpressionValueIsNotNull((Object)environment, (String)"environment");
                            return environment.getLocation();
                        }
                    };
                    Environment environment = this.$environment;
                    Intrinsics.checkExpressionValueIsNotNull((Object)environment, (String)"environment");
                    EnvironmentConfig environmentConfig = environment.getEnvironmentConfig();
                    Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"environment.environmentConfig");
                    jobProcessorAdapter.queueIn(job, (long)environmentConfig.getGcFilesDeletionDelay());
                }
            });
        }
    }

    public void clear() {
        Sequence $receiver$iv = SequencesKt.windowed((Sequence)SequencesKt.map(MiscKt.listObjects(this.getS3(), MiscKt.listObjectsBuilder(this.getBucket(), this.getRequestOverrideConfig())), (Function1)clear.1.INSTANCE), (int)500, (int)500, (boolean)true);
        for (Object element$iv : $receiver$iv) {
            List it = (List)element$iv;
            MiscKt.deleteS3Objects(it, this.getS3(), this.getBucket(), this.getRequestOverrideConfig());
        }
    }

    public void close() {
        this.getS3().close();
    }

    public boolean delete(long blobHandle) {
        boolean bl;
        String key = this.getBlobKey(blobHandle);
        try {
            this.getS3().deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.getBucket()).overrideConfiguration(this.getRequestOverrideConfig()).key(key).build()).get();
            bl = true;
        }
        catch (Exception e) {
            Companion.getLogger().warn((Throwable)e, (Function0)delete.1.INSTANCE);
            bl = false;
        }
        return bl;
    }

    private final S3Object getS3BlobObject(String blobKey) {
        S3AsyncClient s3AsyncClient = this.getS3();
        ListObjectsRequest.Builder builder = MiscKt.listObjectsBuilder(this.getBucket(), this.getRequestOverrideConfig()).prefix(blobKey);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"listObjectsBuilder(bucke\u2026deConfig).prefix(blobKey)");
        Iterable list = SequencesKt.asIterable(MiscKt.listObjects(s3AsyncClient, builder));
        return (S3Object)CollectionsKt.firstOrNull((Iterable)list);
    }

    @NotNull
    public final BlobHandleGenerator getBlobHandleGenerator() {
        return this.blobHandleGenerator;
    }

    @Override
    @NotNull
    public S3AsyncClient getS3() {
        return this.s3;
    }

    @Override
    @NotNull
    public String getBucket() {
        return this.bucket;
    }

    @NotNull
    public final String getLocation() {
        return this.location;
    }

    @NotNull
    public final String getBlobExtension() {
        return this.blobExtension;
    }

    @Override
    @Nullable
    public AwsRequestOverrideConfiguration getRequestOverrideConfig() {
        return this.requestOverrideConfig;
    }

    public S3BlobVault(@NotNull PersistentEntityStoreImpl store, @NotNull BlobHandleGenerator blobHandleGenerator, @NotNull S3AsyncClient s32, @NotNull String bucket, @NotNull String location, @NotNull String blobExtension, @Nullable AwsRequestOverrideConfiguration requestOverrideConfig) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull((Object)blobHandleGenerator, (String)"blobHandleGenerator");
        Intrinsics.checkParameterIsNotNull((Object)s32, (String)"s3");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)blobExtension, (String)"blobExtension");
        super(store.getConfig());
        this.blobHandleGenerator = blobHandleGenerator;
        this.s3 = s32;
        this.bucket = bucket;
        this.location = location;
        this.blobExtension = blobExtension;
        this.requestOverrideConfig = requestOverrideConfig;
    }

    public /* synthetic */ S3BlobVault(PersistentEntityStoreImpl persistentEntityStoreImpl, BlobHandleGenerator blobHandleGenerator, S3AsyncClient s3AsyncClient, String string, String string2, String string3, AwsRequestOverrideConfiguration awsRequestOverrideConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            awsRequestOverrideConfiguration = null;
        }
        this(persistentEntityStoreImpl, blobHandleGenerator, s3AsyncClient, string, string2, string3, awsRequestOverrideConfiguration);
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> getRemoteFile(long length, long startingLength, @NotNull String name, @NotNull AsyncResponseTransformer<GetObjectResponse, T> handler) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        return S3FactoryBoilerplate.DefaultImpls.getRemoteFile(this, length, startingLength, name, handler);
    }

    @Override
    public boolean checkPreconditions(@NotNull Log log, long expectedLength, long startingLength) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        return S3FactoryBoilerplate.DefaultImpls.checkPreconditions(this, log, expectedLength, startingLength);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/entitystore/replication/S3BlobVault$Companion;", "Lmu/KLogging;", "()V", "xodus-multinode"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

