/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.replication;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import jetbrains.exodus.crypto.EncryptedBlobVault;
import jetbrains.exodus.crypto.StreamCipherOutputStream;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.DiskBasedBlobVault;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.replication.MetaServerHandler;
import jetbrains.exodus.entitystore.replication.MiscKt;
import jetbrains.exodus.entitystore.replication.PersistentEntityStoreReplicator;
import jetbrains.exodus.entitystore.replication.S3ReplicationBlobVault;
import jetbrains.exodus.entitystore.replication.S3Replicator;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.replication.EnvironmentAppender;
import jetbrains.exodus.env.replication.EnvironmentReplicationDelta;
import jetbrains.exodus.env.replication.ReplicationDelta;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.FileDataReader;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.replication.BufferQueueAsyncHandler;
import jetbrains.exodus.log.replication.FileFactory;
import jetbrains.exodus.log.replication.S3FactoryBoilerplate;
import jetbrains.exodus.log.replication.S3FileFactory;
import jetbrains.exodus.log.replication.S3ToWriterFileFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020!H\u0016J7\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u0010&\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b2J2\u00103\u001a\u00020*2\u0006\u0010+\u001a\u00020!2\u0006\u0010&\u001a\u0002042\u0018\u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020/0706H\u0016J\u0018\u00108\u001a\u00020*2\u0006\u0010+\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u000b\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u001f\u00a8\u0006:"}, d2={"Ljetbrains/exodus/entitystore/replication/S3Replicator;", "Ljetbrains/exodus/entitystore/replication/PersistentEntityStoreReplicator;", "Ljetbrains/exodus/log/replication/S3FactoryBoilerplate;", "metaServer", "", "httpClient", "Lsoftware/amazon/awssdk/http/async/SdkAsyncHttpClient;", "metaPort", "", "s3", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "bucket", "requestOverrideConfig", "Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "lazyBlobs", "", "(Ljava/lang/String;Lsoftware/amazon/awssdk/http/async/SdkAsyncHttpClient;ILsoftware/amazon/awssdk/services/s3/S3AsyncClient;Ljava/lang/String;Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;Z)V", "getBucket", "()Ljava/lang/String;", "getHttpClient", "()Lsoftware/amazon/awssdk/http/async/SdkAsyncHttpClient;", "getLazyBlobs", "()Z", "getMetaServer", "getRequestOverrideConfig", "()Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "getS3", "()Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "sourceEncrypted", "getSourceEncrypted", "setSourceEncrypted", "(Z)V", "beginReplication", "Ljetbrains/exodus/env/replication/EnvironmentReplicationDelta;", "environment", "Ljetbrains/exodus/env/Environment;", "decorateBlobVault", "Ljetbrains/exodus/entitystore/DiskBasedBlobVault;", "vault", "store", "Ljetbrains/exodus/entitystore/PersistentEntityStore;", "endReplication", "", "delta", "replicateBlob", "Ljava/io/File;", "handle", "", "length", "targetEncrypted", "replicateBlob$xodus_multinode", "replicateBlobVault", "Ljetbrains/exodus/entitystore/BlobVault;", "blobsToReplicate", "", "Ljetbrains/exodus/core/dataStructures/Pair;", "replicateEnvironment", "Companion", "xodus-multinode"})
public final class S3Replicator
implements PersistentEntityStoreReplicator,
S3FactoryBoilerplate {
    private volatile boolean sourceEncrypted;
    @NotNull
    private final String metaServer;
    @NotNull
    private final SdkAsyncHttpClient httpClient;
    private final int metaPort;
    @NotNull
    private final S3AsyncClient s3;
    @NotNull
    private final String bucket;
    @Nullable
    private final AwsRequestOverrideConfiguration requestOverrideConfig;
    private final boolean lazyBlobs;
    private static final ObjectMapper objectMapper;
    @NotNull
    private static final ObjectReader deltaReader;
    @NotNull
    private static final ObjectReader okReader;
    public static final Companion Companion;

    public final boolean getSourceEncrypted() {
        return this.sourceEncrypted;
    }

    public final void setSourceEncrypted(boolean bl) {
        this.sourceEncrypted = bl;
    }

    @NotNull
    public EnvironmentReplicationDelta beginReplication(@NotNull Environment environment) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        if (!(environment instanceof EnvironmentImpl)) {
            throw (Throwable)new UnsupportedOperationException("Cannot replicate custom environment");
        }
        long from = ((EnvironmentImpl)environment).getLog().getTip().highAddress;
        byte[] result = MiscKt.postRequest(this.httpClient, "/v1/delta/acquire", MapsKt.mapOf((Pair)TuplesKt.to((Object)"fromAddress", (Object)String.valueOf(from))), this.metaServer, this.metaPort);
        ReplicationDelta delta = (ReplicationDelta)deltaReader.readValue(result, 0, result.length);
        Companion.getLogger().info((Function0)new Function0<String>(delta){
            final /* synthetic */ ReplicationDelta $delta;

            @NotNull
            public final String invoke() {
                return "Replication delta acquired: " + this.$delta;
            }
            {
                this.$delta = replicationDelta;
                super(0);
            }
        });
        ReplicationDelta replicationDelta = delta;
        Intrinsics.checkExpressionValueIsNotNull((Object)replicationDelta, (String)"delta");
        return replicationDelta;
    }

    public void replicateEnvironment(@NotNull EnvironmentReplicationDelta delta, @NotNull Environment environment) {
        FileFactory fileFactory;
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        this.sourceEncrypted = delta.getEncrypted();
        boolean targetEncrypted = environment.getCipherProvider() != null;
        EnvironmentImpl cfr_ignored_0 = (EnvironmentImpl)environment;
        if (this.sourceEncrypted == targetEncrypted) {
            DataReader reader = ((EnvironmentImpl)environment).getLog().getConfig().getReader();
            if (reader instanceof FileDataReader) {
                S3AsyncClient s3AsyncClient = this.getS3();
                Path path = Paths.get(((EnvironmentImpl)environment).getLocation(), new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(environment.location)");
                fileFactory = new S3FileFactory(s3AsyncClient, path, this.getBucket(), (FileDataReader)reader, this.getRequestOverrideConfig());
            } else {
                fileFactory = new S3ToWriterFileFactory(this.getS3(), this.getBucket(), this.getRequestOverrideConfig());
            }
        } else {
            if (!targetEncrypted) {
                throw (Throwable)new UnsupportedOperationException("Un-encrypt log is not supported");
            }
            fileFactory = new S3ToWriterFileFactory(this.getS3(), this.getBucket(), this.getRequestOverrideConfig());
        }
        FileFactory factory = fileFactory;
        EnvironmentAppender.appendEnvironment((EnvironmentImpl)environment, delta, factory);
    }

    public void replicateBlobVault(@NotNull EnvironmentReplicationDelta delta, @NotNull BlobVault vault, @NotNull List<? extends jetbrains.exodus.core.dataStructures.Pair<Long, Long>> blobsToReplicate) {
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        Intrinsics.checkParameterIsNotNull((Object)vault, (String)"vault");
        Intrinsics.checkParameterIsNotNull(blobsToReplicate, (String)"blobsToReplicate");
        if (this.lazyBlobs) {
            if (Companion.getLogger().isInfoEnabled()) {
                Companion.getLogger().info("Blob vault " + vault.getClass().getSimpleName() + " will be replicated in a lazy manner");
            }
            return;
        }
        if (Companion.getLogger().isInfoEnabled()) {
            Companion.getLogger().info("Will replicate " + blobsToReplicate.size() + " blobs");
        }
        if (!(vault instanceof DiskBasedBlobVault)) {
            throw (Throwable)new UnsupportedOperationException("Cannot replicate non-file blob vault");
        }
        boolean targetEncrypted = vault instanceof EncryptedBlobVault;
        Iterable $receiver$iv = blobsToReplicate;
        for (Object element$iv : $receiver$iv) {
            jetbrains.exodus.core.dataStructures.Pair it = (jetbrains.exodus.core.dataStructures.Pair)element$iv;
            Object object = it.getFirst();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.first");
            long l = ((Number)object).longValue();
            Object object2 = it.getSecond();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it.second");
            this.replicateBlob$xodus_multinode(l, ((Number)object2).longValue(), (DiskBasedBlobVault)vault, this.sourceEncrypted, targetEncrypted);
        }
    }

    @NotNull
    public DiskBasedBlobVault decorateBlobVault(@NotNull DiskBasedBlobVault vault, @NotNull PersistentEntityStore store) {
        Intrinsics.checkParameterIsNotNull((Object)vault, (String)"vault");
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        return this.lazyBlobs ? (DiskBasedBlobVault)new S3ReplicationBlobVault(vault, (PersistentEntityStoreImpl)store, this) : vault;
    }

    public void endReplication(@NotNull EnvironmentReplicationDelta delta) {
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        byte[] maybeOk = MiscKt.postRequest(this.httpClient, "/v1/delta/release", MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)String.valueOf(delta.getId()))), this.metaServer, this.metaPort);
        Object object = okReader.readValue(maybeOk, 0, maybeOk.length);
        MetaServerHandler.OK $receiver = (MetaServerHandler.OK)object;
        if ($receiver.getOk()) {
            Companion.getLogger().info((Function0)new Function0<String>(delta){
                final /* synthetic */ EnvironmentReplicationDelta $delta$inlined;
                {
                    this.$delta$inlined = environmentReplicationDelta;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Replication delta #" + this.$delta$inlined.getId() + " released";
                }
            });
        }
    }

    @Nullable
    public final File replicateBlob$xodus_multinode(long handle, long length, @NotNull DiskBasedBlobVault vault, boolean sourceEncrypted, boolean targetEncrypted) {
        Intrinsics.checkParameterIsNotNull((Object)vault, (String)"vault");
        String blobKey = vault.getBlobKey(handle);
        File file = vault.getBlobLocation(handle, false);
        Companion.getLogger().debug((Function0)new Function0<String>(file, blobKey){
            final /* synthetic */ File $file;
            final /* synthetic */ String $blobKey;

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder = new StringBuilder().append("Copy blob file ");
                File file = this.$file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"file");
                return stringBuilder.append(file.getPath()).append(", key: ").append(this.$blobKey).toString();
            }
            {
                this.$file = file;
                this.$blobKey = string;
                super(0);
            }
        });
        try {
            Object it;
            Object fileStream;
            Long l;
            if (sourceEncrypted == targetEncrypted) {
                String string = blobKey;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"blobKey");
                AsyncResponseTransformer asyncResponseTransformer = AsyncResponseTransformer.toFile((File)file);
                Intrinsics.checkExpressionValueIsNotNull((Object)asyncResponseTransformer, (String)"AsyncResponseTransformer.toFile(file)");
                l = ((GetObjectResponse)this.getRemoteFile(length, 0L, string, asyncResponseTransformer).get()).contentLength();
            } else {
                ByteBuffer buffer;
                if (!(vault instanceof EncryptedBlobVault)) {
                    throw (Throwable)new UnsupportedOperationException("Un-encrypt blobs is not supported");
                }
                fileStream = new FileOutputStream(file);
                StreamCipherOutputStream stream = ((EncryptedBlobVault)vault).wrapOutputStream(handle, (OutputStream)new BufferedOutputStream((OutputStream)fileStream));
                BufferQueueAsyncHandler handler = new BufferQueueAsyncHandler();
                String string = blobKey;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"blobKey");
                CompletableFuture request = this.getRemoteFile(length, 0L, string, handler);
                ArrayBlockingQueue<ByteBuffer> queue = handler.getQueue();
                Subscription subscription = BufferQueueAsyncHandler.waitForSubscription$default(handler, request, 0L, 2, null);
                long written = 0L;
                while ((buffer = queue.take()) != BufferQueueAsyncHandler.Companion.getFinish()) {
                    int count = buffer.remaining();
                    byte[] output = new byte[count];
                    buffer.get(output);
                    subscription.request(1L);
                    stream.write(output);
                    written += (long)count;
                }
                stream.flush();
                ((FileOutputStream)fileStream).getFD().sync();
                l = ((GetObjectResponse)request.get()).contentLength();
            }
            Object object = it = (fileStream = l);
            if (object == null || (Long)object != length) {
                throw (Throwable)new IllegalStateException("Invalid file, received " + it + " bytes instead of " + length);
            }
        }
        catch (Throwable t) {
            Companion.getLogger().warn(t, (Function0)replicateBlob.3.INSTANCE);
            file.delete();
            throw (Throwable)new RuntimeException(t);
        }
        return file;
    }

    @NotNull
    public final String getMetaServer() {
        return this.metaServer;
    }

    @NotNull
    public final SdkAsyncHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    @NotNull
    public S3AsyncClient getS3() {
        return this.s3;
    }

    @Override
    @NotNull
    public String getBucket() {
        return this.bucket;
    }

    @Override
    @Nullable
    public AwsRequestOverrideConfiguration getRequestOverrideConfig() {
        return this.requestOverrideConfig;
    }

    public final boolean getLazyBlobs() {
        return this.lazyBlobs;
    }

    public S3Replicator(@NotNull String metaServer, @NotNull SdkAsyncHttpClient httpClient, int metaPort, @NotNull S3AsyncClient s32, @NotNull String bucket, @Nullable AwsRequestOverrideConfiguration requestOverrideConfig, boolean lazyBlobs) {
        Intrinsics.checkParameterIsNotNull((Object)metaServer, (String)"metaServer");
        Intrinsics.checkParameterIsNotNull((Object)httpClient, (String)"httpClient");
        Intrinsics.checkParameterIsNotNull((Object)s32, (String)"s3");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        this.metaServer = metaServer;
        this.httpClient = httpClient;
        this.metaPort = metaPort;
        this.s3 = s32;
        this.bucket = bucket;
        this.requestOverrideConfig = requestOverrideConfig;
        this.lazyBlobs = lazyBlobs;
    }

    public /* synthetic */ S3Replicator(String string, SdkAsyncHttpClient sdkAsyncHttpClient, int n, S3AsyncClient s3AsyncClient, String string2, AwsRequestOverrideConfiguration awsRequestOverrideConfiguration, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 8062;
        }
        if ((n2 & 0x20) != 0) {
            awsRequestOverrideConfiguration = null;
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        this(string, sdkAsyncHttpClient, n, s3AsyncClient, string2, awsRequestOverrideConfiguration, bl);
    }

    static {
        ObjectMapper objectMapper;
        Companion = new Companion(null);
        ObjectMapper $receiver = objectMapper = new ObjectMapper();
        $receiver.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        S3Replicator.objectMapper = objectMapper;
        ObjectReader objectReader = S3Replicator.objectMapper.readerFor(ReplicationDelta.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectReader, (String)"objectMapper.readerFor(R\u2026icationDelta::class.java)");
        deltaReader = objectReader;
        ObjectReader objectReader2 = S3Replicator.objectMapper.readerFor(MetaServerHandler.OK.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectReader2, (String)"objectMapper.readerFor(M\u2026erHandler.OK::class.java)");
        okReader = objectReader2;
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> getRemoteFile(long length, long startingLength, @NotNull String name, @NotNull AsyncResponseTransformer<GetObjectResponse, T> handler) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        return S3FactoryBoilerplate.DefaultImpls.getRemoteFile(this, length, startingLength, name, handler);
    }

    @Override
    public boolean checkPreconditions(@NotNull Log log, long expectedLength, long startingLength) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        return S3FactoryBoilerplate.DefaultImpls.checkPreconditions(this, log, expectedLength, startingLength);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Ljetbrains/exodus/entitystore/replication/S3Replicator$Companion;", "Lmu/KLogging;", "()V", "deltaReader", "Lcom/fasterxml/jackson/databind/ObjectReader;", "getDeltaReader$xodus_multinode", "()Lcom/fasterxml/jackson/databind/ObjectReader;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "okReader", "getOkReader$xodus_multinode", "xodus-multinode"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final ObjectReader getDeltaReader$xodus_multinode() {
            return deltaReader;
        }

        @NotNull
        public final ObjectReader getOkReader$xodus_multinode() {
            return okReader;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

