/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.log.replication.ByteArrayAsyncResponseHandler;
import jetbrains.exodus.log.replication.S3DataReader;
import jetbrains.exodus.log.replication.S3FactoryBoilerplate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J-\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u0000H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u001d"}, d2={"Ljetbrains/exodus/log/replication/BasicS3Block;", "Ljetbrains/exodus/io/Block;", "s3factory", "Ljetbrains/exodus/log/replication/S3FactoryBoilerplate;", "addr", "", "size", "(Ljetbrains/exodus/log/replication/S3FactoryBoilerplate;JJ)V", "getAddr$xodus_multinode", "()J", "key", "", "getKey", "()Ljava/lang/String;", "getS3factory$xodus_multinode", "()Ljetbrains/exodus/log/replication/S3FactoryBoilerplate;", "getSize$xodus_multinode", "getAddress", "length", "read", "", "output", "", "position", "offset", "count", "readAndCompare", "readAndCompare$xodus_multinode", "refresh", "xodus-multinode"})
public abstract class BasicS3Block
implements Block {
    @NotNull
    private final S3FactoryBoilerplate s3factory;
    private final long addr;
    private final long size;

    @NotNull
    public abstract String getKey();

    public long getAddress() {
        return this.addr;
    }

    public long length() {
        return this.size;
    }

    public int read(@NotNull byte[] output, long position, int offset, int count) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (count <= 0) {
            return 0;
        }
        String range = "bytes=" + position + '-' + (position + (long)count - 1L);
        S3DataReader.Companion.getLogger().debug((Function0)new Function0<String>(this, range){
            final /* synthetic */ BasicS3Block this$0;
            final /* synthetic */ String $range;

            @NotNull
            public final String invoke() {
                return "Request range: " + this.$range + " in file " + this.this$0.getKey();
            }
            {
                this.this$0 = basicS3Block;
                this.$range = string;
                super(0);
            }
        });
        Object t = this.s3factory.getS3().getObject((GetObjectRequest)GetObjectRequest.builder().range(range).overrideConfiguration(this.s3factory.getRequestOverrideConfig()).bucket(this.s3factory.getBucket()).key(this.getKey()).build(), (AsyncResponseTransformer)new ByteArrayAsyncResponseHandler(output, offset)).get();
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"s3factory.s3.getObject(G\u2026, offset)\n        ).get()");
        return ((Number)t).intValue();
    }

    @NotNull
    public BasicS3Block refresh() {
        return this;
    }

    public final int readAndCompare$xodus_multinode(@NotNull byte[] output, long position, int offset, int count) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        int read2 = n = this.read(output, position, offset, count);
        if (read2 < count) {
            String msg = "Tried to read " + count + " bytes from " + this.getKey() + " but got " + read2 + " bytes";
            S3DataReader.Companion.getLogger().error(msg);
            throw (Throwable)new ExodusException(msg);
        }
        return n;
    }

    @NotNull
    public final S3FactoryBoilerplate getS3factory$xodus_multinode() {
        return this.s3factory;
    }

    public final long getAddr$xodus_multinode() {
        return this.addr;
    }

    public final long getSize$xodus_multinode() {
        return this.size;
    }

    public BasicS3Block(@NotNull S3FactoryBoilerplate s3factory, long addr, long size) {
        Intrinsics.checkParameterIsNotNull((Object)s3factory, (String)"s3factory");
        this.s3factory = s3factory;
        this.addr = addr;
        this.size = size;
    }
}

