/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.util.List;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.LogUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0004H\u0000\u001a\f\u0010\u000e\u001a\u00020\u0004*\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0018\u0010\n\u001a\u00020\b*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000f"}, d2={"logFileNameWithExtLength", "", "address", "", "", "getAddress", "(Ljava/lang/String;)J", "isValidAddress", "", "(Ljava/lang/String;)Z", "isValidSubFolder", "checkAddress", "logFilename", "decodeAddress", "toFileName", "xodus-multinode"})
public final class FileNameRulesKt {
    public static final int logFileNameWithExtLength = 19;

    @NotNull
    public static final String toFileName(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver + ".xd";
    }

    public static final long getAddress(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return LogUtil.getAddress((String)$receiver);
    }

    public static final long decodeAddress(@NotNull String logFilename) {
        Intrinsics.checkParameterIsNotNull((Object)logFilename, (String)"logFilename");
        if (!FileNameRulesKt.checkAddress(logFilename)) {
            throw (Throwable)new ExodusException("Invalid log file name: " + logFilename);
        }
        String string = logFilename;
        int n = 0;
        int n2 = 16;
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string2;
        n = 16;
        return Long.parseLong(string, CharsKt.checkRadix((int)n));
    }

    public static final boolean checkAddress(@NotNull String logFilename) {
        Intrinsics.checkParameterIsNotNull((Object)logFilename, (String)"logFilename");
        return logFilename.length() == 19 && StringsKt.endsWith$default((String)logFilename, (String)".xd", (boolean)false, (int)2, null);
    }

    public static final boolean isValidAddress(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.length() == 14 && LogUtil.isLogFileName((String)$receiver);
    }

    public static final boolean isValidSubFolder(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        List paths = StringsKt.split$default((CharSequence)$receiver, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
        Object e = paths.get(0);
        String it = (String)e;
        boolean isValidFolderName = StringsKt.startsWith$default((String)it, (String)"_", (boolean)false, (int)2, null) && FileNameRulesKt.isValidAddress(FileNameRulesKt.toFileName(StringsKt.drop((String)it, (int)1)));
        return isValidFolderName && paths.size() == 2 && FileNameRulesKt.checkAddress((String)paths.get(1));
    }
}

