/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jetbrains.exodus.core.dataStructures.persistent.PersistentBitTreeLongMap;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongMap;
import jetbrains.exodus.log.replication.FileNameRulesKt;
import jetbrains.exodus.log.replication.MiscKt;
import jetbrains.exodus.log.replication.S3Block;
import jetbrains.exodus.log.replication.S3BlocksKt;
import jetbrains.exodus.log.replication.S3DataReaderOrWriter;
import jetbrains.exodus.log.replication.S3DataReaderOrWriterKt;
import jetbrains.exodus.log.replication.S3FactoryBoilerplate;
import jetbrains.exodus.log.replication.S3FolderBlock;
import jetbrains.exodus.log.replication.S3SubBlock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.S3Object;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0005\u00a8\u0006\t"}, d2={"fileBlocks", "", "Ljetbrains/exodus/log/replication/S3Block;", "Ljetbrains/exodus/log/replication/S3DataReaderOrWriter;", "getFileBlocks", "(Ljetbrains/exodus/log/replication/S3DataReaderOrWriter;)Ljava/util/List;", "folderBlocks", "Ljetbrains/exodus/log/replication/S3FolderBlock;", "getFolderBlocks", "xodus-multinode"})
public final class S3BlocksKt {
    @NotNull
    public static final List<S3Block> getFileBlocks(@NotNull S3DataReaderOrWriter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ListObjectsRequest.Builder builder = S3DataReaderOrWriterKt.listObjectsBuilder($receiver).delimiter("/");
        S3AsyncClient s3AsyncClient = $receiver.getS3();
        ListObjectsRequest.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        Sequence $receiver$iv = SequencesKt.map((Sequence)SequencesKt.filter(MiscKt.listObjects(s3AsyncClient, builder2), (Function1)fileBlocks.1.INSTANCE), (Function1)((Function1)new Function1<S3Object, S3Block>($receiver){
            final /* synthetic */ S3DataReaderOrWriter receiver$0;

            @NotNull
            public final S3Block invoke(@NotNull S3Object it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                S3FactoryBoilerplate s3FactoryBoilerplate = this.receiver$0;
                String string = it.key();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.key()");
                long l = FileNameRulesKt.getAddress(string);
                Long l2 = it.size();
                Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"it.size()");
                return new S3Block(s3FactoryBoilerplate, l, l2);
            }
            {
                this.receiver$0 = s3DataReaderOrWriter;
                super(1);
            }
        }));
        Sequence sequence = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                S3Block it = (S3Block)a;
                Comparable comparable = Long.valueOf(it.getAddr$xodus_multinode());
                it = (S3Block)b;
                Comparable comparable2 = comparable;
                Long l = it.getAddr$xodus_multinode();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)sequence, (Comparator)comparator));
    }

    @NotNull
    public static final List<S3FolderBlock> getFolderBlocks(@NotNull S3DataReaderOrWriter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ListObjectsRequest.Builder builder = S3DataReaderOrWriterKt.listObjectsBuilder($receiver).prefix("_");
        TreeMap folders = new TreeMap();
        S3AsyncClient s3AsyncClient = $receiver.getS3();
        ListObjectsRequest.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        Sequence<S3Object> $receiver$iv = MiscKt.listObjects(s3AsyncClient, builder2);
        for (Object element$iv : $receiver$iv) {
            PersistentLongMap.MutableMap $receiver2;
            String folderAsFileName;
            S3Object it = (S3Object)element$iv;
            String string = it.key();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.key()");
            List paths = StringsKt.split$default((CharSequence)string, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
            if (paths.size() != 2) continue;
            String folderName = (String)paths.get(0);
            if ((Pair)folders.get(folderName) != null) {
                PersistentLongMap.MutableMap $receiver3;
                Pair pair;
                Pair pair2 = pair;
                if (!FileNameRulesKt.checkAddress((String)paths.get(1))) continue;
                PersistentLongMap $receiver$iv2 = (PersistentLongMap)pair2.getSecond();
                PersistentLongMap.MutableMap mutableMap$iv = $receiver$iv2.beginWrite();
                Intrinsics.checkExpressionValueIsNotNull((Object)mutableMap$iv, (String)"mutableMap");
                long address = FileNameRulesKt.decodeAddress((String)paths.get(1));
                S3FactoryBoilerplate s3FactoryBoilerplate = $receiver;
                Long l = it.size();
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"it.size()");
                $receiver3.put(address, (Object)new S3SubBlock(s3FactoryBoilerplate, address, l, ((Number)pair2.getFirst()).longValue()));
                mutableMap$iv.endWrite();
                continue;
            }
            if (!StringsKt.startsWith$default((String)folderName, (String)"_", (boolean)false, (int)2, null) || !FileNameRulesKt.isValidAddress(folderAsFileName = FileNameRulesKt.toFileName(StringsKt.drop((String)folderName, (int)1))) || !FileNameRulesKt.checkAddress((String)paths.get(1))) continue;
            long blockAddress = FileNameRulesKt.getAddress(folderAsFileName);
            Map map = folders;
            PersistentBitTreeLongMap persistentBitTreeLongMap = new PersistentBitTreeLongMap();
            Long l = blockAddress;
            PersistentBitTreeLongMap $receiver4 = persistentBitTreeLongMap;
            PersistentLongMap $receiver$iv3 = (PersistentLongMap)$receiver4;
            PersistentLongMap.MutableMap mutableMap$iv = $receiver$iv3.beginWrite();
            Intrinsics.checkExpressionValueIsNotNull((Object)mutableMap$iv, (String)"mutableMap");
            long address = FileNameRulesKt.decodeAddress((String)paths.get(1));
            S3FactoryBoilerplate s3FactoryBoilerplate = $receiver;
            Long l2 = it.size();
            Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"it.size()");
            $receiver2.put(address, (Object)new S3SubBlock(s3FactoryBoilerplate, address, l2, blockAddress));
            mutableMap$iv.endWrite();
            PersistentBitTreeLongMap persistentBitTreeLongMap2 = persistentBitTreeLongMap;
            persistentBitTreeLongMap = TuplesKt.to((Object)l, (Object)persistentBitTreeLongMap2);
            map.put(folderName, persistentBitTreeLongMap);
        }
        Collection collection = folders.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"folders.values");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<Pair<? extends Long, ? extends PersistentLongMap<S3SubBlock>>, S3FolderBlock>($receiver){
            final /* synthetic */ S3DataReaderOrWriter receiver$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final S3FolderBlock invoke(@NotNull Pair<Long, ? extends PersistentLongMap<S3SubBlock>> it) {
                void $receiver$iv;
                long initial$iv;
                void $receiver$iv2;
                S3FolderBlock s3FolderBlock;
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                PersistentLongMap persistentLongMap = (PersistentLongMap)it.getSecond();
                long l = ((Number)it.getFirst()).longValue();
                S3FactoryBoilerplate s3FactoryBoilerplate = this.receiver$0;
                S3FolderBlock s3FolderBlock2 = s3FolderBlock;
                S3FolderBlock s3FolderBlock3 = s3FolderBlock;
                PersistentLongMap.ImmutableMap immutableMap = $receiver$iv2.beginRead();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"beginRead()");
                PersistentLongMap.ImmutableMap $receiver = immutableMap;
                Iterable iterable = (Iterable)$receiver;
                long accumulator$iv = initial$iv = 0L;
                for (T element$iv : $receiver$iv) {
                    void value;
                    PersistentLongMap.Entry entry = (PersistentLongMap.Entry)element$iv;
                    long acc = accumulator$iv;
                    void v2 = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"value");
                    accumulator$iv = acc + ((S3SubBlock)v2.getValue()).length();
                }
                long l2 = accumulator$iv;
                s3FolderBlock2(s3FactoryBoilerplate, l, l2, (PersistentLongMap<S3SubBlock>)((PersistentLongMap)it.getSecond()));
                return s3FolderBlock3;
            }
            {
                this.receiver$0 = s3DataReaderOrWriter;
                super(1);
            }
        })));
    }
}

