/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.date;

import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import jetbrains.charisma.date.SuitableTimezones;
import jetbrains.charisma.date.SuitableTimezonesImpl;
import jetbrains.charisma.persistent.BeansKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;
import org.springframework.stereotype.Service;

@Service(value="suitableTimezones")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0012\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0016\u00a8\u0006\r"}, d2={"Ljetbrains/charisma/date/SuitableTimezonesImpl;", "Ljetbrains/charisma/date/SuitableTimezones;", "()V", "getDefault", "Lorg/joda/time/DateTimeZone;", "getHumanReadablePresentation", "", "timezoneId", "getTimezone", "id", "getTimezones", "", "Companion", "youtrack-application"})
public final class SuitableTimezonesImpl
implements SuitableTimezones {
    private static final long AN_MINUTE_MILLIS = 60000L;
    private static final long AN_HOUR_MILLIS = 3600000L;
    private static final Regex timezonePrefix;
    @NotNull
    private static final Lazy suitableTimezones$delegate;
    public static final Companion Companion;

    @NotNull
    public List<DateTimeZone> getTimezones() {
        return CollectionsKt.toList((Iterable)Companion.getSuitableTimezones());
    }

    @NotNull
    public DateTimeZone getDefault() {
        DateTimeZone dateTimeZone = DateTimeZone.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone, (String)"DateTimeZone.getDefault()");
        return dateTimeZone;
    }

    @NotNull
    public DateTimeZone getTimezone(@Nullable String id) {
        DateTimeZone dateTimeZone;
        if (id == null) {
            return BeansKt.getXdApplicationMetaData().getTimezone();
        }
        try {
            DateTimeZone dateTimeZone2 = DateTimeZone.forID((String)id);
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone2, (String)"DateTimeZone.forID(id)");
            dateTimeZone = dateTimeZone2;
        }
        catch (Exception e) {
            Companion.getLogger().error("unrecognized timezone: " + id);
            DateTimeZone dateTimeZone3 = DateTimeZone.UTC;
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone3, (String)"DateTimeZone.UTC");
            dateTimeZone = dateTimeZone3;
        }
        return dateTimeZone;
    }

    @NotNull
    public String getHumanReadablePresentation(@NotNull String timezoneId) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)timezoneId, (String)"timezoneId");
        TimeZone tz = TimeZone.getTimeZone(timezoneId);
        int offset = tz.getOffset(System.currentTimeMillis());
        TimeZone timeZone2 = tz;
        Intrinsics.checkExpressionValueIsNotNull((Object)timeZone2, (String)"tz");
        String name2 = tz.getDisplayName(timeZone2.getDSTSavings() > 0, 1, BeansKt.getXdApplicationMetaData().getLocale());
        long hours = (long)offset / AN_HOUR_MILLIS;
        long minutes = Math.abs((long)offset % AN_HOUR_MILLIS / AN_MINUTE_MILLIS);
        if (offset > 0) {
            String string2 = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("SuitableTimeZones.{time_zone_id}_UTC/GMT_{positive_offset}_hours", new Object[]{name2, hours, minutes > 0L, ":" + minutes});
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"localizer.localizedMsg(\"\u2026nutes > 0, \":\" + minutes)");
        } else {
            String string3 = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("SuitableTimeZones.{time_zone_id}_UTC/GMT_{negative_offset}_hours", new Object[]{name2, hours, minutes > 0L, ":" + minutes});
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"localizer.localizedMsg(\"\u2026nutes > 0, \":\" + minutes)");
        }
        return string;
    }

    static {
        Companion = new Companion(null);
        AN_MINUTE_MILLIS = 60000L;
        AN_HOUR_MILLIS = 60L * AN_MINUTE_MILLIS;
        timezonePrefix = new Regex("^(Africa|America|Asia|Atlantic|Australia|Europe|Indian|Pacific|US)/.*");
        suitableTimezones$delegate = LazyKt.lazy((Function0)Companion.suitableTimezones.2.INSTANCE);
    }

    public static final /* synthetic */ Regex access$getTimezonePrefix$cp() {
        return timezonePrefix;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/charisma/date/SuitableTimezonesImpl$Companion;", "Lmu/KLogging;", "()V", "AN_HOUR_MILLIS", "", "AN_MINUTE_MILLIS", "suitableTimezones", "", "Lorg/joda/time/DateTimeZone;", "getSuitableTimezones", "()Ljava/util/Set;", "suitableTimezones$delegate", "Lkotlin/Lazy;", "timezonePrefix", "Lkotlin/text/Regex;", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "suitableTimezones", "getSuitableTimezones()Ljava/util/Set;"))};
        }

        @NotNull
        public final Set<DateTimeZone> getSuitableTimezones() {
            Lazy lazy = suitableTimezones$delegate;
            Companion companion = Companion;
            KProperty kProperty = $$delegatedProperties[0];
            return (Set)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

