/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent.globalSettings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.charisma.date.BeansKt;
import jetbrains.gap.resource.Entity;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u001c\u0010\u0018\u001a\u00020\u0013*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/charisma/persistent/globalSettings/DstHistory;", "Ljetbrains/gap/resource/Entity;", "tzId", "", "(Ljava/lang/String;)V", "abbrs", "", "getAbbrs", "()Ljava/util/List;", "id", "getId", "()Ljava/lang/String;", "offsets", "", "getOffsets", "untils", "", "getUntils", "zones", "Ljetbrains/charisma/persistent/globalSettings/DstHistory$Zone;", "getAllTransitions", "now", "getTransitionsFrom", "startingFrom", "toZone", "Lorg/joda/time/DateTimeZone;", "timestamp", "Companion", "Zone", "youtrack-application"})
public class DstHistory
extends Entity {
    private final List<Zone> zones;
    private final String tzId;
    private static final long AN_MINUTE_MILLIS = 60000L;
    private static final long YOUTRACK_EPOCH_START = 946684800000L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getId() {
        return this.tzId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getAbbrs() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.zones;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Zone zone = (Zone)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbbr();
            collection.add(string);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Long> getUntils() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.zones;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Zone zone = (Zone)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = it.getUntil();
            collection.add(l);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Integer> getOffsets() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.zones;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Zone zone = (Zone)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getOffset();
            collection.add(n);
        }
        return (List)var3_3;
    }

    private final Zone toZone(@NotNull DateTimeZone $receiver, long timestamp, long now) {
        String string = $receiver.getNameKey(timestamp - 1L);
        if (string == null) {
            String string2 = $receiver.getID();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"id");
        }
        String abbr = string;
        int offset = (int)((long)$receiver.getOffset(timestamp - 1L) / AN_MINUTE_MILLIS);
        Long until = timestamp < now ? Long.valueOf(timestamp) : null;
        return new Zone(abbr, offset, until);
    }

    private final List<Zone> getAllTransitions(long now) {
        DateTimeZone dtz = BeansKt.getSuitableTimezones().getTimezone(this.tzId);
        List result2 = new ArrayList();
        long nextTransition = now;
        long prevTransition = dtz.previousTransition(now);
        while (nextTransition > prevTransition) {
            DateTimeZone dateTimeZone = dtz;
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone, (String)"dtz");
            result2.add(this.toZone(dateTimeZone, nextTransition + 1L, now));
            nextTransition = prevTransition;
            prevTransition = dtz.previousTransition(prevTransition);
        }
        DateTimeZone dateTimeZone = dtz;
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone, (String)"dtz");
        result2.add(this.toZone(dateTimeZone, nextTransition + 1L, now));
        CollectionsKt.reverse((List)result2);
        return result2;
    }

    private final List<Zone> getTransitionsFrom(long startingFrom, long now) {
        DateTimeZone dtz = BeansKt.getSuitableTimezones().getTimezone(this.tzId);
        List result2 = new ArrayList();
        long prevTransition = startingFrom;
        long nextTransition = dtz.nextTransition(startingFrom);
        while (true) {
            long l = nextTransition;
            if (prevTransition + 1L > l || now - 1L < l) break;
            DateTimeZone dateTimeZone = dtz;
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone, (String)"dtz");
            result2.add(this.toZone(dateTimeZone, nextTransition, now));
            prevTransition = nextTransition;
            nextTransition = dtz.nextTransition(nextTransition);
        }
        DateTimeZone dateTimeZone = dtz;
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone, (String)"dtz");
        result2.add(this.toZone(dateTimeZone, now, now));
        return result2;
    }

    public DstHistory(@NotNull String tzId) {
        Intrinsics.checkParameterIsNotNull((Object)tzId, (String)"tzId");
        this.tzId = tzId;
        this.zones = this.getAllTransitions(System.currentTimeMillis());
    }

    public /* synthetic */ DstHistory(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    public DstHistory() {
        this(null, 1, null);
    }

    static {
        AN_MINUTE_MILLIS = 60000L;
        YOUTRACK_EPOCH_START = 946684800000L;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ.\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ljetbrains/charisma/persistent/globalSettings/DstHistory$Zone;", "", "abbr", "", "offset", "", "until", "", "(Ljava/lang/String;ILjava/lang/Long;)V", "getAbbr", "()Ljava/lang/String;", "getOffset", "()I", "getUntil", "()Ljava/lang/Long;", "Ljava/lang/Long;", "component1", "component2", "component3", "copy", "(Ljava/lang/String;ILjava/lang/Long;)Ljetbrains/charisma/persistent/globalSettings/DstHistory$Zone;", "equals", "", "other", "hashCode", "toString", "youtrack-application"})
    private static final class Zone {
        @NotNull
        private final String abbr;
        private final int offset;
        @Nullable
        private final Long until;

        @NotNull
        public final String getAbbr() {
            return this.abbr;
        }

        public final int getOffset() {
            return this.offset;
        }

        @Nullable
        public final Long getUntil() {
            return this.until;
        }

        public Zone(@NotNull String abbr, int offset, @Nullable Long until) {
            Intrinsics.checkParameterIsNotNull((Object)abbr, (String)"abbr");
            this.abbr = abbr;
            this.offset = offset;
            this.until = until;
        }

        @NotNull
        public final String component1() {
            return this.abbr;
        }

        public final int component2() {
            return this.offset;
        }

        @Nullable
        public final Long component3() {
            return this.until;
        }

        @NotNull
        public final Zone copy(@NotNull String abbr, int offset, @Nullable Long until) {
            Intrinsics.checkParameterIsNotNull((Object)abbr, (String)"abbr");
            return new Zone(abbr, offset, until);
        }

        @NotNull
        public static /* synthetic */ Zone copy$default(Zone zone, String string, int n, Long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = zone.abbr;
            }
            if ((n2 & 2) != 0) {
                n = zone.offset;
            }
            if ((n2 & 4) != 0) {
                l = zone.until;
            }
            return zone.copy(string, n, l);
        }

        @NotNull
        public String toString() {
            return "Zone(abbr=" + this.abbr + ", offset=" + this.offset + ", until=" + this.until + ")";
        }

        public int hashCode() {
            String string = this.abbr;
            Long l = this.until;
            return ((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.offset)) * 31 + (l != null ? ((Object)l).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Zone)) break block3;
                    Zone zone = (Zone)object;
                    if (!Intrinsics.areEqual((Object)this.abbr, (Object)zone.abbr) || !(this.offset == zone.offset) || !Intrinsics.areEqual((Object)this.until, (Object)zone.until)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/charisma/persistent/globalSettings/DstHistory$Companion;", "", "()V", "AN_MINUTE_MILLIS", "", "YOUTRACK_EPOCH_START", "youtrack-application"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

