/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent.link;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import jetbrains.charisma.links.persistent.IssueLinkPrototypeUtil;
import jetbrains.charisma.links.persistent.LinkAssociationsCache;
import jetbrains.charisma.links.persistent.LinkDirection;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.Issue;
import jetbrains.charisma.persistent.link.IssueLink;
import jetbrains.charisma.persistent.link.IssueLinkType;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.gaprest.db.DatabaseEntities;
import jetbrains.youtrack.gaprest.db.DatabaseEntity;
import jetbrains.youtrack.gaprest.exception.LocalizedForbiddenException;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Ljetbrains/charisma/persistent/link/LinkValues;", "Ljetbrains/youtrack/gaprest/db/DatabaseEntities;", "Ljetbrains/charisma/persistent/Issue;", "source", "Ljetbrains/charisma/persistent/link/IssueLink;", "name", "", "(Ljetbrains/charisma/persistent/link/IssueLink;Ljava/lang/String;)V", "entityType", "Lkotlin/reflect/KClass;", "getEntityType", "()Lkotlin/reflect/KClass;", "iterable", "", "Ljetbrains/exodus/entitystore/Entity;", "getIterable", "()Ljava/lang/Iterable;", "getName", "()Ljava/lang/String;", "queryEngine", "Ljetbrains/exodus/query/QueryEngine;", "getQueryEngine", "()Ljetbrains/exodus/query/QueryEngine;", "getSource", "()Ljetbrains/charisma/persistent/link/IssueLink;", "add", "", "element", "clear", "", "remove", "youtrack-application"})
public final class LinkValues
implements DatabaseEntities<Issue> {
    @NotNull
    private final IssueLink source;
    @NotNull
    private final String name;

    @NotNull
    public KClass<Issue> getEntityType() {
        return Reflection.getOrCreateKotlinClass(Issue.class);
    }

    @NotNull
    public Iterable<Entity> getIterable() {
        return this.source.entityIterable$youtrack_application();
    }

    @NotNull
    public QueryEngine getQueryEngine() {
        String name$iv = "queryEngine";
        boolean $i$f$getBean = false;
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.query.QueryEngine");
        }
        return (QueryEngine)object;
    }

    public boolean add(@NotNull Issue element) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)element), (String)"element");
        XdIssue issue2 = element.getXdEntity();
        if (!XdIssue.isAccessible$default(issue2, Operation.LINK, null, 2, null)) {
            throw (Throwable)new LocalizedForbiddenException("IssueLink.cant_add_link_to_issue", new Object[]{element});
        }
        XdIssue sourceIssue = this.source.getIssue();
        if (!XdIssue.isAccessible$default(sourceIssue, Operation.LINK, null, 2, null)) {
            throw (Throwable)new LocalizedForbiddenException("IssueLink.cant_add_link_to_issue", new Object[]{element});
        }
        IssueLinkType issueLinkType = this.source.getLinkType();
        if (issueLinkType == null) {
            Intrinsics.throwNpe();
        }
        IssueLinkType proto = issueLinkType;
        if (this.source.getDirection() == LinkDirection.OUTWARD) {
            proto.getXdEntity().link(sourceIssue, issue2);
        } else {
            proto.getXdEntity().link(issue2, sourceIssue);
        }
        return true;
    }

    public boolean remove(@NotNull Issue element) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)element), (String)"element");
        XdIssue issue2 = element.getXdEntity();
        if (!XdIssue.isAccessible$default(issue2, Operation.LINK, null, 2, null)) {
            throw (Throwable)new LocalizedForbiddenException("IssueLink.cant_remove_link_from_issue", new Object[]{element});
        }
        IssueLinkType issueLinkType = this.source.getLinkType();
        if (issueLinkType == null) {
            Intrinsics.throwNpe();
        }
        IssueLinkType proto = issueLinkType;
        if (this.source.getDirection() == LinkDirection.OUTWARD) {
            proto.getXdEntity().unlink(this.source.getIssue(), issue2);
        } else {
            proto.getXdEntity().unlink(issue2, this.source.getIssue());
        }
        return true;
    }

    public void clear() {
        Entity entity2 = this.source.getIssue().getEntity();
        LinkAssociationsCache linkAssociationsCache = BeansKt.getLinkAssociationsCache();
        LinkDirection linkDirection = this.source.getDirection();
        IssueLinkType issueLinkType = this.source.getLinkType();
        if (issueLinkType == null) {
            Intrinsics.throwNpe();
        }
        IssueLinkPrototypeUtil.clearLinks((Entity)entity2, (Map)linkAssociationsCache.getAssociations(linkDirection, (Entity)issueLinkType.getEntity()));
    }

    @NotNull
    public final IssueLink getSource() {
        return this.source;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public LinkValues(@NotNull IssueLink source, @NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)source), (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        this.source = source;
        this.name = name2;
    }

    public int getSize() {
        return DatabaseEntities.DefaultImpls.getSize((DatabaseEntities)this);
    }

    public boolean addAll(@NotNull Collection<? extends Issue> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        return DatabaseEntities.DefaultImpls.addAll((DatabaseEntities)this, elements);
    }

    public boolean contains(@NotNull Issue element) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)element), (String)"element");
        return DatabaseEntities.DefaultImpls.contains((DatabaseEntities)this, (DatabaseEntity)((DatabaseEntity)element));
    }

    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        return DatabaseEntities.DefaultImpls.containsAll((DatabaseEntities)this, elements);
    }

    public boolean isEmpty() {
        return DatabaseEntities.DefaultImpls.isEmpty((DatabaseEntities)this);
    }

    @NotNull
    public Iterator<Issue> iterator() {
        return DatabaseEntities.DefaultImpls.iterator((DatabaseEntities)this);
    }

    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        return DatabaseEntities.DefaultImpls.removeAll((DatabaseEntities)this, elements);
    }

    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        return DatabaseEntities.DefaultImpls.retainAll((DatabaseEntities)this, elements);
    }

    @NotNull
    public Entity unwrapSource(@NotNull DatabaseEntity source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return DatabaseEntities.DefaultImpls.unwrapSource((DatabaseEntities)this, (DatabaseEntity)source);
    }

    @NotNull
    public Entity unwrapTarget(@NotNull DatabaseEntity target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return DatabaseEntities.DefaultImpls.unwrapTarget((DatabaseEntities)this, (DatabaseEntity)target);
    }

    @NotNull
    public Issue wrapTarget(@NotNull KClass<? extends Issue> type, @NotNull Entity entity2) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)entity2, (String)"entity");
        return (Issue)DatabaseEntities.DefaultImpls.wrapTarget((DatabaseEntities)this, type, (Entity)entity2);
    }

    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)((Object)this));
    }

    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)((Object)this), (Object[])TArray);
    }
}

