/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jetbrains.charisma.persistent.Issue;
import jetbrains.charisma.persistent.IssueFolder;
import jetbrains.charisma.persistent.queries.EntityIdIterator;
import jetbrains.charisma.persistent.queries.YouTrackTransientQueryEngine;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="searchPageService")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JO\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\b\"\u0004\b\u0000\u0010\n2\u0006\u0010\f\u001a\u0002H\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012JO\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\b\"\u0004\b\u0000\u0010\n2\u0006\u0010\f\u001a\u0002H\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\n0\u00142\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0015JB\u0010\u0016\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Ljetbrains/charisma/service/SearchPageService;", "", "()V", "queryEngine", "Ljetbrains/charisma/persistent/queries/YouTrackTransientQueryEngine;", "getQueryEngine", "()Ljetbrains/charisma/persistent/queries/YouTrackTransientQueryEngine;", "findPage", "Lkotlin/Triple;", "Ljava/util/LinkedList;", "T", "", "source", "iterable", "", "cachedCount", "pageSize", "", "(Ljava/lang/Object;Ljava/lang/Iterable;JI)Lkotlin/Triple;", "iterator", "", "(Ljava/lang/Object;Ljava/util/Iterator;JI)Lkotlin/Triple;", "getPage", "", "Ljetbrains/exodus/entitystore/Entity;", "sourceIssue", "Ljetbrains/exodus/database/TransientEntity;", "folder", "Ljetbrains/charisma/persistent/IssueFolder;", "filter", "", "youtrack-application"})
public final class SearchPageService {
    @NotNull
    public final YouTrackTransientQueryEngine getQueryEngine() {
        String name$iv = "queryEngine";
        boolean $i$f$getBean = false;
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.charisma.persistent.queries.YouTrackTransientQueryEngine");
        }
        return (YouTrackTransientQueryEngine)((Object)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Triple<Collection<Entity>, Long, Long> getPage(@NotNull TransientEntity sourceIssue, @Nullable IssueFolder folder2, @Nullable String filter2, int pageSize2) {
        Triple triple;
        Intrinsics.checkParameterIsNotNull((Object)sourceIssue, (String)"sourceIssue");
        Iterable filtered = Issue.Companion.getFiltered$default(Issue.Companion, folder2, filter2, true, null, null, 24, null);
        Iterable iterable = this.getQueryEngine().toEntityIterable(filtered);
        if (iterable instanceof EntityIterableBase) {
            void index;
            Collection<TransientEntity> collection;
            void $receiver$iv$iv;
            void page;
            Iterable $receiver$iv;
            PersistentEntityStoreImpl store;
            PersistentEntityStoreImpl persistentEntityStoreImpl = store = this.getQueryEngine().getPersistentStore();
            Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntityStoreImpl, (String)"store");
            Long l = persistentEntityStoreImpl.getEntityIterableCache().getCachedCount(((EntityIterableBase)iterable).getHandle());
            if (l == null) {
                l = -1L;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"store.entityIterableCach\u2026nt(iterable.handle) ?: -1");
            long cachedCount = l;
            PersistentEntityId persistentEntityId = sourceIssue.getPersistentEntity().getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntityId, (String)"sourceIssue.persistentEntity.id");
            EntityIterator entityIterator = ((EntityIterableBase)iterable).iterator();
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterator, (String)"iterable.iterator()");
            Triple<LinkedList<PersistentEntityId>, Long, Long> triple2 = this.findPage(persistentEntityId, new EntityIdIterator(entityIterator), cachedCount, pageSize2);
            LinkedList linkedList = (LinkedList)triple2.component1();
            long l2 = ((Number)triple2.component2()).longValue();
            long total = ((Number)triple2.component3()).longValue();
            TransientStoreSession session = DnqUtils.getCurrentTransientSession();
            Iterable iterable2 = $receiver$iv = (Iterable)page;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                EntityId entityId = (EntityId)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v4 = it;
                if (v4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.PersistentEntityId");
                }
                TransientEntity transientEntity = session.newEntity((Entity)new PersistentEntity(store, (PersistentEntityId)v4));
                collection.add(transientEntity);
            }
            collection = (List)destination$iv$iv;
            Long l3 = total;
            Long l4 = (long)index;
            List list = collection;
            triple = new Triple((Object)list, (Object)l4, (Object)l3);
        } else {
            Iterable iterable3 = iterable;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable3, (String)"iterable");
            triple = this.findPage(sourceIssue, iterable3, -1L, pageSize2);
        }
        return triple;
    }

    @NotNull
    public final <T> Triple<LinkedList<T>, Long, Long> findPage(T source, @NotNull Iterable<? extends T> iterable, long cachedCount, int pageSize2) {
        Intrinsics.checkParameterIsNotNull(iterable, (String)"iterable");
        return this.findPage(source, iterable.iterator(), cachedCount, pageSize2);
    }

    @NotNull
    public final <T> Triple<LinkedList<T>, Long, Long> findPage(T source, @NotNull Iterator<? extends T> iterator2, long cachedCount, int pageSize2) {
        Iterator<T> iterator3;
        Intrinsics.checkParameterIsNotNull(iterator2, (String)"iterator");
        LinkedList<T> output2 = new LinkedList<T>();
        long index = -1L;
        long i = 0L;
        int countdown = -1;
        Iterator<T> iterator4 = iterator3 = iterator2;
        while (iterator4.hasNext()) {
            T value = iterator4.next();
            if (countdown > 0 && --countdown == 0) {
                output2.add(value);
                if (output2.size() > pageSize2) {
                    output2.poll();
                }
            }
            if (countdown == 0) {
                if (cachedCount > 0L) {
                    break;
                }
            } else {
                output2.add(value);
                if (output2.size() > pageSize2) {
                    output2.poll();
                }
                if (Intrinsics.areEqual(value, source)) {
                    index = i;
                    countdown = Math.max(pageSize2 - output2.size(), output2.size() / 2);
                }
            }
            long l = i;
            i = l + 1L;
        }
        return new Triple(output2, (Object)index, (Object)Math.max(i, cachedCount));
    }
}

