/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.eventSource;

import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import jetbrains.gap.resource.Entity;
import jetbrains.gap.resource.Resource;
import jetbrains.gap.resource.WebUtilsKt;
import jetbrains.youtrack.eventSource.EventSourceBusResource;
import jetbrains.youtrack.eventSource.EventSourceKt;
import jetbrains.youtrack.eventSource.TrackedEventOutput;
import jetbrains.youtrack.gaprest.exception.LocalizedNotAuthorizedException;
import jetbrains.youtrack.gaprest.filters.AuthIgnored;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.glassfish.jersey.media.sse.EventOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="eventSourceBus")
@AuthIgnored
@Produces(value={"text/event-stream"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u000e\u001a\u00020\n2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u0010J\b\u0010\u0013\u001a\u00020\u0011H\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f\u0018\u00010\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/eventSource/EventSourceBusResource;", "Ljetbrains/gap/resource/Resource;", "Ljetbrains/gap/resource/Entity;", "()V", "args", "Ljavax/ws/rs/core/UriInfo;", "connections", "Ljava/util/concurrent/atomic/AtomicLong;", "oneTimeTickets", "", "", "kotlin.jvm.PlatformType", "Ljetbrains/youtrack/eventSource/EventSourceBusResource$EventSourceTicket;", "", "createTicket", "initializer", "Lkotlin/Function3;", "Lorg/glassfish/jersey/media/sse/EventOutput;", "", "events", "getConnectionsCount", "", "hasConnections", "", "Companion", "EventSourceTicket", "youtrack-application"})
public final class EventSourceBusResource
implements Resource<Entity> {
    @Context
    private UriInfo args;
    private final AtomicLong connections = new AtomicLong();
    private final Map<String, EventSourceTicket> oneTimeTickets = Collections.synchronizedMap(new LinkedHashMap<String, EventSourceTicket>(){

        protected boolean removeEldestEntry(@Nullable Map.Entry<String, EventSourceTicket> eldest) {
            if (this.size() > 1000) {
                EventSourceBusResource.Companion.getLogger().warn((Function0)oneTimeTickets.removeEldestEntry.1.INSTANCE);
                return true;
            }
            return false;
        }
    });
    public static final Companion Companion = new Companion(null);

    @GET
    @NotNull
    public final EventOutput events() {
        String id;
        EventSourceTicket ticket;
        UriInfo uriInfo = this.args;
        if (uriInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        if ((ticket = this.oneTimeTickets.remove(id = WebUtilsKt.get((UriInfo)uriInfo, (String)"ticket"))) != null) {
            if (ticket.expired(System.currentTimeMillis())) {
                throw (Throwable)new LocalizedNotAuthorizedException("EventSource.expired_ticket_provided", new Object[]{id});
            }
            UriInfo uriInfo2 = this.args;
            if (uriInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"args");
            }
            return ticket.createOutput(uriInfo2, this.connections);
        }
        throw (Throwable)new LocalizedNotAuthorizedException("EventSource.invalid_ticket_provided", new Object[]{id});
    }

    @NotNull
    public final String createTicket(@NotNull Function3<? super EventOutput, ? super UriInfo, ? super String, Unit> initializer) {
        Intrinsics.checkParameterIsNotNull(initializer, (String)"initializer");
        EventSourceTicket ticket = new EventSourceTicket(initializer, null, 0L, 6, null);
        Map<String, EventSourceTicket> map2 = this.oneTimeTickets;
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"oneTimeTickets");
        Map<String, EventSourceTicket> map3 = map2;
        String string = ticket.getId();
        EventSourceTicket eventSourceTicket = ticket;
        map3.put(string, eventSourceTicket);
        return ticket.getId();
    }

    public final boolean hasConnections() {
        return this.connections.get() > 0L;
    }

    public final long getConnectionsCount() {
        return this.connections.get();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/eventSource/EventSourceBusResource$EventSourceTicket;", "", "initializer", "Lkotlin/Function3;", "Lorg/glassfish/jersey/media/sse/EventOutput;", "Ljavax/ws/rs/core/UriInfo;", "", "", "id", "expires", "", "(Lkotlin/jvm/functions/Function3;Ljava/lang/String;J)V", "getId", "()Ljava/lang/String;", "getInitializer", "()Lkotlin/jvm/functions/Function3;", "createOutput", "uriInfo", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "expired", "", "now", "youtrack-application"})
    public static final class EventSourceTicket {
        @NotNull
        private final Function3<EventOutput, UriInfo, String, Unit> initializer;
        @NotNull
        private final String id;
        private final long expires;

        public final boolean expired(long now) {
            return this.expires < now;
        }

        @NotNull
        public final EventOutput createOutput(@NotNull UriInfo uriInfo, @NotNull AtomicLong counter) {
            TrackedEventOutput trackedEventOutput;
            Intrinsics.checkParameterIsNotNull((Object)uriInfo, (String)"uriInfo");
            Intrinsics.checkParameterIsNotNull((Object)counter, (String)"counter");
            TrackedEventOutput $receiver = trackedEventOutput = new TrackedEventOutput(counter);
            boolean bl = false;
            this.initializer.invoke((Object)$receiver, (Object)uriInfo, (Object)this.id);
            $receiver.afterInit();
            return trackedEventOutput;
        }

        @NotNull
        public final Function3<EventOutput, UriInfo, String, Unit> getInitializer() {
            return this.initializer;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public EventSourceTicket(@NotNull Function3<? super EventOutput, ? super UriInfo, ? super String, Unit> initializer, @NotNull String id, long expires) {
            Intrinsics.checkParameterIsNotNull(initializer, (String)"initializer");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            this.initializer = initializer;
            this.id = id;
            this.expires = expires;
        }

        public /* synthetic */ EventSourceTicket(Function3 function3, String string, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                String string2 = new BigInteger(150, EventSourceKt.getRng()).toString(32);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"BigInteger(150, rng).toString(32)");
                string = string2;
            }
            if ((n & 4) != 0) {
                l = System.currentTimeMillis() + (long)30000;
            }
            this((Function3<? super EventOutput, ? super UriInfo, ? super String, Unit>)function3, string, l);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/eventSource/EventSourceBusResource$Companion;", "Lmu/KLogging;", "()V", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

