/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.extensions;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.youtrack.markup.extensions.AbstractPostProcessor;
import jetbrains.youtrack.markup.extensions.IssueAttachmentExtension;
import jetbrains.youtrack.markup.extensions.RegexpExtractionResult;
import jetbrains.youtrack.markup.extensions.RegexpExtractor;
import jetbrains.youtrack.markup.extensions.RegexpLinkPostProcessor;
import jetbrains.youtrack.markup.extensions.VideoNode;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueCommentKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.commonmark.node.Image;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.parser.Parser;
import org.commonmark.parser.PostProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00072\u00020\u0001:\u0004\u0007\b\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/markup/extensions/IssueAttachmentExtension;", "Lorg/commonmark/parser/Parser$ParserExtension;", "()V", "extend", "", "parserBuilder", "Lorg/commonmark/parser/Parser$Builder;", "Companion", "IssueAttachmentExtractionResult", "IssueAttachmentRegexpExtractor", "IssueAttachmentsPostProcessor", "youtrack-application"})
public class IssueAttachmentExtension
implements Parser.ParserExtension {
    public static final int ISSUE_MAX_ATTACHMENTS_THRESHOLD = 100;
    public static final Companion Companion = new Companion(null);

    public void extend(@NotNull Parser.Builder parserBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)parserBuilder, (String)"parserBuilder");
        parserBuilder.postProcessor((PostProcessor)new IssueAttachmentsPostProcessor());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002J\u0014\u0010\u000e\u001a\u00060\u000fR\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/markup/extensions/IssueAttachmentExtension$IssueAttachmentsPostProcessor;", "Ljetbrains/youtrack/markup/extensions/RegexpLinkPostProcessor;", "()V", "extractor", "Ljetbrains/youtrack/markup/extensions/RegexpExtractor;", "getExtractor", "()Ljetbrains/youtrack/markup/extensions/RegexpExtractor;", "issue", "Ljetbrains/youtrack/persistent/XdIssue;", "getIssue", "()Ljetbrains/youtrack/persistent/XdIssue;", "removeQuotes", "", "line", "replacementOf", "Ljetbrains/youtrack/markup/extensions/AbstractPostProcessor$ReplacementResult;", "Ljetbrains/youtrack/markup/extensions/AbstractPostProcessor;", "result", "Ljetbrains/youtrack/markup/extensions/RegexpExtractionResult;", "visit", "", "text", "Lorg/commonmark/node/Text;", "youtrack-application"})
    public static final class IssueAttachmentsPostProcessor
    extends RegexpLinkPostProcessor {
        @Nullable
        public final XdIssue getIssue() {
            return BeansKt.getMarkdownProcessingContext().getIssue();
        }

        public void visit(@NotNull Text text) {
            block2: {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                    XdIssue xdIssue = this.getIssue();
                    if (XdQueryKt.isNotEmpty((XdQuery)((XdQuery)(xdIssue != null ? xdIssue.getAttachments() : null)))) break block1;
                    XdEntity xdEntity = this.getIssue();
                    if (xdEntity == null || (xdEntity = XdIssueCommentKt.findCommentDraft$default((XdIssue)xdEntity, null, 1, null)) == null || (xdEntity = xdEntity.getAttachments()) == null) break block2;
                    if (!XdQueryKt.isNotEmpty((XdQuery)((XdQuery)xdEntity))) break block2;
                }
                this.linkify(text);
            }
        }

        @Override
        @NotNull
        public RegexpExtractor getExtractor() {
            XdIssue xdIssue = this.getIssue();
            if (xdIssue == null) {
                Intrinsics.throwNpe();
            }
            Sequence sequence = XdQueryKt.asSequence((XdQuery)((XdQuery)xdIssue.getAttachments()));
            XdEntity xdEntity = this.getIssue();
            if (xdEntity == null || (xdEntity = XdIssueCommentKt.findCommentDraft$default((XdIssue)xdEntity, null, 1, null)) == null || (xdEntity = xdEntity.getAttachments()) == null || (xdEntity = XdQueryKt.asSequence((XdQuery)((XdQuery)xdEntity))) == null) {
                xdEntity = SequencesKt.emptySequence();
            }
            Set attachmentNames2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.plus((Sequence)sequence, (Sequence)xdEntity), (int)100), (Function1)extractor.attachmentNames.1.INSTANCE));
            Pattern pattern = Pattern.compile("!\\[([^\\n]*)]\\((" + CollectionsKt.joinToString$default((Iterable)attachmentNames2, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")( \"[^!\\n\"]*\")?\\)");
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"!\\\\[([^\u2026})( \\\"[^!\\\\n\\\"]*\\\")?\\\\)\")");
            return new IssueAttachmentRegexpExtractor(pattern, 0, 2, null);
        }

        @Override
        @NotNull
        public AbstractPostProcessor.ReplacementResult replacementOf(@NotNull RegexpExtractionResult result2) {
            AbstractPostProcessor.ReplacementResult replacementResult;
            Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            IssueAttachmentExtractionResult cfr_ignored_0 = (IssueAttachmentExtractionResult)result2;
            if (VideoNode.Companion.looksLikeVideo(((IssueAttachmentExtractionResult)result2).getFileName())) {
                replacementResult = new AbstractPostProcessor.ReplacementResult(result2.getEnd(), (Node)new VideoNode(((IssueAttachmentExtractionResult)result2).getFileName(), ((IssueAttachmentExtractionResult)result2).getFileName()));
            } else {
                Image image = new Image(((IssueAttachmentExtractionResult)result2).getFileName(), this.removeQuotes(((IssueAttachmentExtractionResult)result2).getTitle()));
                CharSequence charSequence = ((IssueAttachmentExtractionResult)result2).getAlt();
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    image.appendChild((Node)new Text(this.removeQuotes(((IssueAttachmentExtractionResult)result2).getAlt())));
                }
                replacementResult = new AbstractPostProcessor.ReplacementResult(result2.getEnd(), (Node)image);
            }
            return replacementResult;
        }

        private final String removeQuotes(String line) {
            String string;
            CharSequence charSequence = line;
            return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? ((string = line) != null && (string = StringsKt.removePrefix((String)string, (CharSequence)" \"")) != null ? StringsKt.removeSuffix((String)string, (CharSequence)"\"") : null) : null;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/markup/extensions/IssueAttachmentExtension$IssueAttachmentRegexpExtractor;", "Ljetbrains/youtrack/markup/extensions/RegexpExtractor;", "pattern", "Ljava/util/regex/Pattern;", "groupIndex", "", "(Ljava/util/regex/Pattern;I)V", "extractFromMatcher", "Ljetbrains/youtrack/markup/extensions/IssueAttachmentExtension$IssueAttachmentExtractionResult;", "matcher", "Ljava/util/regex/Matcher;", "youtrack-application"})
    public static final class IssueAttachmentRegexpExtractor
    extends RegexpExtractor {
        @Override
        @NotNull
        protected IssueAttachmentExtractionResult extractFromMatcher(@NotNull Matcher matcher) {
            Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
            String alt2 = matcher.group(1);
            String string = matcher.group(2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group(2)");
            String fileName = string;
            String title2 = matcher.group(3);
            String string2 = matcher.group(this.getGroupIndex());
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"matcher.group(groupIndex)");
            return new IssueAttachmentExtractionResult(string2, matcher.start(), matcher.end(), fileName, alt2, title2);
        }

        public IssueAttachmentRegexpExtractor(@NotNull Pattern pattern, int groupIndex) {
            Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
            super(pattern, groupIndex);
        }

        public /* synthetic */ IssueAttachmentRegexpExtractor(Pattern pattern, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(pattern, n);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Ljetbrains/youtrack/markup/extensions/IssueAttachmentExtension$IssueAttachmentExtractionResult;", "Ljetbrains/youtrack/markup/extensions/RegexpExtractionResult;", "extracted", "", "start", "", "end", "fileName", "alt", "title", "(Ljava/lang/String;IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAlt", "()Ljava/lang/String;", "getFileName", "getTitle", "youtrack-application"})
    public static final class IssueAttachmentExtractionResult
    extends RegexpExtractionResult {
        @NotNull
        private final String fileName;
        @Nullable
        private final String alt;
        @Nullable
        private final String title;

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @Nullable
        public final String getAlt() {
            return this.alt;
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        public IssueAttachmentExtractionResult(@NotNull String extracted, int start2, int end, @NotNull String fileName, @Nullable String alt2, @Nullable String title2) {
            Intrinsics.checkParameterIsNotNull((Object)extracted, (String)"extracted");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            super(extracted, start2, end);
            this.fileName = fileName;
            this.alt = alt2;
            this.title = title2;
        }

        public /* synthetic */ IssueAttachmentExtractionResult(String string, int n, int n2, String string2, String string3, String string4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x10) != 0) {
                string3 = null;
            }
            if ((n3 & 0x20) != 0) {
                string4 = null;
            }
            this(string, n, n2, string2, string3, string4);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/markup/extensions/IssueAttachmentExtension$Companion;", "", "()V", "ISSUE_MAX_ATTACHMENTS_THRESHOLD", "", "youtrack-application"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

