/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.internal;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.youtrack.markup.internal.StaggeredDelimiterProcessor;
import org.commonmark.internal.Bracket;
import org.commonmark.internal.Delimiter;
import org.commonmark.internal.ReferenceParser;
import org.commonmark.internal.inline.AsteriskDelimiterProcessor;
import org.commonmark.internal.inline.UnderscoreDelimiterProcessor;
import org.commonmark.internal.util.Escaping;
import org.commonmark.internal.util.Html5Entities;
import org.commonmark.node.Code;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.Text;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;

public class PatchedInlineParserImpl
implements InlineParser,
ReferenceParser {
    private static final String ESCAPED_CHAR = "\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]";
    private static final String HTMLCOMMENT = "<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->";
    private static final String PROCESSINGINSTRUCTION = "[<][?].*?[?][>]";
    private static final String DECLARATION = "<![A-Z]+\\s+[^>]*>";
    private static final String CDATA = "<!\\[CDATA\\[[\\s\\S]*?\\]\\]>";
    private static final String HTMLTAG = "(?:<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>|</[A-Za-z][A-Za-z0-9-]*\\s*[>]|<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->|[<][?].*?[?][>]|<![A-Z]+\\s+[^>]*>|<!\\[CDATA\\[[\\s\\S]*?\\]\\]>)";
    private static final String ENTITY = "&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});";
    private static final String ASCII_PUNCTUATION = "!\"#\\$%&'\\(\\)\\*\\+,\\-\\./:;<=>\\?@\\[\\\\\\]\\^_`\\{\\|\\}~";
    private static final Pattern PUNCTUATION = Pattern.compile("^[!\"#\\$%&'\\(\\)\\*\\+,\\-\\./:;<=>\\?@\\[\\\\\\]\\^_`\\{\\|\\}~\\p{Pc}\\p{Pd}\\p{Pe}\\p{Pf}\\p{Pi}\\p{Po}\\p{Ps}]");
    private static final Pattern HTML_TAG = Pattern.compile("^(?:<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>|</[A-Za-z][A-Za-z0-9-]*\\s*[>]|<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->|[<][?].*?[?][>]|<![A-Z]+\\s+[^>]*>|<!\\[CDATA\\[[\\s\\S]*?\\]\\]>)", 2);
    private static final Pattern LINK_TITLE = Pattern.compile("^(?:\"(\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|[^\"\\x00])*\"|'(\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|[^'\\x00])*'|\\((\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|[^)\\x00])*\\))");
    private static final Pattern LINK_DESTINATION_BRACES = Pattern.compile("^(?:[<](?:[^<> \\t\\n\\\\]|\\\\.)*[>])");
    private static final Pattern LINK_LABEL = Pattern.compile("^\\[(?:[^\\\\\\[\\]]|\\\\.){0,512}\\]");
    private static final Pattern ESCAPABLE = Pattern.compile("^[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]");
    private static final Pattern ENTITY_HERE = Pattern.compile("^&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});", 2);
    private static final Pattern TICKS = Pattern.compile("`+");
    private static final Pattern TICKS_HERE = Pattern.compile("^`+");
    private static final Pattern EMAIL_AUTOLINK = Pattern.compile("^<([a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*)>");
    private static final Pattern AUTOLINK = Pattern.compile("^<[a-zA-Z][a-zA-Z0-9.+-]{1,31}:[^<>\u0000- ]*>");
    private static final Pattern SPNL = Pattern.compile("^ *(?:\n *)?");
    private static final Pattern UNICODE_WHITESPACE_CHAR = Pattern.compile("^[\\p{Zs}\t\r\n\f]");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern FINAL_SPACE = Pattern.compile(" *$");
    private static final Pattern LINE_END = Pattern.compile("^ *(?:\n|$)");
    private final BitSet specialCharacters;
    private final BitSet delimiterCharacters;
    private final Map<Character, DelimiterProcessor> delimiterProcessors;
    private Map<String, Link> referenceMap = new HashMap<String, Link>();
    private Node block;
    private String input;
    private int index;
    private Delimiter lastDelimiter;
    private Bracket lastBracket;

    public PatchedInlineParserImpl(List<DelimiterProcessor> delimiterProcessors) {
        this.delimiterProcessors = PatchedInlineParserImpl.calculateDelimiterProcessors(delimiterProcessors);
        this.delimiterCharacters = PatchedInlineParserImpl.calculateDelimiterCharacters(this.delimiterProcessors.keySet());
        this.specialCharacters = PatchedInlineParserImpl.calculateSpecialCharacters(this.delimiterCharacters);
    }

    public static BitSet calculateDelimiterCharacters(Set<Character> characters) {
        BitSet bitSet = new BitSet();
        for (Character character : characters) {
            bitSet.set(character.charValue());
        }
        return bitSet;
    }

    public static BitSet calculateSpecialCharacters(BitSet delimiterCharacters) {
        BitSet bitSet = new BitSet();
        bitSet.or(delimiterCharacters);
        bitSet.set(10);
        bitSet.set(96);
        bitSet.set(91);
        bitSet.set(93);
        bitSet.set(92);
        bitSet.set(33);
        bitSet.set(60);
        bitSet.set(38);
        return bitSet;
    }

    public static Map<Character, DelimiterProcessor> calculateDelimiterProcessors(List<DelimiterProcessor> delimiterProcessors) {
        HashMap<Character, DelimiterProcessor> map2 = new HashMap<Character, DelimiterProcessor>();
        PatchedInlineParserImpl.addDelimiterProcessors(Arrays.asList(new AsteriskDelimiterProcessor(), new UnderscoreDelimiterProcessor()), map2);
        PatchedInlineParserImpl.addDelimiterProcessors(delimiterProcessors, map2);
        return map2;
    }

    private static void addDelimiterProcessors(Iterable<DelimiterProcessor> delimiterProcessors, Map<Character, DelimiterProcessor> map2) {
        for (DelimiterProcessor delimiterProcessor : delimiterProcessors) {
            char closing;
            char opening = delimiterProcessor.getOpeningCharacter();
            if (opening == (closing = delimiterProcessor.getClosingCharacter())) {
                DelimiterProcessor old = map2.get(Character.valueOf(opening));
                if (old != null && old.getOpeningCharacter() == old.getClosingCharacter()) {
                    StaggeredDelimiterProcessor s;
                    if (old instanceof StaggeredDelimiterProcessor) {
                        s = (StaggeredDelimiterProcessor)old;
                    } else {
                        s = new StaggeredDelimiterProcessor(opening);
                        s.add(old);
                    }
                    s.add(delimiterProcessor);
                    map2.put(Character.valueOf(opening), s);
                    continue;
                }
                PatchedInlineParserImpl.addDelimiterProcessorForChar(opening, delimiterProcessor, map2);
                continue;
            }
            PatchedInlineParserImpl.addDelimiterProcessorForChar(opening, delimiterProcessor, map2);
            PatchedInlineParserImpl.addDelimiterProcessorForChar(closing, delimiterProcessor, map2);
        }
    }

    private static void addDelimiterProcessorForChar(char delimiterChar, DelimiterProcessor toAdd, Map<Character, DelimiterProcessor> delimiterProcessors) {
        DelimiterProcessor existing = delimiterProcessors.put(Character.valueOf(delimiterChar), toAdd);
        if (existing != null) {
            throw new IllegalArgumentException("Delimiter processor conflict with delimiter char '" + delimiterChar + "'");
        }
    }

    public void parse(String content, Node block) {
        boolean moreToParse;
        this.block = block;
        this.input = content.trim();
        this.index = 0;
        this.lastDelimiter = null;
        this.lastBracket = null;
        while (moreToParse = this.parseInline()) {
        }
        this.processDelimiters(null);
        this.mergeChildTextNodes(block);
    }

    public int parseReference(String s) {
        this.input = s;
        this.index = 0;
        int startIndex = this.index++;
        int matchChars = this.parseLinkLabel();
        if (matchChars == 0) {
            return 0;
        }
        String rawLabel = this.input.substring(0, matchChars);
        if (this.peek() != ':') {
            return 0;
        }
        this.spnl();
        String dest = this.parseLinkDestination();
        if (dest == null || dest.length() == 0) {
            return 0;
        }
        int beforeTitle = this.index;
        this.spnl();
        String title2 = this.parseLinkTitle();
        if (title2 == null) {
            this.index = beforeTitle;
        }
        boolean atLineEnd = true;
        if (this.index != this.input.length() && this.match(LINE_END) == null) {
            if (title2 == null) {
                atLineEnd = false;
            } else {
                title2 = null;
                this.index = beforeTitle;
                boolean bl = atLineEnd = this.match(LINE_END) != null;
            }
        }
        if (!atLineEnd) {
            return 0;
        }
        String normalizedLabel = Escaping.normalizeReference((String)rawLabel);
        if (normalizedLabel.isEmpty()) {
            return 0;
        }
        if (!this.referenceMap.containsKey(normalizedLabel)) {
            Link link = new Link(dest, title2);
            this.referenceMap.put(normalizedLabel, link);
        }
        return this.index - startIndex;
    }

    private Text appendText(CharSequence text, int beginIndex, int endIndex) {
        return this.appendText(text.subSequence(beginIndex, endIndex));
    }

    private Text appendText(CharSequence text) {
        Text node2 = new Text(text.toString());
        this.appendNode((Node)node2);
        return node2;
    }

    private void appendNode(Node node2) {
        this.block.appendChild(node2);
    }

    private boolean parseInline() {
        boolean res;
        char c = this.peek();
        if (c == '\u0000') {
            return false;
        }
        switch (c) {
            case '\n': {
                res = this.parseNewline();
                break;
            }
            case '\\': {
                res = this.parseBackslash();
                break;
            }
            case '`': {
                res = this.parseBackticks();
                break;
            }
            case '[': {
                res = this.parseOpenBracket();
                break;
            }
            case '!': {
                res = this.parseBang();
                break;
            }
            case ']': {
                res = this.parseCloseBracket();
                break;
            }
            case '<': {
                res = this.parseAutolink() || this.parseHtmlInline();
                break;
            }
            case '&': {
                res = this.parseEntity();
                break;
            }
            default: {
                boolean isDelimiter = this.delimiterCharacters.get(c);
                if (isDelimiter) {
                    DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(c));
                    res = this.parseDelimiters(delimiterProcessor, c);
                    break;
                }
                res = this.parseString();
            }
        }
        if (!res) {
            ++this.index;
            String literal = String.valueOf(c);
            this.appendText(literal);
        }
        return true;
    }

    private String match(Pattern re) {
        if (this.index >= this.input.length()) {
            return null;
        }
        Matcher matcher = re.matcher(this.input);
        matcher.region(this.index, this.input.length());
        boolean m = matcher.find();
        if (m) {
            this.index = matcher.end();
            return matcher.group();
        }
        return null;
    }

    private char peek() {
        if (this.index < this.input.length()) {
            return this.input.charAt(this.index);
        }
        return '\u0000';
    }

    private boolean spnl() {
        this.match(SPNL);
        return true;
    }

    private boolean parseNewline() {
        ++this.index;
        Node lastChild = this.block.getLastChild();
        if (lastChild != null && lastChild instanceof Text && ((Text)lastChild).getLiteral().endsWith(" ")) {
            int spaces;
            Text text = (Text)lastChild;
            String literal = text.getLiteral();
            Matcher matcher = FINAL_SPACE.matcher(literal);
            int n = spaces = matcher.find() ? matcher.end() - matcher.start() : 0;
            if (spaces > 0) {
                text.setLiteral(literal.substring(0, literal.length() - spaces));
            }
            this.appendNode((Node)(spaces >= 2 ? new HardLineBreak() : new SoftLineBreak()));
        } else {
            this.appendNode((Node)new SoftLineBreak());
        }
        while (this.peek() == ' ') {
            ++this.index;
        }
        return true;
    }

    private boolean parseBackslash() {
        ++this.index;
        if (this.peek() == '\n') {
            this.appendNode((Node)new HardLineBreak());
            ++this.index;
        } else if (this.index < this.input.length() && ESCAPABLE.matcher(this.input.substring(this.index, this.index + 1)).matches()) {
            this.appendText(this.input, this.index, this.index + 1);
            ++this.index;
        } else {
            this.appendText("\\");
        }
        return true;
    }

    private boolean parseBackticks() {
        String matched;
        String ticks = this.match(TICKS_HERE);
        if (ticks == null) {
            return false;
        }
        int afterOpenTicks = this.index;
        while ((matched = this.match(TICKS)) != null) {
            if (!matched.equals(ticks)) continue;
            Code node2 = new Code();
            String content = this.input.substring(afterOpenTicks, this.index - ticks.length());
            String literal = WHITESPACE.matcher(content.trim()).replaceAll(" ");
            node2.setLiteral(literal);
            this.appendNode((Node)node2);
            return true;
        }
        this.index = afterOpenTicks;
        this.appendText(ticks);
        return true;
    }

    private boolean parseDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        DelimiterData res = this.scanDelimiters(delimiterProcessor, delimiterChar);
        if (res == null) {
            return false;
        }
        int length = res.count;
        int startIndex = this.index;
        this.index += length;
        Text node2 = this.appendText(this.input, startIndex, this.index);
        this.lastDelimiter = new Delimiter(node2, delimiterChar, res.canOpen, res.canClose, this.lastDelimiter);
        this.lastDelimiter.length = length;
        this.lastDelimiter.originalLength = length;
        if (this.lastDelimiter.previous != null) {
            this.lastDelimiter.previous.next = this.lastDelimiter;
        }
        return true;
    }

    private boolean parseOpenBracket() {
        int startIndex = this.index++;
        Text node2 = this.appendText("[");
        this.addBracket(Bracket.link((Text)node2, (int)startIndex, (Bracket)this.lastBracket, (Delimiter)this.lastDelimiter));
        return true;
    }

    private boolean parseBang() {
        int startIndex = this.index++;
        if (this.peek() == '[') {
            ++this.index;
            Text node2 = this.appendText("![");
            this.addBracket(Bracket.image((Text)node2, (int)(startIndex + 1), (Bracket)this.lastBracket, (Delimiter)this.lastDelimiter));
        } else {
            this.appendText("!");
        }
        return true;
    }

    private boolean parseCloseBracket() {
        ++this.index;
        int startIndex = this.index++;
        Bracket opener = this.lastBracket;
        if (opener == null) {
            this.appendText("]");
            return true;
        }
        if (!opener.allowed) {
            this.appendText("]");
            this.removeLastBracket();
            return true;
        }
        String dest = null;
        String title2 = null;
        boolean isLinkOrImage = false;
        if (this.peek() == '(') {
            this.spnl();
            dest = this.parseLinkDestination();
            if (dest != null) {
                this.spnl();
                if (WHITESPACE.matcher(this.input.substring(this.index - 1, this.index)).matches()) {
                    title2 = this.parseLinkTitle();
                    this.spnl();
                }
                if (this.peek() == ')') {
                    ++this.index;
                    isLinkOrImage = true;
                } else {
                    this.index = startIndex;
                }
            }
        }
        if (!isLinkOrImage) {
            Link link;
            int beforeLabel = this.index;
            int labelLength = this.parseLinkLabel();
            String ref = null;
            if (labelLength > 2) {
                ref = this.input.substring(beforeLabel, beforeLabel + labelLength);
            } else if (!opener.bracketAfter) {
                ref = this.input.substring(opener.index, startIndex);
            }
            if (ref != null && (link = this.referenceMap.get(Escaping.normalizeReference((String)ref))) != null) {
                dest = link.getDestination();
                title2 = link.getTitle();
                isLinkOrImage = true;
            }
        }
        if (isLinkOrImage) {
            Image linkOrImage = opener.image ? new Image(dest, title2) : new Link(dest, title2);
            Node node2 = opener.node.getNext();
            while (node2 != null) {
                Node next = node2.getNext();
                linkOrImage.appendChild(node2);
                node2 = next;
            }
            this.appendNode((Node)linkOrImage);
            this.processDelimiters(opener.previousDelimiter);
            this.mergeChildTextNodes((Node)linkOrImage);
            opener.node.unlink();
            this.removeLastBracket();
            if (!opener.image) {
                Bracket bracket = this.lastBracket;
                while (bracket != null) {
                    if (!bracket.image) {
                        bracket.allowed = false;
                    }
                    bracket = bracket.previous;
                }
            }
            return true;
        }
        this.appendText("]");
        this.removeLastBracket();
        this.index = startIndex;
        return true;
    }

    private void addBracket(Bracket bracket) {
        if (this.lastBracket != null) {
            this.lastBracket.bracketAfter = true;
        }
        this.lastBracket = bracket;
    }

    private void removeLastBracket() {
        this.lastBracket = this.lastBracket.previous;
    }

    private String parseLinkDestination() {
        String res = this.match(LINK_DESTINATION_BRACES);
        if (res != null) {
            if (res.length() == 2) {
                return "";
            }
            return Escaping.unescapeString((String)res.substring(1, res.length() - 1));
        }
        int startIndex = this.index;
        this.parseLinkDestinationWithBalancedParens();
        return Escaping.unescapeString((String)this.input.substring(startIndex, this.index));
    }

    private void parseLinkDestinationWithBalancedParens() {
        int parens = 0;
        while (true) {
            char c = this.peek();
            switch (c) {
                case '\u0000': {
                    return;
                }
                case '\\': {
                    ++this.index;
                    if (this.peek() != '\u0000') break;
                    return;
                }
                case '(': {
                    ++parens;
                    break;
                }
                case ')': {
                    if (parens == 0) {
                        return;
                    }
                    --parens;
                    break;
                }
                case ' ': {
                    return;
                }
                default: {
                    if (!Character.isISOControl(c)) break;
                    return;
                }
            }
            ++this.index;
        }
    }

    private String parseLinkTitle() {
        String title2 = this.match(LINK_TITLE);
        if (title2 != null) {
            return Escaping.unescapeString((String)title2.substring(1, title2.length() - 1));
        }
        return null;
    }

    private int parseLinkLabel() {
        String m = this.match(LINK_LABEL);
        if (m == null || m.length() > 1001) {
            return 0;
        }
        return m.length();
    }

    private boolean parseAutolink() {
        String m = this.match(EMAIL_AUTOLINK);
        if (m != null) {
            String dest = m.substring(1, m.length() - 1);
            Link node2 = new Link("mailto:" + dest, null);
            node2.appendChild((Node)new Text(dest));
            this.appendNode((Node)node2);
            return true;
        }
        m = this.match(AUTOLINK);
        if (m != null) {
            String dest = m.substring(1, m.length() - 1);
            Link node3 = new Link(dest, null);
            node3.appendChild((Node)new Text(dest));
            this.appendNode((Node)node3);
            return true;
        }
        return false;
    }

    private boolean parseHtmlInline() {
        String m = this.match(HTML_TAG);
        if (m != null) {
            HtmlInline node2 = new HtmlInline();
            node2.setLiteral(m);
            this.appendNode((Node)node2);
            return true;
        }
        return false;
    }

    private boolean parseEntity() {
        String m = this.match(ENTITY_HERE);
        if (m != null) {
            this.appendText(Html5Entities.entityToString((String)m));
            return true;
        }
        return false;
    }

    private boolean parseString() {
        int begin = this.index;
        int length = this.input.length();
        while (this.index != length && !this.specialCharacters.get(this.input.charAt(this.index))) {
            ++this.index;
        }
        if (begin != this.index) {
            this.appendText(this.input, begin, this.index);
            return true;
        }
        return false;
    }

    private DelimiterData scanDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        boolean canClose;
        boolean canOpen;
        boolean rightFlanking;
        int startIndex = this.index;
        int delimiterCount = 0;
        while (this.peek() == delimiterChar) {
            ++delimiterCount;
            ++this.index;
        }
        if (delimiterCount < delimiterProcessor.getMinLength()) {
            this.index = startIndex;
            return null;
        }
        String before = startIndex == 0 ? "\n" : this.input.substring(startIndex - 1, startIndex);
        char charAfter = this.peek();
        String after = charAfter == '\u0000' ? "\n" : String.valueOf(charAfter);
        boolean beforeIsPunctuation = PUNCTUATION.matcher(before).matches();
        boolean beforeIsWhitespace = UNICODE_WHITESPACE_CHAR.matcher(before).matches();
        boolean afterIsPunctuation = PUNCTUATION.matcher(after).matches();
        boolean afterIsWhitespace = UNICODE_WHITESPACE_CHAR.matcher(after).matches();
        boolean leftFlanking = !afterIsWhitespace && (!afterIsPunctuation || beforeIsWhitespace || beforeIsPunctuation);
        boolean bl = rightFlanking = !beforeIsWhitespace && (!beforeIsPunctuation || afterIsWhitespace || afterIsPunctuation);
        if (delimiterChar == '_') {
            canOpen = leftFlanking && (!rightFlanking || beforeIsPunctuation);
            canClose = rightFlanking && (!leftFlanking || afterIsPunctuation);
        } else {
            canOpen = leftFlanking && delimiterChar == delimiterProcessor.getOpeningCharacter();
            canClose = rightFlanking && delimiterChar == delimiterProcessor.getClosingCharacter();
        }
        this.index = startIndex;
        return new DelimiterData(delimiterCount, canOpen, canClose);
    }

    private void processDelimiters(Delimiter stackBottom) {
        HashMap<Character, Delimiter> openersBottom = new HashMap<Character, Delimiter>();
        Delimiter closer = this.lastDelimiter;
        while (closer != null && closer.previous != stackBottom) {
            closer = closer.previous;
        }
        while (closer != null) {
            char delimiterChar = closer.delimiterChar;
            DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(delimiterChar));
            if (!closer.canClose || delimiterProcessor == null) {
                closer = closer.next;
                continue;
            }
            char openingDelimiterChar = delimiterProcessor.getOpeningCharacter();
            int useDelims = 0;
            boolean openerFound = false;
            boolean potentialOpenerFound = false;
            Delimiter opener = closer.previous;
            while (opener != null && opener != stackBottom && opener != openersBottom.get(Character.valueOf(delimiterChar))) {
                if (opener.canOpen && opener.delimiterChar == openingDelimiterChar) {
                    potentialOpenerFound = true;
                    useDelims = delimiterProcessor.getDelimiterUse((DelimiterRun)opener, (DelimiterRun)closer);
                    if (useDelims > 0) {
                        openerFound = true;
                        break;
                    }
                }
                opener = opener.previous;
            }
            if (!openerFound) {
                if (!potentialOpenerFound) {
                    openersBottom.put(Character.valueOf(delimiterChar), closer.previous);
                    if (!closer.canOpen) {
                        this.removeDelimiterKeepNode(closer);
                    }
                }
                closer = closer.next;
                continue;
            }
            Text openerNode = opener.node;
            Text closerNode = closer.node;
            opener.length -= useDelims;
            closer.length -= useDelims;
            openerNode.setLiteral(openerNode.getLiteral().substring(0, openerNode.getLiteral().length() - useDelims));
            closerNode.setLiteral(closerNode.getLiteral().substring(0, closerNode.getLiteral().length() - useDelims));
            this.removeDelimitersBetween(opener, closer);
            this.mergeTextNodesBetweenExclusive((Node)openerNode, (Node)closerNode);
            delimiterProcessor.process(openerNode, closerNode, useDelims);
            if (opener.length == 0) {
                this.removeDelimiterAndNode(opener);
            }
            if (closer.length != 0) continue;
            Delimiter next = closer.next;
            this.removeDelimiterAndNode(closer);
            closer = next;
        }
        while (this.lastDelimiter != null && this.lastDelimiter != stackBottom) {
            this.removeDelimiterKeepNode(this.lastDelimiter);
        }
    }

    private void removeDelimitersBetween(Delimiter opener, Delimiter closer) {
        Delimiter delimiter = closer.previous;
        while (delimiter != null && delimiter != opener) {
            Delimiter previousDelimiter = delimiter.previous;
            this.removeDelimiterKeepNode(delimiter);
            delimiter = previousDelimiter;
        }
    }

    private void removeDelimiterAndNode(Delimiter delim) {
        Text node2 = delim.node;
        node2.unlink();
        this.removeDelimiter(delim);
    }

    private void removeDelimiterKeepNode(Delimiter delim) {
        this.removeDelimiter(delim);
    }

    private void removeDelimiter(Delimiter delim) {
        if (delim.previous != null) {
            delim.previous.next = delim.next;
        }
        if (delim.next == null) {
            this.lastDelimiter = delim.previous;
        } else {
            delim.next.previous = delim.previous;
        }
    }

    private void mergeTextNodesBetweenExclusive(Node fromNode, Node toNode) {
        if (fromNode == toNode || fromNode.getNext() == toNode) {
            return;
        }
        this.mergeTextNodesInclusive(fromNode.getNext(), toNode.getPrevious());
    }

    private void mergeChildTextNodes(Node node2) {
        if (node2.getFirstChild() == node2.getLastChild()) {
            return;
        }
        this.mergeTextNodesInclusive(node2.getFirstChild(), node2.getLastChild());
    }

    private void mergeTextNodesInclusive(Node fromNode, Node toNode) {
        Text first = null;
        Text last = null;
        int length = 0;
        for (Node node2 = fromNode; node2 != null; node2 = node2.getNext()) {
            if (node2 instanceof Text) {
                Text text = (Text)node2;
                if (first == null) {
                    first = text;
                }
                length += text.getLiteral().length();
                last = text;
            } else {
                this.mergeIfNeeded(first, last, length);
                first = null;
                last = null;
                length = 0;
            }
            if (node2 == toNode) break;
        }
        this.mergeIfNeeded(first, last, length);
    }

    private void mergeIfNeeded(Text first, Text last, int textLength) {
        if (first != null && last != null && first != last) {
            StringBuilder sb = new StringBuilder(textLength);
            sb.append(first.getLiteral());
            Node stop2 = last.getNext();
            for (Node node2 = first.getNext(); node2 != stop2; node2 = node2.getNext()) {
                sb.append(((Text)node2).getLiteral());
                Node unlink = node2;
                unlink.unlink();
            }
            String literal = sb.toString();
            first.setLiteral(literal);
        }
    }

    private static class DelimiterData {
        final int count;
        final boolean canClose;
        final boolean canOpen;

        DelimiterData(int count, boolean canOpen, boolean canClose) {
            this.count = count;
            this.canOpen = canOpen;
            this.canClose = canClose;
        }
    }
}

