/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.renderer;

import java.util.Set;
import jetbrains.youtrack.markup.extensions.CommitLink;
import jetbrains.youtrack.markup.extensions.EntityLink;
import jetbrains.youtrack.markup.extensions.InaccessibleUserLink;
import jetbrains.youtrack.markup.extensions.IssueLink;
import jetbrains.youtrack.markup.extensions.UserLink;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/markup/renderer/EntityLinkRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "Lorg/commonmark/node/AbstractVisitor;", "context", "Lorg/commonmark/renderer/html/HtmlNodeRendererContext;", "(Lorg/commonmark/renderer/html/HtmlNodeRendererContext;)V", "html", "Lorg/commonmark/renderer/html/HtmlWriter;", "getNodeTypes", "", "Ljava/lang/Class;", "Ljetbrains/youtrack/markup/extensions/EntityLink;", "render", "", "node", "Lorg/commonmark/node/Node;", "renderChildren", "parent", "youtrack-application"})
public final class EntityLinkRenderer
extends AbstractVisitor
implements NodeRenderer {
    private final HtmlWriter html;
    private final HtmlNodeRendererContext context;

    @NotNull
    public Set<Class<? extends EntityLink>> getNodeTypes() {
        return SetsKt.setOf((Object[])new Class[]{UserLink.class, InaccessibleUserLink.class, IssueLink.class, CommitLink.class});
    }

    public void render(@NotNull Node node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        if (node2.getParent() instanceof Link) {
            this.renderChildren(node2);
        } else if (node2 instanceof EntityLink && ((EntityLink)node2).getNavigable()) {
            this.html.tag("a", this.context.extendAttributes(node2, "a", ((EntityLink)node2).getAttributesMap()));
            this.renderChildren(node2);
            this.html.tag("/a");
        } else {
            this.html.tag("b", this.context.extendAttributes(node2, "a", ((EntityLink)node2).getAttributesMap()));
            this.renderChildren(node2);
            this.html.tag("/b");
        }
    }

    private final void renderChildren(Node parent2) {
        Node node2 = parent2.getFirstChild();
        while (node2 != null) {
            Node next = node2.getNext();
            this.context.render(node2);
            node2 = next;
        }
    }

    public EntityLinkRenderer(@NotNull HtmlNodeRendererContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
        HtmlWriter htmlWriter = this.context.getWriter();
        Intrinsics.checkExpressionValueIsNotNull((Object)htmlWriter, (String)"context.writer");
        this.html = htmlWriter;
    }
}

