/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.renderer;

import java.util.Map;
import java.util.Set;
import jetbrains.youtrack.markup.MarkdownExceptionsProcessor;
import jetbrains.youtrack.markup.extensions.StacktraceNode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0014\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/markup/renderer/StacktraceHtmlRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "context", "Lorg/commonmark/renderer/html/HtmlNodeRendererContext;", "(Lorg/commonmark/renderer/html/HtmlNodeRendererContext;)V", "stacktraceBodyRenderer", "Ljetbrains/youtrack/markup/MarkdownExceptionsProcessor;", "getExpandCollapseIconAttributes", "", "", "getNodeTypes", "", "Ljava/lang/Class;", "Ljetbrains/youtrack/markup/extensions/StacktraceNode;", "render", "", "node", "Lorg/commonmark/node/Node;", "youtrack-application"})
public final class StacktraceHtmlRenderer
implements NodeRenderer {
    private final MarkdownExceptionsProcessor stacktraceBodyRenderer;
    private final HtmlNodeRendererContext context;

    @NotNull
    public Set<Class<StacktraceNode>> getNodeTypes() {
        return SetsKt.setOf(StacktraceNode.class);
    }

    public void render(@NotNull Node node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        HtmlWriter htmlWriter = this.context.getWriter();
        Intrinsics.checkExpressionValueIsNotNull((Object)htmlWriter, (String)"context.writer");
        HtmlWriter html = htmlWriter;
        StacktraceNode stacktraceNode = (StacktraceNode)node2;
        html.tag("div", MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)"wiki-exception-wrapper")));
        html.tag("span", this.getExpandCollapseIconAttributes());
        html.tag("/span");
        if (BeansKt.getMarkdownProcessingContext().getExpandStacktraces()) {
            html.tag("pre", MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)"wiki-exception-title wiki-hidden")));
            html.text(stacktraceNode.getTitle());
            html.tag("/pre");
            html.tag("span", MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)"wiki-hellip wiki-hidden")));
            html.text("...");
            html.tag("/span");
            html.tag("pre", this.context.extendAttributes(node2, "pre", MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)"wiki-exception"))));
            html.raw(this.stacktraceBodyRenderer.render(stacktraceNode.getStacktrace()));
            html.tag("/pre");
            html.tag("/div");
        } else {
            html.tag("pre", MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)"wiki-exception-title")));
            html.text(stacktraceNode.getTitle());
            html.tag("/pre");
            html.tag("span", MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)"wiki-hellip")));
            html.text("...");
            html.tag("/span");
            html.tag("pre", this.context.extendAttributes(node2, "pre", MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)"wiki-exception wiki-hidden"))));
            html.raw(this.stacktraceBodyRenderer.render(stacktraceNode.getStacktrace()));
            html.tag("/pre");
            html.tag("/div");
        }
        if (!BeansKt.getMarkdownProcessingContext().getNoJs() && !BeansKt.getMarkdownProcessingContext().getNoCss()) {
            html.tag("script");
            html.text("setTimeout(charisma.Idea.layoutWikiLinks, 1000)");
            html.tag("/script");
        }
    }

    private final Map<String, String> getExpandCollapseIconAttributes() {
        String classNames = BeansKt.getMarkdownProcessingContext().getExpandStacktraces() ? "wiki-plus wiki-minus" : "wiki-plus";
        return BeansKt.getMarkdownProcessingContext().getNoJs() ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)classNames)) : MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"class", (Object)classNames), TuplesKt.to((Object)"onclick", (Object)"WikiUtil.wikiCollapse(this)")});
    }

    public StacktraceHtmlRenderer(@NotNull HtmlNodeRendererContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
        this.stacktraceBodyRenderer = new MarkdownExceptionsProcessor();
    }
}

