/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.persistent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.project.CloneBasedProjectTemplate;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.persistent.ProjectCloneHandler;
import jetbrains.youtrack.persistent.ProjectCloneHandlers;
import jetbrains.youtrack.persistent.XdProject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0010\u001a\u00020\rH\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/persistent/ProjectCloneHandlers;", "", "()V", "handlers", "", "Ljetbrains/youtrack/persistent/ProjectCloneHandler;", "getHandlers", "()Ljava/util/List;", "setHandlers", "(Ljava/util/List;)V", "applyHandlers", "", "source", "Ljetbrains/youtrack/persistent/XdProject;", "target", "clone", "project", "generateCloneName", "Lkotlin/Pair;", "", "Companion", "youtrack-application"})
public final class ProjectCloneHandlers {
    @Autowired
    @NotNull
    public List<? extends ProjectCloneHandler> handlers;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<ProjectCloneHandler> getHandlers() {
        List<ProjectCloneHandler> list = this.handlers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"handlers");
        }
        return list;
    }

    public final void setHandlers(@NotNull List<? extends ProjectCloneHandler> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.handlers = list;
    }

    @NotNull
    public final XdProject clone(@NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)project2), (String)"project");
        Companion.getLogger().info("Cloning project " + project2.getDisplayName() + " (" + project2.getShortName() + ')');
        Pair<String, String> name2 = this.generateCloneName(project2);
        Entity entity2 = new CloneBasedProjectTemplate.CloneBasedProjectBuilder(project2).withName((String)name2.getFirst()).withShortName((String)name2.getSecond()).withLeader(BeansKt.getCurrentUser().get()).withCreatedBy(BeansKt.getCurrentUser().get()).withDescription(project2.getDescription()).buildProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"CloneBasedProjectTemplat\u2026          .buildProject()");
        XdProject clone = (XdProject)XdExtensionsKt.toXd((Entity)entity2);
        Companion.getLogger().info("A clone for project " + project2.getDisplayName() + " (" + project2.getShortName() + ") has been created");
        return clone;
    }

    public final void applyHandlers(@NotNull XdProject source, @NotNull XdProject target) {
        Object it;
        ProjectCloneHandler it2;
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)source), (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)((Object)target), (String)"target");
        List<? extends ProjectCloneHandler> list = this.handlers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"handlers");
        }
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            it2 = (ProjectCloneHandler)element$iv$iv;
            boolean bl = false;
            if (!(it2.getPrerequisites() == ProjectCloneHandler.Prerequisites.NONE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (ProjectCloneHandler)element$iv;
            boolean bl = false;
            it.clone(source, target);
        }
        List<? extends ProjectCloneHandler> list2 = this.handlers;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"handlers");
        }
        $receiver$iv = list2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            Object element$iv$iv = it.next();
            it2 = (ProjectCloneHandler)element$iv$iv;
            boolean bl = false;
            if (!(it2.getPrerequisites() == ProjectCloneHandler.Prerequisites.CLONED_CUSTOM_FIELDS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (ProjectCloneHandler)element$iv;
            boolean bl = false;
            it.clone(source, target);
        }
        List<? extends ProjectCloneHandler> list3 = this.handlers;
        if (list3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"handlers");
        }
        $receiver$iv = list3;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            Object element$iv$iv = it.next();
            it2 = (ProjectCloneHandler)element$iv$iv;
            boolean bl = false;
            if (!(it2.getPrerequisites() == ProjectCloneHandler.Prerequisites.CLONED_BOARDS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (ProjectCloneHandler)element$iv;
            boolean bl = false;
            it.clone(source, target);
        }
        LegacySupportKt.flush();
        List<? extends ProjectCloneHandler> list4 = this.handlers;
        if (list4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"handlers");
        }
        $receiver$iv = list4;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            Object element$iv$iv = it.next();
            it2 = (ProjectCloneHandler)element$iv$iv;
            boolean bl = false;
            if (!(it2.getPrerequisites() == ProjectCloneHandler.Prerequisites.FLUSH)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (ProjectCloneHandler)element$iv;
            boolean bl = false;
            it.clone(source, target);
        }
    }

    private final Pair<String, String> generateCloneName(XdProject project2) {
        Pair pair;
        generateCloneName.1 tryNames$ = generateCloneName.1.INSTANCE;
        String name2 = "Clone of " + project2.getName();
        String shortName = project2.getShortName() + "Clone";
        int suffix = 1;
        if (tryNames$.invoke(name2, shortName)) {
            pair = TuplesKt.to((Object)name2, (Object)shortName);
        } else {
            while (!tryNames$.invoke(name2 + " (" + suffix + ')', shortName + suffix)) {
                ++suffix;
            }
            pair = TuplesKt.to((Object)(name2 + " (" + suffix + ')'), (Object)(shortName + suffix));
        }
        return pair;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/persistent/ProjectCloneHandlers$Companion;", "Lmu/KLogging;", "()V", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

