/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.persistent.security;

import jetbrains.charisma.persistent.BeansKt;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.persistent.XdIssueComment;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.persistent.security.IssueAttachmentSecurityServiceImplKt;
import jetbrains.youtrack.persistent.security.IssueCommentSecurityServiceImplKt;
import jetbrains.youtrack.persistent.security.IssueSecurityServiceImplKt;
import jetbrains.youtrack.persistent.security.SecurityCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/persistent/security/BasicSecurityCache;", "Ljetbrains/youtrack/persistent/security/SecurityCache;", "()V", "hasPermission", "", "entityType", "", "operation", "Ljetbrains/youtrack/core/security/Operation;", "project", "Ljetbrains/youtrack/persistent/XdProject;", "user", "Ljetbrains/youtrack/persistent/XdUser;", "hasPermissionInProject", "permission", "Ljetbrains/youtrack/core/security/Permission;", "isAccessible", "xdEntity", "Lkotlinx/dnq/XdEntity;", "isUserInGroups", "groups", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/youtrack/persistent/XdUserGroup;", "youtrack-application"})
public final class BasicSecurityCache
implements SecurityCache {
    @Override
    public boolean hasPermissionInProject(@NotNull Permission permission, @NotNull XdProject project2, @NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)((Object)project2), (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)user2), (String)"user");
        return BeansKt.getSecurity().hasPermission(user2.getEntity(), permission, project2.getEntity());
    }

    @Override
    public boolean hasPermission(@NotNull String entityType2, @NotNull Operation operation, @NotNull XdProject project2, @NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)entityType2, (String)"entityType");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)((Object)project2), (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)user2), (String)"user");
        return user2.hasPermission(entityType2, operation, project2);
    }

    @Override
    public boolean isUserInGroups(@NotNull XdQuery<? extends XdUserGroup> groups2, @NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull(groups2, (String)"groups");
        Intrinsics.checkParameterIsNotNull((Object)((Object)user2), (String)"user");
        return XdQueryKt.isNotEmpty((XdQuery)XdQueryKt.intersect(groups2, (XdQuery)((XdQuery)user2.getGroups())));
    }

    @Override
    public boolean isAccessible(@NotNull XdEntity xdEntity, @NotNull Operation operation, @NotNull XdUser user2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)xdEntity, (String)"xdEntity");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)((Object)user2), (String)"user");
        XdEntity xdEntity2 = xdEntity;
        if (xdEntity2 instanceof XdIssue) {
            bl = IssueSecurityServiceImplKt.getIssueSecurityService().isAccessible((XdIssue)xdEntity, operation, user2, (SecurityCache)this);
        } else if (xdEntity2 instanceof XdIssueAttachment) {
            bl = IssueAttachmentSecurityServiceImplKt.getIssueAttachmentSecurityService().isAccessible((XdIssueAttachment)xdEntity, operation, user2, (SecurityCache)this);
        } else if (xdEntity2 instanceof XdIssueComment) {
            bl = IssueCommentSecurityServiceImplKt.getIssueCommentSecurityService().isAccessible((XdIssueComment)xdEntity, operation, user2, (SecurityCache)this);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported " + xdEntity.getEntity().getType());
        }
        return bl;
    }
}

