/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.UriInfo;
import jetbrains.gap.resource.Entity;
import jetbrains.gap.resource.Resource;
import jetbrains.youtrack.gaprest.filters.AuthIgnored;
import jetbrains.youtrack.rest.PathToAnonymousResource;
import jetbrains.youtrack.rest.Segment;
import jetbrains.youtrack.rest.StringSegment;
import jetbrains.youtrack.rest.WildcardSegment;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0001H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002J\b\u0010!\u001a\u00020\u0015H\u0007J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u000e\u00a8\u0006("}, d2={"Ljetbrains/youtrack/rest/AuthIgnoredResourceAnalyzer;", "", "()V", "gapAuthIgnoredResources", "Ljava/util/ArrayList;", "Ljetbrains/youtrack/rest/PathToAnonymousResource;", "Lkotlin/collections/ArrayList;", "resources", "", "Ljetbrains/gap/resource/Resource;", "Ljetbrains/gap/resource/Entity;", "getResources", "()Ljava/util/Collection;", "setResources", "(Ljava/util/Collection;)V", "webrAuthIgnoredResources", "webrResources", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "getWebrResources", "setWebrResources", "analyzeResources", "", "input", "output", "", "resourceType", "", "extractPath", "resource", "extractPathFromMethod", "method", "Ljava/lang/reflect/Method;", "pathFromClass", "init", "isAnonymousAccessAllowed", "", "request", "Ljavax/ws/rs/container/ContainerRequestContext;", "isGapRequest", "Companion", "youtrack-application"})
public class AuthIgnoredResourceAnalyzer {
    @Autowired
    @NotNull
    public Collection<? extends Resource<? extends Entity>> resources;
    @Autowired
    @NotNull
    public Collection<? extends jetbrains.mps.webr.rpc.rest.runtime.Resource> webrResources;
    private final ArrayList<PathToAnonymousResource> gapAuthIgnoredResources;
    private final ArrayList<PathToAnonymousResource> webrAuthIgnoredResources;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Collection<Resource<? extends Entity>> getResources() {
        Collection<? extends Resource<? extends Entity>> collection = this.resources;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
        }
        return collection;
    }

    public final void setResources(@NotNull Collection<? extends Resource<? extends Entity>> collection) {
        Intrinsics.checkParameterIsNotNull(collection, (String)"<set-?>");
        this.resources = collection;
    }

    @NotNull
    public final Collection<jetbrains.mps.webr.rpc.rest.runtime.Resource> getWebrResources() {
        Collection<jetbrains.mps.webr.rpc.rest.runtime.Resource> collection = this.webrResources;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webrResources");
        }
        return collection;
    }

    public final void setWebrResources(@NotNull Collection<? extends jetbrains.mps.webr.rpc.rest.runtime.Resource> collection) {
        Intrinsics.checkParameterIsNotNull(collection, (String)"<set-?>");
        this.webrResources = collection;
    }

    @PostConstruct
    public final void init() {
        Collection<? extends Resource<? extends Entity>> collection = this.resources;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
        }
        this.analyzeResources(collection, (List<PathToAnonymousResource>)this.gapAuthIgnoredResources, "gap");
        Collection<? extends jetbrains.mps.webr.rpc.rest.runtime.Resource> collection2 = this.webrResources;
        if (collection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webrResources");
        }
        this.analyzeResources(collection2, (List<PathToAnonymousResource>)this.webrAuthIgnoredResources, "webr");
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzeResources(Collection<? extends Object> input, List<PathToAnonymousResource> output2, String resourceType) {
        Iterable $receiver$iv = input;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            void $receiver$iv$iv;
            Method[] $receiver$iv2;
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            if (!it.getClass().isAnnotationPresent(AuthIgnored.class)) continue;
            PathToAnonymousResource extractedPath = this.extractPath(it);
            output2.add(extractedPath);
            Intrinsics.checkExpressionValueIsNotNull((Object)it.getClass().getMethods(), (String)"it.javaClass.methods");
            Method[] methodArray = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList();
            void var13_14 = $receiver$iv$iv;
            int n = ((void)var13_14).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it2 = element$iv$iv = var13_14[i];
                boolean bl2 = false;
                if (!it2.isAnnotationPresent(AuthIgnored.class)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterator iterator3 = ((List)destination$iv$iv).iterator();
            while (iterator3.hasNext()) {
                PathToAnonymousResource pathToAnonymousResource;
                Method method2;
                Method method3 = method2 = (Method)iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)method3, (String)"method");
                if (this.extractPathFromMethod(method3, extractedPath) == null) continue;
                PathToAnonymousResource it3 = pathToAnonymousResource;
                boolean bl3 = false;
                output2.add(it3);
            }
        }
    }

    public final boolean isAnonymousAccessAllowed(@NotNull ContainerRequestContext request) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            ArrayList<PathToAnonymousResource> resources = this.isGapRequest(request) ? this.gapAuthIgnoredResources : this.webrAuthIgnoredResources;
            Iterable $receiver$iv = resources;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    PathToAnonymousResource it = (PathToAnonymousResource)element$iv;
                    boolean bl2 = false;
                    UriInfo uriInfo = request.getUriInfo();
                    Intrinsics.checkExpressionValueIsNotNull((Object)uriInfo, (String)"request.uriInfo");
                    List list = uriInfo.getPathSegments();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"request.uriInfo.pathSegments");
                    if (!it.matches(list)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final PathToAnonymousResource extractPathFromMethod(Method method2, PathToAnonymousResource pathFromClass) {
        PathToAnonymousResource pathToAnonymousResource;
        Path pathFromAnnotation;
        Path path = pathFromAnnotation = method2.isAnnotationPresent(Path.class) ? method2.getAnnotation(Path.class) : null;
        if (path != null) {
            CharSequence charSequence;
            String it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Path path2;
            Path it2 = path2 = path;
            boolean bl = false;
            Iterable iterable = $receiver$iv = (Iterable)StringsKt.split$default((CharSequence)it2.value(), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl2 = false;
                charSequence = it;
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Regex regex = new Regex(".*\\{.*}.*");
                charSequence = it;
                Segment segment = regex.matches(charSequence) ? (Segment)new WildcardSegment() : (Segment)new StringSegment(it);
                collection.add(segment);
            }
            List segments = (List)destination$iv$iv;
            pathToAnonymousResource = new PathToAnonymousResource(pathFromClass, segments);
        } else {
            pathToAnonymousResource = null;
        }
        return pathToAnonymousResource;
    }

    /*
     * WARNING - void declaration
     */
    private final PathToAnonymousResource extractPath(Object resource2) {
        List list;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Path path = resource2.getClass().getAnnotation(Path.class);
        if (path == null) {
            throw (Throwable)new IllegalStateException("Rest resource without path: " + resource2.getClass().getCanonicalName());
        }
        Path path2 = path;
        Iterable iterable = $receiver$iv = (Iterable)StringsKt.split$default((CharSequence)path2.value(), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = list = (List)destination$iv$iv;
        return new PathToAnonymousResource(list2);
    }

    private final boolean isGapRequest(ContainerRequestContext request) {
        UriInfo uriInfo = request.getUriInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriInfo, (String)"request.uriInfo");
        String string = uriInfo.getBaseUri().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.uriInfo.baseUri.toString()");
        return StringsKt.endsWith$default((String)string, (String)"/api/", (boolean)false, (int)2, null);
    }

    public AuthIgnoredResourceAnalyzer() {
        AuthIgnoredResourceAnalyzer authIgnoredResourceAnalyzer = this;
        ArrayList arrayList = new ArrayList();
        authIgnoredResourceAnalyzer.gapAuthIgnoredResources = arrayList;
        this.webrAuthIgnoredResources = CollectionsKt.arrayListOf((Object[])new PathToAnonymousResource[]{new PathToAnonymousResource(CollectionsKt.listOf((Object[])new String[]{"user", "login"})), new PathToAnonymousResource(CollectionsKt.listOf((Object[])new String[]{"user", "current"}))});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/rest/AuthIgnoredResourceAnalyzer$Companion;", "Lmu/KLogging;", "()V", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

