/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.compress;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.exodus.util.LightByteArrayOutputStream;
import jetbrains.youtrack.event.compress.DiffWindowEncoder;
import jetbrains.youtrack.event.compress.VcDiffConfig;
import jetbrains.youtrack.event.compress.VlqEncoder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/event/compress/VcDiffOutputStream;", "Ljava/io/OutputStream;", "config", "Ljetbrains/youtrack/event/compress/VcDiffConfig;", "windowEncoder", "Ljetbrains/youtrack/event/compress/DiffWindowEncoder;", "previousSource", "Ljava/io/InputStream;", "delta", "(Ljetbrains/youtrack/event/compress/VcDiffConfig;Ljetbrains/youtrack/event/compress/DiffWindowEncoder;Ljava/io/InputStream;Ljava/io/OutputStream;)V", "ratioTested", "", "tempOutput", "Ljetbrains/exodus/util/LightByteArrayOutputStream;", "windowSize", "", "close", "", "flushTempOutput", "flushTempOutputIfNecessary", "write", "b", "", "off", "len", "youtrack-events"})
public final class VcDiffOutputStream
extends OutputStream {
    private final int windowSize;
    private LightByteArrayOutputStream tempOutput;
    private boolean ratioTested;
    private final DiffWindowEncoder windowEncoder;
    private final InputStream previousSource;
    private final OutputStream delta;

    @Override
    public void write(int b) {
        LightByteArrayOutputStream output = this.tempOutput;
        if (output == null) {
            this.delta.write(b);
        } else {
            output.write(b);
            this.flushTempOutputIfNecessary();
        }
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        LightByteArrayOutputStream output = this.tempOutput;
        if (output == null) {
            this.delta.write(b, off, len);
        } else {
            output.write(b, off, len);
            this.flushTempOutputIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Closeable closeable = this.delta;
        Throwable throwable = null;
        try {
            OutputStream delta = (OutputStream)closeable;
            boolean bl = false;
            if (this.tempOutput != null) {
                while (true) {
                    LightByteArrayOutputStream lightByteArrayOutputStream = this.tempOutput;
                    if (lightByteArrayOutputStream == null) {
                        Intrinsics.throwNpe();
                    }
                    if (lightByteArrayOutputStream.size() <= 0) break;
                    this.flushTempOutput();
                    if (this.tempOutput != null) continue;
                    return;
                }
                if (this.ratioTested) {
                    VlqEncoder.INSTANCE.writeInt(0, delta);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void flushTempOutputIfNecessary() {
        while (this.tempOutput != null) {
            LightByteArrayOutputStream lightByteArrayOutputStream = this.tempOutput;
            if (lightByteArrayOutputStream == null) {
                Intrinsics.throwNpe();
            }
            if (lightByteArrayOutputStream.size() < this.windowSize) break;
            this.flushTempOutput();
        }
    }

    private final void flushTempOutput() {
        int size;
        LightByteArrayOutputStream lightByteArrayOutputStream = this.tempOutput;
        if (lightByteArrayOutputStream == null) {
            Intrinsics.throwNpe();
        }
        if ((size = lightByteArrayOutputStream.size()) > 0) {
            LightByteArrayOutputStream lightByteArrayOutputStream2 = this.tempOutput;
            if (lightByteArrayOutputStream2 == null) {
                Intrinsics.throwNpe();
            }
            byte[] tempOutputBytes = lightByteArrayOutputStream2.toByteArray();
            int actuallyRead = 0;
            if (this.ratioTested) {
                actuallyRead = this.windowEncoder.encodeDiffWindow(new ByteArrayInputStream(tempOutputBytes, 0, size), this.previousSource, this.delta);
            } else {
                Runnable beforeWritingCompressedClosure;
                LightByteArrayOutputStream testOutput = new LightByteArrayOutputStream();
                actuallyRead = this.windowEncoder.encodeDiffWindow(new ByteArrayInputStream(tempOutputBytes, 0, size), this.previousSource, (OutputStream)testOutput);
                int testOutputSize = testOutput.size();
                if (testOutputSize * 100 / actuallyRead > this.windowEncoder.getConfig().getTargetPercentage()) {
                    Runnable beforeWritingUncompressedClosure;
                    Runnable runnable = beforeWritingUncompressedClosure = this.windowEncoder.getConfig().getBeforeWritingUncompressedClosure();
                    if (runnable != null) {
                        runnable.run();
                    }
                    VlqEncoder.INSTANCE.writeInt(0, this.delta);
                    this.delta.write(tempOutputBytes, 0, size);
                    this.tempOutput = null;
                    return;
                }
                this.ratioTested = true;
                Runnable runnable = beforeWritingCompressedClosure = this.windowEncoder.getConfig().getBeforeWritingCompressedClosure();
                if (runnable != null) {
                    runnable.run();
                }
                VlqEncoder.INSTANCE.writeInt(this.windowSize, this.delta);
                this.delta.write(testOutput.toByteArray(), 0, testOutputSize);
            }
            if (actuallyRead == size) {
                this.tempOutput = new LightByteArrayOutputStream();
            } else {
                int newSize = size - actuallyRead;
                System.arraycopy(tempOutputBytes, actuallyRead, tempOutputBytes, 0, newSize);
                LightByteArrayOutputStream lightByteArrayOutputStream3 = this.tempOutput;
                if (lightByteArrayOutputStream3 == null) {
                    Intrinsics.throwNpe();
                }
                lightByteArrayOutputStream3.setSize(newSize);
            }
        }
    }

    public VcDiffOutputStream(@NotNull VcDiffConfig config, @NotNull DiffWindowEncoder windowEncoder, @Nullable InputStream previousSource, @NotNull OutputStream delta) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)windowEncoder, (String)"windowEncoder");
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        this.windowEncoder = windowEncoder;
        this.previousSource = previousSource;
        this.delta = delta;
        this.windowSize = config.getWindowSize();
        this.tempOutput = new LightByteArrayOutputStream();
    }
}

