/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.customfields.audit;

import java.util.List;
import jetbrains.charisma.customfields.audit.ProjectCustomFieldConsistencyJob;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.persistence.XdProjectCustomFieldKt;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.service.IssueStateService;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.refactoring.XdRefactoringKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Ljetbrains/charisma/customfields/audit/ClearDetachFieldValueConsistencyJob;", "Ljetbrains/charisma/customfields/audit/ProjectCustomFieldConsistencyJob;", "project", "Ljetbrains/youtrack/persistent/XdProject;", "prototype", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "(Ljetbrains/youtrack/persistent/XdProject;Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;)V", "name", "", "getName", "()Ljava/lang/String;", "dataExists", "", "run", "", "shouldRun", "Companion", "charisma-customfields"})
public final class ClearDetachFieldValueConsistencyJob
extends ProjectCustomFieldConsistencyJob {
    @NotNull
    private final String name;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void run() {
        if (!this.dataExists()) {
            return;
        }
        XdQuery issues2 = XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdIssue.Companion), (Function2)((Function2)new Function2<FilteringContext, XdIssue, XdSearchingNode>(this){
            final /* synthetic */ ClearDetachFieldValueConsistencyJob this$0;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdIssue it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $receiver.eq((XdEntity)it.getProject(), (XdEntity)this.this$0.getProject());
            }
            {
                this.this$0 = clearDetachFieldValueConsistencyJob;
                super(2);
            }
        }));
        XdQuery issuesToProcess = XdQueryKt.exclude((XdQuery)issues2, (XdQuery)XdQueryKt.asQuery((Iterable)this.getPrototype().getType().filterIssues(issues2.getEntityIterable(), this.getPrototype().getEntity(), null), (XdEntityType)((XdEntityType)XdIssue.Companion)));
        boolean wasState = Intrinsics.areEqual((Object)jetbrains.charisma.customfields.complex.state.BeansKt.getSingleStateFieldType(), this.getProjectCustomFieldTypeBefore());
        XdRefactoringKt.processInBatches$default((List)XdQueryKt.toList((XdQuery)issuesToProcess), (String)"Processed %d issues", (int)0, (Function1)((Function1)new Function1<XdIssue, Unit>(this, wasState){
            final /* synthetic */ ClearDetachFieldValueConsistencyJob this$0;
            final /* synthetic */ boolean $wasState;

            public final void invoke(@NotNull XdIssue it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (this.this$0.shouldRun()) {
                    this.this$0.getPrototype().setValue(it, null);
                    if (this.$wasState) {
                        IssueStateService.updateResolvedDateAndUntag((Entity)it.getEntity());
                    }
                }
            }
            {
                this.this$0 = clearDetachFieldValueConsistencyJob;
                this.$wasState = bl;
                super(1);
            }
        }), (int)2, null);
    }

    @Override
    public boolean shouldRun() {
        if (BeansKt.getLoggedInUserOrNull() == null) {
            Companion.getLogger().info((Function0)new Function0<String>(this){
                final /* synthetic */ ClearDetachFieldValueConsistencyJob this$0;

                @NotNull
                public final String invoke() {
                    return "Terminate clearance of values for " + this.this$0.getProjectCustomFieldInfo() + ", since there is no user logged in to be author for changes";
                }
                {
                    this.this$0 = clearDetachFieldValueConsistencyJob;
                    super(0);
                }
            });
            return false;
        }
        if (!this.dataExists()) {
            return false;
        }
        XdProjectCustomField field2 = XdProjectCustomFieldKt.getProjectCustomField(this.getProject(), this.getPrototype());
        if (field2 != null && !field2.isRemoved() && Intrinsics.areEqual(this.getPrototype().getType(), this.getProjectCustomFieldTypeBefore())) {
            Companion.getLogger().info((Function0)new Function0<String>(this){
                final /* synthetic */ ClearDetachFieldValueConsistencyJob this$0;

                @NotNull
                public final String invoke() {
                    return "Terminate clearance of values for " + this.this$0.getProjectCustomFieldInfo() + ", since field was attached back to the project with the same type";
                }
                {
                    this.this$0 = clearDetachFieldValueConsistencyJob;
                    super(0);
                }
            });
            return false;
        }
        return true;
    }

    private final boolean dataExists() {
        if (this.getProject().isRemoved()) {
            Companion.getLogger().info((Function0)new Function0<String>(this){
                final /* synthetic */ ClearDetachFieldValueConsistencyJob this$0;

                @NotNull
                public final String invoke() {
                    return "Terminate clearance of values for " + this.this$0.getProjectCustomFieldInfo() + ", since project was deleted";
                }
                {
                    this.this$0 = clearDetachFieldValueConsistencyJob;
                    super(0);
                }
            });
            return false;
        }
        if (this.getPrototype().isRemoved()) {
            Companion.getLogger().info((Function0)new Function0<String>(this){
                final /* synthetic */ ClearDetachFieldValueConsistencyJob this$0;

                @NotNull
                public final String invoke() {
                    return "Terminate clearance of values for " + this.this$0.getProjectCustomFieldInfo() + ", since prototype was deleted";
                }
                {
                    this.this$0 = clearDetachFieldValueConsistencyJob;
                    super(0);
                }
            });
            return false;
        }
        return true;
    }

    public ClearDetachFieldValueConsistencyJob(@NotNull XdProject project2, @NotNull XdCustomFieldPrototype prototype2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)prototype2), (String)"prototype");
        super(project2, prototype2);
        this.name = "Values clearance for " + this.getProjectCustomFieldInfo();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/charisma/customfields/audit/ClearDetachFieldValueConsistencyJob$Companion;", "Lmu/KLogging;", "()V", "charisma-customfields"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

