/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.customfields.complex.common;

import javax.ws.rs.BadRequestException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import jetbrains.charisma.customfields.Localization;
import jetbrains.charisma.customfields.complex.common.BundleElement;
import jetbrains.charisma.customfields.complex.common.ReplaceTask;
import jetbrains.charisma.customfields.persistence.fields.XdField;
import jetbrains.gap.resource.Entity;
import jetbrains.gap.resource.Resource;
import jetbrains.youtrack.gaprest.db.DatabaseEntity;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Path(value="admin/bundleElementReplacer")
@Produces(value={"application/json"})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/charisma/customfields/complex/common/BundleElementsReplacerResource;", "Ljetbrains/gap/resource/Resource;", "Ljetbrains/gap/resource/Entity;", "()V", "post", "Ljavax/ws/rs/core/Response;", "task", "Ljetbrains/charisma/customfields/complex/common/ReplaceTask;", "charisma-customfields"})
public final class BundleElementsReplacerResource
implements Resource<Entity> {
    @POST
    @NotNull
    public final Response post(@NotNull ReplaceTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        HelpersKt.assertReadOnly();
        BundleElement bundleElement = task.getOldElement();
        if (bundleElement == null) {
            Intrinsics.throwNpe();
        }
        BundleElement oldElement = (BundleElement)HelpersKt.find$default((DatabaseEntity)((DatabaseEntity)bundleElement), null, (int)1, null);
        BundleElement bundleElement2 = task.getNewElement();
        if (bundleElement2 == null) {
            Intrinsics.throwNpe();
        }
        BundleElement newElement = (BundleElement)HelpersKt.find$default((DatabaseEntity)((DatabaseEntity)bundleElement2), null, (int)1, null);
        if (!oldElement.canDelete()) {
            throw (Throwable)new BadRequestException((String)Localization.INSTANCE.getCantReplaceBundleElement().invoke());
        }
        XdField.merge$default(oldElement.getXdEntity(), newElement.getXdEntity(), null, 2, null);
        Response response = Response.accepted().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.accepted().build()");
        return response;
    }
}

