/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.customfields.plugin;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import jetbrains.charisma.customfields.complex.common.parser.CustomFieldNode;
import jetbrains.charisma.customfields.complex.common.parser.LocalizableBundleCustomFieldValue;
import jetbrains.charisma.customfields.complex.group.parser.GroupFieldValue;
import jetbrains.charisma.customfields.complex.state.parser.GroupStateFieldValue;
import jetbrains.charisma.customfields.complex.version.parser.GroupArchivedFieldValue;
import jetbrains.charisma.customfields.complex.version.parser.GroupReleasedFieldValue;
import jetbrains.charisma.customfields.parser.EmptyCustomFieldValue;
import jetbrains.charisma.customfields.persistence.fields.XdLocalizableField;
import jetbrains.charisma.customfields.predefined.BaseSuppliedField;
import jetbrains.charisma.installation.BeansKt;
import jetbrains.charisma.links.LinkTypeField;
import jetbrains.charisma.links.LinkTypeFieldNode;
import jetbrains.charisma.links.persistent.LinkDirection;
import jetbrains.charisma.links.persistent.SuppliedIssueLink;
import jetbrains.charisma.parser.filter.TagFieldValue;
import jetbrains.charisma.parser.filter.UntaggedFieldValue;
import jetbrains.charisma.smartui.parser.filterCreator.IMyFieldValue;
import jetbrains.charisma.smartui.parser.search.ValueTranslator;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internationalization.runtime.LocaleUtil;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.l10n.TranslatableEnum;
import jetbrains.youtrack.api.l10n.YouTrackLocalizer;
import jetbrains.youtrack.persistent.XdIssueLinkPrototype;
import jetbrains.youtrack.persistent.XdUserGroup;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J:\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J*\u0010\u001f\u001a\u0004\u0018\u00010\u00102\b\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Ljetbrains/charisma/customfields/plugin/ValueTranslatorImpl;", "Ljetbrains/charisma/smartui/parser/search/ValueTranslator;", "()V", "baseSuppliedFields", "", "Ljetbrains/charisma/customfields/predefined/BaseSuppliedField;", "getBaseSuppliedFields", "()Ljava/util/List;", "setBaseSuppliedFields", "(Ljava/util/List;)V", "localizer", "Ljetbrains/youtrack/api/l10n/YouTrackLocalizer;", "getLocalizer", "()Ljetbrains/youtrack/api/l10n/YouTrackLocalizer;", "getSuppliedFieldByName", "fieldName", "", "translateEmptyCustomFieldValue", "value", "locale", "Ljava/util/Locale;", "translateIssueLinkType", "link", "Ljetbrains/charisma/links/LinkTypeField;", "translateValue", "", "valueNodeIdentifier", "fromLocale", "translatableEnums", "", "Ljetbrains/youtrack/api/l10n/TranslatableEnum;", "tryFindTranslationForEnumOrState", "enumValue", "charisma-customfields"})
public final class ValueTranslatorImpl
implements ValueTranslator {
    @Autowired
    @NotNull
    public List<? extends BaseSuppliedField> baseSuppliedFields;

    @NotNull
    public final List<BaseSuppliedField> getBaseSuppliedFields() {
        List<BaseSuppliedField> list = this.baseSuppliedFields;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseSuppliedFields");
        }
        return list;
    }

    public final void setBaseSuppliedFields(@NotNull List<? extends BaseSuppliedField> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.baseSuppliedFields = list;
    }

    @NotNull
    public final YouTrackLocalizer getLocalizer() {
        String name$iv = "localizer";
        boolean $i$f$getBean = false;
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.api.l10n.YouTrackLocalizer");
        }
        return (YouTrackLocalizer)object;
    }

    @Nullable
    public String translateValue(@NotNull Object value2, @Nullable String valueNodeIdentifier, @NotNull Locale fromLocale, @NotNull Locale locale, @NotNull Iterable<? extends TranslatableEnum> translatableEnums) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)fromLocale, (String)"fromLocale");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull(translatableEnums, (String)"translatableEnums");
        if (value2 instanceof LocalizableBundleCustomFieldValue) {
            String identifier = ((XdLocalizableField)((Object)((LocalizableBundleCustomFieldValue)((Object)value2)).getFieldValue())).getName();
            return this.tryFindTranslationForEnumOrState(identifier, locale, translatableEnums);
        }
        if (value2 instanceof IMyFieldValue) {
            return this.getLocalizer().getMsgInLocale("youtrack.single_user_field_type.me", locale, new Object[0]);
        }
        if (value2 instanceof CustomFieldNode) {
            String fieldName = ((CustomFieldNode)((Object)value2)).getField().getPrototype().getName();
            BaseSuppliedField suppliedField = this.getSuppliedFieldByName(fieldName);
            if (suppliedField != null) {
                return suppliedField.getFieldName(locale);
            }
            return null;
        }
        if (value2 instanceof GroupFieldValue) {
            XdUserGroup group = ((GroupFieldValue)((Object)value2)).getFieldValue();
            return group.getAllUsersGroup() ? this.getLocalizer().getMsgInLocale("youtrack.group.all_users_name", locale, new Object[0]) : (Intrinsics.areEqual((Object)group.getName(), (Object)this.getLocalizer().getMsgInLocale("youtrack.group.new_users_name", fromLocale, new Object[0])) ? this.getLocalizer().getMsgInLocale("youtrack.group.new_users_name", locale, new Object[0]) : (Intrinsics.areEqual((Object)group.getName(), (Object)this.getLocalizer().getMsgInLocale("youtrack.group.reporters_name", fromLocale, new Object[0])) ? this.getLocalizer().getMsgInLocale("youtrack.group.reporters_name", locale, new Object[0]) : null));
        }
        if (value2 instanceof EmptyCustomFieldValue) {
            return this.translateEmptyCustomFieldValue(valueNodeIdentifier, locale);
        }
        if (value2 instanceof GroupStateFieldValue) {
            return ((GroupStateFieldValue)((Object)value2)).isUnresolved() ? GroupStateFieldValue.Companion.getUnresolvedInLocale(locale) : GroupStateFieldValue.Companion.getResolvedInLocale(locale);
        }
        if (value2 instanceof GroupReleasedFieldValue) {
            return GroupReleasedFieldValue.Companion.getReleasedInLocale(locale);
        }
        if (value2 instanceof GroupArchivedFieldValue) {
            return GroupArchivedFieldValue.Companion.getArchivedInLocale(locale);
        }
        if (value2 instanceof LinkTypeFieldNode) {
            return this.translateIssueLinkType(((LinkTypeFieldNode)value2).getField(), locale);
        }
        if (value2 instanceof UntaggedFieldValue) {
            return Intrinsics.areEqual((Object)this.getLocalizer().getMsgInLocale("jetbrains.yoturack.keyword_installer.tags.no_tag", fromLocale, new Object[0]), (Object)valueNodeIdentifier) ? this.getLocalizer().getMsgInLocale("jetbrains.yoturack.keyword_installer.tags.no_tag", locale, new Object[0]) : this.getLocalizer().getMsgInLocale("jetbrains.yoturack.keyword_installer.tags.untagged", locale, new Object[0]);
        }
        if (value2 instanceof TagFieldValue && StringsKt.equals((String)jetbrains.charisma.persistent.issueFolders.BeansKt.getStarService().getStarName(), (String)valueNodeIdentifier, (boolean)true)) {
            return jetbrains.charisma.persistent.issueFolders.BeansKt.getStarService().getStarNameInLocale(locale);
        }
        return null;
    }

    private final String translateEmptyCustomFieldValue(String value2, Locale locale) {
        Object v1;
        block2: {
            List<? extends BaseSuppliedField> list = this.baseSuppliedFields;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"baseSuppliedFields");
            }
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                BaseSuppliedField it = (BaseSuppliedField)element$iv;
                boolean bl = false;
                if (!(value2 != null && StringsKt.equals((String)value2, (String)it.getEmptyFieldText(), (boolean)true))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        BaseSuppliedField baseSuppliedField = v1;
        return baseSuppliedField != null ? baseSuppliedField.getEmptyFieldTextInLocale(locale) : null;
    }

    private final String tryFindTranslationForEnumOrState(String enumValue, Locale locale, Iterable<? extends TranslatableEnum> translatableEnums) {
        TranslatableEnum translatableEnum;
        block2: {
            Iterable<? extends TranslatableEnum> $receiver$iv = translatableEnums;
            Iterator<? extends TranslatableEnum> iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                TranslatableEnum element$iv;
                TranslatableEnum it = element$iv = iterator2.next();
                boolean bl = false;
                String string = it.presentation(LocaleUtil.DEFAULT_LOCALE);
                String string2 = enumValue;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!StringsKt.equals((String)string, (String)string2, (boolean)true)) continue;
                translatableEnum = element$iv;
                break block2;
            }
            translatableEnum = null;
        }
        TranslatableEnum translatableEnum2 = translatableEnum;
        return translatableEnum2 != null ? translatableEnum2.presentation(locale) : null;
    }

    private final String translateIssueLinkType(LinkTypeField link, Locale locale) {
        Entity entity = link.getLink().getPrototype();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"link.link.prototype");
        XdIssueLinkPrototype prototype2 = (XdIssueLinkPrototype)XdExtensionsKt.toXd((Entity)entity);
        if (prototype2.isTranslatable()) {
            String string;
            boolean outward;
            boolean bl = outward = link.getLink().getDirection() != LinkDirection.INWARD;
            if (BeansKt.getLocalizationService().isDefaultLocale(locale)) {
                string = outward ? prototype2.getSourceToTarget() : prototype2.getTargetToSource();
            } else {
                SuppliedIssueLink linkPrototypeMessages = SuppliedIssueLink.getByName((String)prototype2.getName());
                string = outward ? linkPrototypeMessages.getSourceToTarget(locale) : linkPrototypeMessages.getTargetToSource(locale);
            }
            return string;
        }
        return null;
    }

    private final BaseSuppliedField getSuppliedFieldByName(String fieldName) {
        Object v2;
        block2: {
            List<? extends BaseSuppliedField> list = this.baseSuppliedFields;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"baseSuppliedFields");
            }
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                BaseSuppliedField it = (BaseSuppliedField)element$iv;
                boolean bl = false;
                Locale locale = LocaleUtil.DEFAULT_LOCALE;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"LocaleUtil.DEFAULT_LOCALE");
                if (!Intrinsics.areEqual((Object)it.getFieldName(locale), (Object)fieldName)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }
}

