/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.customfields.simple.date;

import javax.annotation.PostConstruct;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.simple.date.AbstractDateFieldType;
import jetbrains.charisma.customfields.simple.date.DateFieldWrapper;
import jetbrains.charisma.customfields.simple.date.DateValueRenderer;
import jetbrains.charisma.plugins.CustomFieldWrapper;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.stereotype.Service;

@Service(value="dateFieldType")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0010J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0017H\u0016J'\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0012H\u0007\u00a8\u0006\u001c"}, d2={"Ljetbrains/charisma/customfields/simple/date/DateFieldType;", "Ljetbrains/charisma/customfields/simple/date/AbstractDateFieldType;", "()V", "getFieldWrapper", "Ljetbrains/charisma/plugins/CustomFieldWrapper;", "Ljetbrains/exodus/entitystore/Entity;", "", "i", "field", "getValueRenderer", "Ljetbrains/charisma/customfields/simple/date/DateValueRenderer;", "nullValueText", "", "getValueType", "normalize", "value", "(Ljava/lang/Long;)Ljava/lang/Long;", "setDateValue", "", "issue", "Ljetbrains/youtrack/persistent/XdIssue;", "prototype", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "Lorg/joda/time/DateTime;", "setValue", "e", "(Ljetbrains/exodus/entitystore/Entity;Ljetbrains/exodus/entitystore/Entity;Ljava/lang/Long;)V", "setup", "charisma-customfields"})
public class DateFieldType
extends AbstractDateFieldType {
    @PostConstruct
    public final void setup() {
        this.setName("date");
        this.setLocalizationId("youtrack.customfieldtype.date");
        this.setEditor("DateEditor");
        this.setEditorMobile("DateEditorMobile");
    }

    @Override
    @NotNull
    public String getValueType() {
        return "instant";
    }

    @NotNull
    public DateValueRenderer getValueRenderer(@Nullable String nullValueText) {
        return new DateValueRenderer(nullValueText, this.getDateFormatters());
    }

    @NotNull
    public CustomFieldWrapper<Entity, Long> getFieldWrapper(@NotNull Entity i, @NotNull Entity field2) {
        Intrinsics.checkParameterIsNotNull((Object)i, (String)"i");
        Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
        return new DateFieldWrapper(i, field2, this);
    }

    @Override
    public void setValue(@NotNull Entity e, @NotNull Entity prototype2, @Nullable Long value2) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)prototype2, (String)"prototype");
        super.setValue(e, prototype2, (Comparable)this.normalize(value2));
    }

    private final Long normalize(Long value2) {
        Long l = value2;
        if (l == null) {
            return null;
        }
        l.longValue();
        DateTime dateTime = new DateTime(value2.longValue()).withTime(12, 0, 0, 0).withZoneRetainFields(DateTimeZone.UTC);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(value).withTime\u2026nFields(DateTimeZone.UTC)");
        return dateTime.getMillis();
    }

    @Override
    public void setDateValue(@NotNull XdIssue issue, @NotNull XdCustomFieldPrototype prototype2, @Nullable DateTime value2) {
        DateTime dateTime;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)prototype2), (String)"prototype");
        this.setValue(issue.getEntity(), prototype2.getEntity(), (dateTime = value2) != null && (dateTime = dateTime.withZoneRetainFields(DateTimeZone.UTC)) != null && (dateTime = dateTime.withTime(12, 0, 0, 0)) != null ? Long.valueOf(dateTime.getMillis()) : null);
    }
}

