/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.api.authority.module;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LoginContext {
    @NotNull
    public String getAddress();

    @NotNull
    public String getUserAgent();

    @NotNull
    public long getAccessTime();

    @Nullable
    public String getClientServiceId();

    public static class Basic
    implements LoginContext {
        private static final String UNKNOWN = "unknown";
        @NotNull
        private final String address;
        @NotNull
        private final String userAgent;
        private final long time;
        @Nullable
        private final String clientServiceId;

        public Basic(@Nullable String clientServiceId) {
            this(null, null, clientServiceId);
        }

        public Basic(@Nullable String address, @Nullable String userAgent) {
            this(address, userAgent, null);
        }

        public Basic(@Nullable String address, @Nullable String userAgent, @Nullable String clientServiceId) {
            this(address, userAgent, clientServiceId, null);
        }

        public Basic(@Nullable String address, @Nullable String userAgent, @Nullable String clientServiceId, @Nullable Long accessTime) {
            this.address = address == null || address.length() == 0 ? UNKNOWN : address;
            this.userAgent = userAgent == null || userAgent.length() == 0 ? UNKNOWN : userAgent;
            this.time = accessTime == null ? System.currentTimeMillis() : accessTime;
            this.clientServiceId = clientServiceId;
        }

        @Override
        @NotNull
        public String getAddress() {
            return this.address;
        }

        @Override
        @NotNull
        public String getUserAgent() {
            return this.userAgent;
        }

        @Override
        @NotNull
        public long getAccessTime() {
            return this.time;
        }

        @Override
        @Nullable
        public String getClientServiceId() {
            return this.clientServiceId;
        }
    }
}

