/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util.xml;

import java.util.Collection;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BasePlaneConfigHandler
extends DefaultHandler {
    private final Properties myProperties;
    private final Collection<String> myPropertyNames;
    private String propName;

    public BasePlaneConfigHandler(@NotNull Properties properties, @NotNull Collection<String> propertiesToParse) {
        this.myProperties = properties;
        this.myPropertyNames = propertiesToParse;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.myPropertyNames.contains(qName)) {
            this.propName = qName;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.propName != null) {
            this.myProperties.setProperty(this.propName, new String(ch, start, length));
            this.propName = null;
        }
    }
}

