/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.teamcity.service;

import jetbrains.buildServer.server.rest.data.Change;
import jetbrains.charisma.teamcity.persistence.TeamcityChangeDTO;
import jetbrains.charisma.teamcity.persistence.XdTeamcityChangeProcessor;
import jetbrains.charisma.teamcity.persistence.XdTeamcityChangesProcessingOption;
import jetbrains.charisma.teamcity.persistence.XdTeamcityServer;
import jetbrains.charisma.teamcity.rest.TeamcityRest;
import jetbrains.youtrack.integration.persistence.XdVcsChange;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.persistence.XdVcsServer;
import jetbrains.youtrack.integration.service.VcsService;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="teamCityService")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/integration/teamcity/service/TeamCityService;", "Ljetbrains/youtrack/integration/service/VcsService;", "Ljetbrains/charisma/teamcity/persistence/XdTeamcityChangeProcessor;", "()V", "integrationType", "", "getIntegrationType", "()Ljava/lang/String;", "systemPropertyName", "getSystemPropertyName", "canAttachChanges", "", "changesProcessor", "Ljetbrains/youtrack/integration/persistence/XdVcsChangeProcessor;", "getCommit", "Ljetbrains/youtrack/integration/vcs/CommonChangeDTO;", "hash", "getLogPrefix", "toDto", "Ljetbrains/charisma/teamcity/persistence/TeamcityChangeDTO;", "vcsChange", "Ljetbrains/youtrack/integration/persistence/XdVcsChange;", "charisma-teamcity-integration"})
public final class TeamCityService
extends VcsService<XdTeamcityChangeProcessor> {
    @NotNull
    private final String integrationType = "TeamCity";

    @NotNull
    public String getIntegrationType() {
        return this.integrationType;
    }

    @Nullable
    public CommonChangeDTO getCommit(@NotNull XdTeamcityChangeProcessor changesProcessor, @NotNull String hash) {
        CommonChangeDTO commonChangeDTO;
        Change commit;
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        XdVcsServer xdVcsServer = changesProcessor.getServer();
        if (xdVcsServer == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.charisma.teamcity.persistence.XdTeamcityServer");
        }
        XdTeamcityServer tcServer = (XdTeamcityServer)xdVcsServer;
        TeamcityRest rest = tcServer.getRest();
        Change change = commit = rest.getChange(changesProcessor.getTeamcityBuildTypeId(), hash);
        if (change != null) {
            Change change2;
            Change it = change2 = change;
            boolean bl = false;
            commonChangeDTO = tcServer.toDto(changesProcessor, it);
        } else {
            commonChangeDTO = null;
        }
        return commonChangeDTO;
    }

    @NotNull
    public String getLogPrefix(@NotNull XdTeamcityChangeProcessor changesProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        return "TeamCity Integration [" + changesProcessor.getProject().getShortName() + "<-" + changesProcessor.getTeamcityProjectName() + ':' + changesProcessor.getTeamcityBuildTypeName() + '(' + changesProcessor.getTeamcityBuildTypeId() + ")]: ";
    }

    @NotNull
    public TeamcityChangeDTO toDto(@NotNull XdVcsChange vcsChange) {
        TeamcityChangeDTO teamcityChangeDTO;
        Intrinsics.checkParameterIsNotNull((Object)vcsChange, (String)"vcsChange");
        TeamcityChangeDTO $receiver = teamcityChangeDTO = new TeamcityChangeDTO();
        boolean bl = false;
        this.tweakChangeDto(vcsChange, $receiver);
        $receiver.id = String.valueOf(vcsChange.getId());
        return teamcityChangeDTO;
    }

    public boolean canAttachChanges(@NotNull XdVcsChangeProcessor changesProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)changesProcessor, (String)"changesProcessor");
        return super.canAttachChanges(changesProcessor) && Intrinsics.areEqual((Object)((Object)((XdTeamcityChangeProcessor)changesProcessor).getChangesProcessingOption()), (Object)((Object)XdTeamcityChangesProcessingOption.Companion.getDO_NOT_ATTACH())) ^ true;
    }

    @NotNull
    protected String getSystemPropertyName() {
        return "jetbrains.youtrack.disableTeamcityIntegration";
    }
}

