/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mazine.infer.type.parameter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.mazine.infer.type.parameter.InferHierarchyTypeKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\b\b\u0001\u0010\u0003*\u0002H\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005\u001aJ\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\n0\u0005\"\u0004\b\u0000\u0010\u0002\"\b\b\u0001\u0010\u0003*\u0002H\u0002\"\b\b\u0002\u0010\n*\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005\u001aB\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u00010\r\"\u0004\b\u0000\u0010\u0002\"\b\b\u0001\u0010\u0003*\u0002H\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005\u00a8\u0006\u000f"}, d2={"inferTypeParameter", "Ljava/lang/reflect/Type;", "B", "T", "baseClass", "Ljava/lang/Class;", "typeVariableName", "", "inheritedClass", "inferTypeParameterClass", "V", "", "inferTypeParameters", "", "Ljava/lang/reflect/TypeVariable;", "infer-hierarchy-type-parameter"})
public final class InferHierarchyTypeKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <B, T extends B> Map<TypeVariable<?>, Type> inferTypeParameters(@NotNull Class<B> baseClass, @NotNull Class<T> inheritedClass) {
        void $receiver$iv$iv;
        Sequence $receiver$iv;
        Intrinsics.checkParameterIsNotNull(baseClass, (String)"baseClass");
        Intrinsics.checkParameterIsNotNull(inheritedClass, (String)"inheritedClass");
        Sequence hierarchy2 = SequencesKt.generateSequence(inheritedClass, (Function1)inferTypeParameters.hierarchy.1.INSTANCE);
        TypeVariable<Class<T>>[] typeVariableArray = ((Class)SequencesKt.first((Sequence)hierarchy2)).getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(typeVariableArray, (String)"hierarchy.first()\n            .typeParameters");
        TypeVariable<Class<T>>[] typeVariableArray2 = typeVariableArray;
        void var5_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
        void var7_6 = $receiver$iv$iv;
        int n = ((void)var7_6).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_12 = item$iv$iv = var7_6[i];
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to((Object)it, (Object)it);
            collection.add(pair);
        }
        Map initialMapping = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $receiver$iv = SequencesKt.takeWhile((Sequence)hierarchy2, (Function1)new Function1<Class<?>, Boolean>(baseClass){
            final /* synthetic */ Class $baseClass;

            public final boolean invoke(@NotNull Class<?> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return Intrinsics.areEqual(it, (Object)this.$baseClass) ^ true;
            }
            {
                this.$baseClass = clazz;
                super(1);
            }
        });
        Map accumulator$iv = initialMapping;
        for (Object element$iv : $receiver$iv) {
            Map map;
            Object[] $i$a$1$map;
            void type;
            Class clazz = (Class)element$iv;
            Map mapping = accumulator$iv;
            Class clazz2 = type.getSuperclass();
            Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"type.superclass");
            Object[] parameters = clazz2.getTypeParameters();
            Type type2 = type.getGenericSuperclass();
            if (!(type2 instanceof ParameterizedType)) {
                type2 = null;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            Object[] arguments = parameterizedType != null ? parameterizedType.getActualTypeArguments() : null;
            Intrinsics.checkExpressionValueIsNotNull(parameters, (String)"parameters");
            Object $i$f$mapTo = $i$a$1$map = parameters;
            if (!(((TypeVariable<Class<T>>[])$i$f$mapTo).length == 0) && arguments != null) {
                void $receiver$iv$iv2;
                Iterable $receiver$iv2 = ArraysKt.zip((Object[])parameters, (Object[])arguments);
                $i$f$mapTo = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    Type type3;
                    void $parameter_argument;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    TypeVariable parameter = (TypeVariable)$parameter_argument.component1();
                    Type argument = (Type)$parameter_argument.component2();
                    if (argument instanceof TypeVariable && mapping.keySet().contains(argument)) {
                        Object v = mapping.get(argument);
                        if (v == null) {
                            Intrinsics.throwNpe();
                        }
                        type3 = (Type)v;
                    } else {
                        type3 = argument;
                    }
                    Pair pair2 = TuplesKt.to((Object)parameter, (Object)type3);
                    collection.add(pair2);
                }
                map = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            } else {
                map = MapsKt.emptyMap();
            }
            accumulator$iv = map;
        }
        return accumulator$iv;
    }

    @NotNull
    public static final <B, T extends B> Type inferTypeParameter(@NotNull Class<B> baseClass, @NotNull String typeVariableName, @NotNull Class<T> inheritedClass) {
        TypeVariable<Class<B>> typeVariable;
        block3: {
            TypeVariable<Class<B>>[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull(baseClass, (String)"baseClass");
            Intrinsics.checkParameterIsNotNull((Object)typeVariableName, (String)"typeVariableName");
            Intrinsics.checkParameterIsNotNull(inheritedClass, (String)"inheritedClass");
            TypeVariable<Class<B>>[] typeVariableArray = baseClass.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(typeVariableArray, (String)"baseClass.typeParameters");
            TypeVariable<Class<B>>[] typeVariableArray2 = $receiver$iv = typeVariableArray;
            int n = typeVariableArray2.length;
            for (int i = 0; i < n; ++i) {
                TypeVariable<Class<B>> element$iv;
                TypeVariable<Class<B>> it;
                TypeVariable<Class<B>> typeVariable2 = it = (element$iv = typeVariableArray2[i]);
                Intrinsics.checkExpressionValueIsNotNull(typeVariable2, (String)"it");
                if (!Intrinsics.areEqual((Object)typeVariable2.getName(), (Object)typeVariableName)) continue;
                typeVariable = element$iv;
                break block3;
            }
            typeVariable = null;
        }
        if (typeVariable == null) {
            throw (Throwable)new IllegalArgumentException("Class " + baseClass.getName() + " has no type parameter " + typeVariableName);
        }
        TypeVariable<Class<B>> typeVariable3 = typeVariable;
        Type type = InferHierarchyTypeKt.inferTypeParameters(baseClass, inheritedClass).get(typeVariable3);
        if (type == null) {
            Intrinsics.throwNpe();
        }
        return type;
    }

    @NotNull
    public static final <B, T extends B, V> Class<V> inferTypeParameterClass(@NotNull Class<B> baseClass, @NotNull String typeVariableName, @NotNull Class<T> inheritedClass) {
        Class clazz;
        Class clazz2;
        Class clazz3;
        Type typeParameter;
        Intrinsics.checkParameterIsNotNull(baseClass, (String)"baseClass");
        Intrinsics.checkParameterIsNotNull((Object)typeVariableName, (String)"typeVariableName");
        Intrinsics.checkParameterIsNotNull(inheritedClass, (String)"inheritedClass");
        Type type = typeParameter = InferHierarchyTypeKt.inferTypeParameter(baseClass, typeVariableName, inheritedClass);
        if (type instanceof Class) {
            clazz3 = (Class)typeParameter;
        } else if (type instanceof ParameterizedType) {
            Type type2 = ((ParameterizedType)typeParameter).getRawType();
            if (!(type2 instanceof Class)) {
                type2 = null;
            }
            clazz3 = (Class)type2;
        } else {
            clazz3 = null;
        }
        if (!((clazz2 = (clazz = clazz3)) instanceof Class)) {
            clazz2 = null;
        }
        if (clazz2 == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Cannot infer class for type parameter \"").append(typeVariableName).append("\" of ").append(baseClass.getCanonicalName()).append('<');
            Object[] objectArray = baseClass.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"baseClass.typeParameters");
            throw (Throwable)new IllegalArgumentException(stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, (Function1)inferTypeParameterClass.1.INSTANCE, (int)31, null)).append("> ").append("for ").append(inheritedClass.getCanonicalName()).toString());
        }
        return clazz2;
    }
}

