/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.dnq.authentication;

import java.util.Map;
import jetbrains.jetpass.auth.module.dnq.authentication.SecondFactorRequiredException;
import jetbrains.jetpass.dao.api.DataAccessException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/auth/module/dnq/authentication/AuthenticationException;", "Ljetbrains/jetpass/dao/api/DataAccessException;", "code", "", "message", "cause", "", "params", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;Ljava/util/Map;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "Companion", "jetbrains.jetpass.auth.module.dnq"})
public class AuthenticationException
extends DataAccessException {
    @NotNull
    public static final String REGISTRATION_DISABLED_CODE = "hub-auth-create-new-user-disabled";
    @NotNull
    public static final String NO_AUTH_MODULES = "hub-auth-no-auth-modules";
    public static final Companion Companion = new Companion(null);

    public AuthenticationException(@NotNull String code, @Nullable String message, @Nullable Throwable cause, @Nullable Map<String, String> params) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        super(message, cause);
        this.setCode(code);
        this.setParameters(params);
        this.setSeverity(DataAccessException.Severity.DEBUG);
    }

    public /* synthetic */ AuthenticationException(String string, String string2, Throwable throwable, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map = null;
        }
        this(string, string2, throwable, map);
    }

    public AuthenticationException(@NotNull String code, @Nullable String message, @Nullable Map<String, String> params) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        this(code, message, null, params);
    }

    public /* synthetic */ AuthenticationException(String string, String string2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = null;
        }
        this(string, string2, map);
    }

    @JvmStatic
    @NotNull
    public static final AuthenticationException cantCreateUserDisabled() {
        return Companion.cantCreateUserDisabled();
    }

    @JvmStatic
    @NotNull
    public static final AuthenticationException userBanned(@NotNull String login) {
        return Companion.userBanned(login);
    }

    @JvmStatic
    @NotNull
    public static final AuthenticationException noLicense(@NotNull String message) {
        return Companion.noLicense(message);
    }

    @JvmStatic
    @NotNull
    public static final AuthenticationException cantCreateUserReadonly(@NotNull String login, @NotNull Exception e) {
        return Companion.cantCreateUserReadonly(login, e);
    }

    @JvmStatic
    @NotNull
    public static final AuthenticationException cantCreateUserDetailsReadonly(@NotNull String login, @NotNull String moduleName, @NotNull Exception e) {
        return Companion.cantCreateUserDetailsReadonly(login, moduleName, e);
    }

    @JvmStatic
    @NotNull
    public static final AuthenticationException cantCreateLoginResultsReadonly(@NotNull String login, @NotNull Exception e) {
        return Companion.cantCreateLoginResultsReadonly(login, e);
    }

    @JvmStatic
    @NotNull
    public static final AuthenticationException registrationDisabled(@NotNull String login, @NotNull String moduleName) {
        return Companion.registrationDisabled(login, moduleName);
    }

    @JvmStatic
    @NotNull
    public static final AuthenticationException noAuthModules() {
        return Companion.noAuthModules();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0007J$\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0007J\b\u0010\u000e\u001a\u00020\u0007H\u0007J\u001c\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0007J\b\u0010\u0010\u001a\u00020\u0007H\u0007J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/jetpass/auth/module/dnq/authentication/AuthenticationException$Companion;", "", "()V", "NO_AUTH_MODULES", "", "REGISTRATION_DISABLED_CODE", "cantCreateLoginResultsReadonly", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthenticationException;", "login", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cantCreateUserDetailsReadonly", "moduleName", "cantCreateUserDisabled", "cantCreateUserReadonly", "noAuthModules", "noLicense", "message", "registrationDisabled", "twoFactorAuthenticationIsEnabled", "Ljetbrains/jetpass/auth/module/dnq/authentication/SecondFactorRequiredException;", "username", "userBanned", "jetbrains.jetpass.auth.module.dnq"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AuthenticationException cantCreateUserDisabled() {
            return new AuthenticationException("hub-auth-cant-create-user-disabled", "External authentication was successful but auto user creation is disabled. Can't create new Hub user.", null, 4, null);
        }

        @JvmStatic
        @NotNull
        public final AuthenticationException userBanned(@NotNull String login) {
            Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
            return new AuthenticationException("hub-auth-user-disabled", "User " + login + " is banned", MapsKt.mapOf((Pair)TuplesKt.to((Object)"login", (Object)login)));
        }

        @JvmStatic
        @NotNull
        public final AuthenticationException noLicense(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            return new AuthenticationException("hub-auth-no-license", message, null, 4, null);
        }

        @JvmStatic
        @NotNull
        public final AuthenticationException cantCreateUserReadonly(@NotNull String login, @NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return new AuthenticationException("hub-auth-ro-cant-create-user", "Cannot create account for user " + login + " because database is in read-only mode", e, MapsKt.mapOf((Pair)TuplesKt.to((Object)"login", (Object)login)));
        }

        @JvmStatic
        @NotNull
        public final AuthenticationException cantCreateUserDetailsReadonly(@NotNull String login, @NotNull String moduleName, @NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return new AuthenticationException("hub-auth-ro-cant-create-user-details", "Cannot add new login method (" + moduleName + ") to user " + login + " because database is in the read-only mode", e, MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"moduleName", (Object)moduleName), TuplesKt.to((Object)"login", (Object)login)}));
        }

        @JvmStatic
        @NotNull
        public final AuthenticationException cantCreateLoginResultsReadonly(@NotNull String login, @NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return new AuthenticationException("hub-auth-ro-cant-create-login-results", "Cannot create login results for user " + login + " because database is in the read-only mode", e, MapsKt.mapOf((Pair)TuplesKt.to((Object)"login", (Object)login)));
        }

        @JvmStatic
        @NotNull
        public final AuthenticationException registrationDisabled(@NotNull String login, @NotNull String moduleName) {
            Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            return new AuthenticationException(AuthenticationException.REGISTRATION_DISABLED_CODE, "Cannot create account for user " + login + " because for " + moduleName + " user creation is denied", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"moduleName", (Object)moduleName), TuplesKt.to((Object)"login", (Object)login)}));
        }

        @JvmStatic
        @NotNull
        public final AuthenticationException noAuthModules() {
            return new AuthenticationException(AuthenticationException.NO_AUTH_MODULES, "There are no applicable authentication modules enabled", null, 4, null);
        }

        @NotNull
        public final SecondFactorRequiredException twoFactorAuthenticationIsEnabled(@NotNull String username) {
            Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
            return new SecondFactorRequiredException(username);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

