/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.dnq.authentication.certificate;

import java.security.Principal;
import java.security.cert.X509Certificate;
import jetbrains.jetpass.auth.module.dnq.authentication.certificate.ClientCertificate;
import jetbrains.jetpass.core.security.cert.CertificateUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Ljetbrains/jetpass/auth/module/dnq/authentication/certificate/X509ClientCertificate;", "Ljetbrains/jetpass/auth/module/dnq/authentication/certificate/ClientCertificate;", "x509", "Ljava/security/cert/X509Certificate;", "(Ljava/security/cert/X509Certificate;)V", "subjectDN", "", "getSubjectDN", "()Ljava/lang/String;", "getX509", "()Ljava/security/cert/X509Certificate;", "extractSubjectDnRdn", "rdn", "thumbprint", "jetbrains.jetpass.auth.module.dnq"})
public final class X509ClientCertificate
implements ClientCertificate {
    @NotNull
    private final X509Certificate x509;

    @Override
    @NotNull
    public String getSubjectDN() {
        Principal principal = this.x509.getSubjectDN();
        Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"x509.subjectDN");
        String string = principal.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"x509.subjectDN.name");
        return string;
    }

    @Override
    @NotNull
    public String thumbprint() {
        return CertificateUtilsKt.thumbprint((X509Certificate)this.x509);
    }

    @Override
    @Nullable
    public String extractSubjectDnRdn(@NotNull String rdn) {
        Intrinsics.checkParameterIsNotNull((Object)rdn, (String)"rdn");
        return CertificateUtilsKt.extractSubjectDnRdn((X509Certificate)this.x509, (String)rdn);
    }

    @NotNull
    public final X509Certificate getX509() {
        return this.x509;
    }

    public X509ClientCertificate(@NotNull X509Certificate x509) {
        Intrinsics.checkParameterIsNotNull((Object)x509, (String)"x509");
        this.x509 = x509;
    }
}

