/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup.listeners;

import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.application.AppLifecycleListenerAdapter;
import jetbrains.youtrack.maintenance.BeansKt;
import jetbrains.youtrack.maintenance.backup.CancellableBackupBean;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupConfig;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.springframework.stereotype.Service;

@Service
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/maintenance/backup/listeners/BackupAppLifecycleListener;", "Ljetbrains/youtrack/api/application/AppLifecycleListenerAdapter;", "()V", "start", "", "youtrack-maintenance"})
public final class BackupAppLifecycleListener
extends AppLifecycleListenerAdapter {
    public void start() {
        XdDatabaseBackupConfig backupConfig = (XdDatabaseBackupConfig)XdDatabaseBackupConfig.Companion.get();
        backupConfig.checkDefaults();
        if (ConfigurationUtil.isYoutrackHosted()) {
            backupConfig.setOn(false);
            backupConfig.resetBackupLocationToDefault();
        }
        Object object = ServiceLocator.getBean((String)"backupBean");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.maintenance.backup.CancellableBackupBean");
        }
        CancellableBackupBean backupBean2 = (CancellableBackupBean)((Object)object);
        backupBean2.setBackupPath(BeansKt.getBackupFolder().getRootBackupFolder().getAbsolutePath());
        backupBean2.setBackupToZip(backupConfig.getZipArhive());
        String prefix = jetbrains.youtrack.config.BeansKt.getCentralManager().getApplicationName();
        if (ConfigurationUtil.isYoutrackHosted()) {
            prefix = prefix + "InCloud";
        }
        StringBuilder stringBuilder = new StringBuilder().append(prefix).append("_");
        String string = jetbrains.youtrack.config.BeansKt.getCentralManager().getAppicationVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"centralManager.appicationVersion");
        backupBean2.setBackupNamePrefix(stringBuilder.append(StringsKt.replace$default((String)string, (char)' ', (char)'_', (boolean)false, (int)4, null)).append("_").toString());
    }
}

