/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup.listeners;

import jetbrains.charisma.plugins.UserMergeHandler;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupConfig;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0016\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/maintenance/backup/listeners/DatabaseConfigUserMergeHandler;", "Ljetbrains/charisma/plugins/UserMergeHandler;", "()V", "priority", "", "userDeleted", "", "deleted", "Ljetbrains/exodus/entitystore/Entity;", "successor", "userMerged", "from", "into", "youtrack-maintenance"})
public final class DatabaseConfigUserMergeHandler
implements UserMergeHandler {
    public void userMerged(@NotNull Entity from, @NotNull Entity into) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)into, (String)"into");
        XdDatabaseBackupConfig backupConfig = (XdDatabaseBackupConfig)XdDatabaseBackupConfig.Companion.get();
        if (XdQueryKt.contains((XdQuery)((XdQuery)backupConfig.getNotifiedUsers()), (Entity)from)) {
            backupConfig.getNotifiedUsers().remove(XdExtensionsKt.toXd((Entity)from));
            XdUser user = (XdUser)XdExtensionsKt.toXd((Entity)into);
            if (!user.isGuest()) {
                backupConfig.getNotifiedUsers().add((XdEntity)user);
            }
        }
    }

    public void userDeleted(@NotNull Entity deleted, @NotNull Entity successor) {
        Intrinsics.checkParameterIsNotNull((Object)deleted, (String)"deleted");
        Intrinsics.checkParameterIsNotNull((Object)successor, (String)"successor");
        ((XdDatabaseBackupConfig)XdDatabaseBackupConfig.Companion.get()).getNotifiedUsers().remove(XdExtensionsKt.toXd((Entity)deleted));
    }

    public int priority() {
        return 10000;
    }
}

