/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.backup.rest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.security.PrincipalsKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.gap.resource.Secured;
import jetbrains.youtrack.api.rest.RestPublic;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.gaprest.RestInternal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RestPublic
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001b\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0003\u001a\u00020\u00048\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0019\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u0011\u0010\u0017\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/maintenance/backup/rest/BackupFile;", "Ljetbrains/gap/resource/Entity;", "Ljetbrains/gap/resource/Secured;", "file", "Ljava/io/File;", "error", "", "(Ljava/io/File;Ljava/lang/String;)V", "creationDate", "", "getCreationDate", "()J", "getError", "()Ljava/lang/String;", "getFile", "()Ljava/io/File;", "id", "getId", "link", "getLink", "name", "kotlin.jvm.PlatformType", "getName", "size", "getSize", "canAccess", "", "equals", "other", "", "hashCode", "", "youtrack-maintenance"})
public class BackupFile
extends jetbrains.gap.resource.Entity
implements Secured {
    private final String name;
    private final long size;
    private final long creationDate;
    @NotNull
    private final String link;
    @NotNull
    private final File file;
    @Nullable
    private final String error;

    @NotNull
    public String getId() {
        String string = this.file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        return string;
    }

    public final String getName() {
        return this.name;
    }

    public final long getSize() {
        return this.size;
    }

    public final long getCreationDate() {
        return this.creationDate;
    }

    @NotNull
    public final String getLink() {
        return this.link;
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof BackupFile) {
            return Intrinsics.areEqual((Object)this.name, (Object)((BackupFile)((Object)other)).name);
        }
        return false;
    }

    public int hashCode() {
        String string = this.name;
        return string != null ? string.hashCode() : 0;
    }

    public boolean canAccess() {
        return PrincipalsKt.hasPermission((Entity)((Entity)BeansKt.getLoggedInUser()), (Permission)Permission.ADMIN_READ_APP);
    }

    @JsonIgnore
    @NotNull
    public final File getFile() {
        return this.file;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    public BackupFile(@NotNull File file, @RestInternal @Nullable String error) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        this.error = error;
        this.name = this.file.getName();
        this.size = this.file.length();
        this.creationDate = this.file.lastModified();
        this.link = "backupFile/" + this.file.getName();
    }

    public void assertAccess() {
        Secured.DefaultImpls.assertAccess((Secured)this);
    }

    public void assertDeleteAccess() {
        Secured.DefaultImpls.assertDeleteAccess((Secured)this);
    }

    public void assertUpdateAccess() {
        Secured.DefaultImpls.assertUpdateAccess((Secured)this);
    }

    public void assertUpdateAccess(@NotNull KProperty1<?, ?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        Secured.DefaultImpls.assertUpdateAccess((Secured)this, property);
    }

    public boolean canDelete() {
        return Secured.DefaultImpls.canDelete((Secured)this);
    }

    public boolean canUpdate() {
        return Secured.DefaultImpls.canUpdate((Secured)this);
    }

    public boolean canUpdateProperty(@NotNull KProperty1<?, ?> property) {
        Intrinsics.checkParameterIsNotNull(property, (String)"property");
        return Secured.DefaultImpls.canUpdateProperty((Secured)this, property);
    }
}

