/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.maintenance.scheduling;

import java.io.File;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.util.CompressBackupUtil;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.notifications.NotificationProvider;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Security;
import jetbrains.youtrack.maintenance.BeansKt;
import jetbrains.youtrack.maintenance.backup.AsyncBackupBean;
import jetbrains.youtrack.maintenance.backup.CancellableBackupBean;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupConfig;
import jetbrains.youtrack.maintenance.backup.listeners.XdDatabaseBackupError;
import jetbrains.youtrack.maintenance.scheduling.BackupDatabaseScheduling$execute$;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.scheduling.LocalCronScheduling;
import jetbrains.youtrack.scheduling.LocalScheduling;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u00108\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00128\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/maintenance/scheduling/BackupDatabaseScheduling;", "Ljetbrains/youtrack/scheduling/LocalCronScheduling;", "()V", "asyncBackupBean", "Ljetbrains/youtrack/maintenance/backup/AsyncBackupBean;", "backupBean", "Ljetbrains/youtrack/maintenance/backup/CancellableBackupBean;", "cron", "", "getCron", "()Ljava/lang/String;", "dbBackupConfig", "Ljetbrains/youtrack/maintenance/backup/listeners/XdDatabaseBackupConfig;", "getDbBackupConfig", "()Ljetbrains/youtrack/maintenance/backup/listeners/XdDatabaseBackupConfig;", "notificationProvider", "Ljetbrains/youtrack/api/notifications/NotificationProvider;", "security", "Ljetbrains/youtrack/core/security/Security;", "execute", "", "shouldSchedule", "", "youtrack-maintenance"})
public final class BackupDatabaseScheduling
extends LocalCronScheduling {
    @Autowired
    private AsyncBackupBean asyncBackupBean;
    @Autowired
    private CancellableBackupBean backupBean;
    @Autowired
    private Security security;
    @Autowired
    private NotificationProvider notificationProvider;

    private final XdDatabaseBackupConfig getDbBackupConfig() {
        return (XdDatabaseBackupConfig)XdDatabaseBackupConfig.Companion.get();
    }

    @NotNull
    public String getCron() {
        boolean $i$f$transactional = false;
        return (String)TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, String>(this){
            final /* synthetic */ BackupDatabaseScheduling this$0;
            {
                this.this$0 = backupDatabaseScheduling;
                super(1);
            }

            public final String invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                boolean bl = false;
                return BackupDatabaseScheduling.access$getDbBackupConfig$p(this.this$0).getCronExpression();
            }
        }), (int)7, null);
    }

    public boolean shouldSchedule() {
        return !ConfigurationUtil.isYoutrackHosted();
    }

    public void execute() {
        if (!this.getDbBackupConfig().isOn()) {
            return;
        }
        File backupFile = BeansKt.getBackupFolder().getNextBackupFile();
        try {
            if (!CharismaLicenseChecker.isEnoughDiskSpace()) {
                throw (Throwable)new Exception(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("AdministrativeTasks.Not_enough_disk_space_to_make_backup", new Object[0]));
            }
            AsyncBackupBean asyncBackupBean = this.asyncBackupBean;
            if (asyncBackupBean == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"asyncBackupBean");
            }
            if (asyncBackupBean.getBackupInProgress()) {
                LocalScheduling.Companion.getLogger().info("Attempt to execute simultaneous database backup");
            } else {
                CancellableBackupBean cancellableBackupBean = this.backupBean;
                if (cancellableBackupBean == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"backupBean");
                }
                Backupable backupable = (Backupable)cancellableBackupBean;
                CancellableBackupBean cancellableBackupBean2 = this.backupBean;
                if (cancellableBackupBean2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"backupBean");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)CompressBackupUtil.backup((Backupable)backupable, (File)backupFile, (boolean)cancellableBackupBean2.getBackupToZip()), (String)"backup(backupBean, backu\u2026, backupBean.backupToZip)");
            }
        }
        catch (Throwable t) {
            this.getDbBackupConfig().getErrors().add((XdEntity)XdDatabaseBackupError.Companion.new$default(XdDatabaseBackupError.Companion, backupFile, t, null, 4, null));
            Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)((XdQuery)this.getDbBackupConfig().getNotifiedUsers()));
            for (Object element$iv : $receiver$iv) {
                XdUser user = (XdUser)element$iv;
                boolean bl = false;
                boolean $i$f$transactional = false;
                TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(user, this, t){
                    final /* synthetic */ XdUser $user$inlined;
                    final /* synthetic */ BackupDatabaseScheduling this$0;
                    final /* synthetic */ Throwable $t$inlined;
                    {
                        this.$user$inlined = xdUser;
                        this.this$0 = backupDatabaseScheduling;
                        this.$t$inlined = throwable;
                        super(1);
                    }

                    public final Unit invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        boolean bl = false;
                        if (BackupDatabaseScheduling.access$getSecurity$p(this.this$0).hasPermission(this.$user$inlined.getEntity(), Permission.ADMIN_READ_APP) && !this.$user$inlined.getBanned()) {
                            BackupDatabaseScheduling.access$getNotificationProvider$p(this.this$0).notifyBackupFailed(this.$user$inlined.getEntity(), this.$t$inlined);
                        } else {
                            LocalScheduling.Companion.getLogger().warn(this.$t$inlined, (Function0)new Function0<String>(this){
                                final /* synthetic */ execute$$inlined$forEach$lambda$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }

                                @NotNull
                                public final String invoke() {
                                    return "User " + this.this$0.$user$inlined.getLogin() + " is configured to receive database backup notification, but has no permissions to do so.";
                                }
                            });
                        }
                        return Unit.INSTANCE;
                    }
                }), (int)7, null);
            }
        }
    }

    public static final /* synthetic */ XdDatabaseBackupConfig access$getDbBackupConfig$p(BackupDatabaseScheduling $this) {
        return $this.getDbBackupConfig();
    }

    public static final /* synthetic */ Security access$getSecurity$p(BackupDatabaseScheduling $this) {
        Security security = $this.security;
        if (security == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"security");
        }
        return security;
    }

    public static final /* synthetic */ void access$setSecurity$p(BackupDatabaseScheduling $this, Security security) {
        $this.security = security;
    }

    public static final /* synthetic */ NotificationProvider access$getNotificationProvider$p(BackupDatabaseScheduling $this) {
        NotificationProvider notificationProvider = $this.notificationProvider;
        if (notificationProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProvider");
        }
        return notificationProvider;
    }

    public static final /* synthetic */ void access$setNotificationProvider$p(BackupDatabaseScheduling $this, NotificationProvider notificationProvider) {
        $this.notificationProvider = notificationProvider;
    }
}

