/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.avatar;

import java.awt.Color;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jetbrains.jetpass.avatar.ImageGenerator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J*\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005R#\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/avatar/AvatarGenerator;", "Ljetbrains/jetpass/avatar/ImageGenerator;", "()V", "colors", "", "Lkotlin/Pair;", "Ljava/awt/Color;", "getColors", "()Ljava/util/List;", "extractLetters", "", "name", "generateAvatar", "", "size", "Ljetbrains/jetpass/avatar/AvatarGenerator$Size;", "devicePixelRatio", "", "renderImage", "letters", "color", "Size", "jetbrains.jetpass.avatar"})
public final class AvatarGenerator
extends ImageGenerator {
    @NotNull
    private static final List<Pair<Color, Color>> colors;
    public static final AvatarGenerator INSTANCE;

    @NotNull
    public final List<Pair<Color, Color>> getColors() {
        return colors;
    }

    @NotNull
    public final byte[] generateAvatar(@NotNull String name, @NotNull Size size, double devicePixelRatio) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)size), (String)"size");
        String string = this.extractLetters(name);
        int n = 0;
        int n2 = size.getLetters();
        AvatarGenerator avatarGenerator = this;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        string = name;
        List<Pair<Color, Color>> list = colors;
        Size size2 = size;
        String string5 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        String string6 = string5;
        return avatarGenerator.renderImage(string4, size2, list.get(Math.abs(string6.hashCode()) % colors.size()));
    }

    @NotNull
    public final byte[] renderImage(@NotNull String letters, @NotNull Size size, @NotNull Pair<? extends Color, ? extends Color> color) {
        Intrinsics.checkParameterIsNotNull((Object)letters, (String)"letters");
        Intrinsics.checkParameterIsNotNull((Object)((Object)size), (String)"size");
        Intrinsics.checkParameterIsNotNull(color, (String)"color");
        String string = letters;
        int n = 0;
        int n2 = size.getLetters();
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String message = string2;
        Object object = StringCompanionObject.INSTANCE;
        Object object2 = "#%06X";
        Object[] objectArray = new Object[]{((Color)color.getFirst()).getRGB() & 0xFFFFFF};
        String string3 = "${fromColor}";
        String string4 = StringsKt.replace$default((String)size.getTemplateImage(), (String)"${text}", (String)message, (boolean)false, (int)4, null);
        String string5 = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
        String string6 = string5;
        String string7 = StringsKt.replace$default((String)string4, (String)string3, (String)string6, (boolean)false, (int)4, null);
        object = StringCompanionObject.INSTANCE;
        object2 = "#%06X";
        objectArray = new Object[]{((Color)color.getSecond()).getRGB() & 0xFFFFFF};
        string3 = "${toColor}";
        string4 = string7;
        String string8 = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"java.lang.String.format(format, *args)");
        string6 = string8;
        String renderedImage = StringsKt.replace$default((String)string4, (String)string3, (String)string6, (boolean)false, (int)4, null);
        object = renderedImage;
        object2 = Charsets.UTF_8;
        Object object3 = object;
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = ((String)object3).getBytes((Charset)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String extractLetters(@NotNull String name) {
        String string;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        CharSequence charSequence = name;
        Object object = new Regex("[\\s._]+");
        int n = 0;
        Iterable $receiver$iv = object.split(charSequence, n);
        object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            CharSequence charSequence2 = it;
            if (!(charSequence2.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List names = (List)destination$iv$iv;
        if (names.size() >= 2) {
            char c = StringsKt.first((CharSequence)((CharSequence)names.get(0)));
            StringBuilder stringBuilder = new StringBuilder();
            char c2 = Character.toUpperCase(c);
            c = StringsKt.first((CharSequence)((CharSequence)names.get(1)));
            stringBuilder = stringBuilder.append(c2);
            c2 = Character.toUpperCase(c);
            string = stringBuilder.append(c2).toString();
        } else if (names.size() == 1) {
            if (((String)names.get(0)).length() >= 2) {
                CharSequence charSequence3 = charSequence = (String)names.get(0);
                if (charSequence3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)charSequence3).toUpperCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
                charSequence = string2;
                int n2 = 0;
                int n3 = 2;
                CharSequence charSequence4 = charSequence;
                if (charSequence4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)charSequence4).substring(n2, n3);
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                char c = StringsKt.first((CharSequence)((CharSequence)names.get(0)));
                StringBuilder stringBuilder = new StringBuilder();
                char c3 = Character.toUpperCase(c);
                string = stringBuilder.append(c3).append('X').toString();
            }
        } else {
            string = "XX";
        }
        return string;
    }

    private AvatarGenerator() {
    }

    static {
        AvatarGenerator avatarGenerator;
        INSTANCE = avatarGenerator = new AvatarGenerator();
        colors = CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)new Color(6334464), (Object)new Color(14010880)), TuplesKt.to((Object)new Color(2216816), (Object)new Color(256481)), TuplesKt.to((Object)new Color(3908095), (Object)new Color(3598717)), TuplesKt.to((Object)new Color(49731), (Object)new Color(65535)), TuplesKt.to((Object)new Color(4972696), (Object)new Color(6455295)), TuplesKt.to((Object)new Color(1477626), (Object)new Color(2553799)), TuplesKt.to((Object)new Color(10308863), (Object)new Color(3789763)), TuplesKt.to((Object)new Color(688630), (Object)new Color(708598)), TuplesKt.to((Object)new Color(7756536), (Object)new Color(5935608)), TuplesKt.to((Object)new Color(10376447), (Object)new Color(708598)), TuplesKt.to((Object)new Color(11748849), (Object)new Color(6725119)), TuplesKt.to((Object)new Color(7756536), (Object)new Color(12605934)), TuplesKt.to((Object)new Color(9451984), (Object)new Color(12728784)), TuplesKt.to((Object)new Color(10431231), (Object)new Color(16602877)), TuplesKt.to((Object)new Color(11221746), (Object)new Color(14943592)), TuplesKt.to((Object)new Color(10431231), (Object)new Color(15312907)), TuplesKt.to((Object)new Color(13963115), (Object)new Color(15153896)), TuplesKt.to((Object)new Color(15553794), (Object)new Color(15153896)), TuplesKt.to((Object)new Color(15545740), (Object)new Color(14413080)), TuplesKt.to((Object)new Color(15545740), (Object)new Color(16355374)), TuplesKt.to((Object)new Color(16741632), (Object)new Color(16763392))});
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0001\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001b\u0010\u000b\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rj\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/avatar/AvatarGenerator$Size;", "", "boxSize", "", "letters", "templateName", "", "(Ljava/lang/String;IIILjava/lang/String;)V", "getBoxSize", "()I", "getLetters", "templateImage", "getTemplateImage", "()Ljava/lang/String;", "templateImage$delegate", "Lkotlin/Lazy;", "getTemplateName", "S18", "S24", "S32", "S40", "Companion", "jetbrains.jetpass.avatar"})
    public static final class Size
    extends Enum<Size> {
        public static final /* enum */ Size S18;
        public static final /* enum */ Size S24;
        public static final /* enum */ Size S32;
        public static final /* enum */ Size S40;
        private static final /* synthetic */ Size[] $VALUES;
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final Lazy templateImage$delegate;
        private final int boxSize;
        private final int letters;
        @NotNull
        private final String templateName;
        public static final Companion Companion;

        static {
            Size[] sizeArray = new Size[4];
            Size[] sizeArray2 = sizeArray;
            sizeArray[0] = S18 = new Size(18, 1, "avatar-18.svg");
            sizeArray[1] = S24 = new Size(24, 2, "avatar-24.svg");
            sizeArray[2] = S32 = new Size(32, 2, "avatar-32.svg");
            sizeArray[3] = S40 = new Size(40, 2, "avatar-40.svg");
            $VALUES = sizeArray;
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Size.class), "templateImage", "getTemplateImage()Ljava/lang/String;"))};
            Companion = new Companion(null);
        }

        @NotNull
        public final String getTemplateImage() {
            Lazy lazy = this.templateImage$delegate;
            Size size = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (String)lazy.getValue();
        }

        public final int getBoxSize() {
            return this.boxSize;
        }

        public final int getLetters() {
            return this.letters;
        }

        @NotNull
        public final String getTemplateName() {
            return this.templateName;
        }

        protected Size(@NotNull int boxSize, int letters, String templateName) {
            Intrinsics.checkParameterIsNotNull((Object)templateName, (String)"templateName");
            this.boxSize = boxSize;
            this.letters = letters;
            this.templateName = templateName;
            this.templateImage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ Size this$0;

                @NotNull
                public final String invoke() {
                    InputStream inputStream = AvatarGenerator.class.getResourceAsStream(this.this$0.getTemplateName());
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"AvatarGenerator::class.j\u2026rceAsStream(templateName)");
                    InputStream inputStream2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    return TextStreamsKt.readText((Reader)new InputStreamReader(inputStream2, charset));
                }
                {
                    this.this$0 = size;
                    super(0);
                }
            }));
        }

        public static Size[] values() {
            return (Size[])$VALUES.clone();
        }

        public static Size valueOf(String string) {
            return Enum.valueOf(Size.class, string);
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/jetpass/avatar/AvatarGenerator$Size$Companion;", "", "()V", "approximate", "Ljetbrains/jetpass/avatar/AvatarGenerator$Size;", "size", "", "jetbrains.jetpass.avatar"})
        public static final class Companion {
            @NotNull
            public final Size approximate(int size) {
                Size size2;
                Size size3;
                block2: {
                    Size[] $receiver$iv;
                    for (Size element$iv : $receiver$iv = Size.values()) {
                        Size it = element$iv;
                        if (!(it.getBoxSize() >= size)) continue;
                        size3 = element$iv;
                        break block2;
                    }
                    size3 = size2 = null;
                }
                if (size3 == null) {
                    size2 = (Size)((Object)ArraysKt.last((Object[])Size.values()));
                }
                return size2;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

