/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jira.plugin;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.auth.module.jira.rest.client.json.JiraauthmoduleJSON;
import jetbrains.jetpass.auth.module.jira.rest.client.json.JiradetailsJSON;
import jetbrains.jetpass.client.accounts.AuthModuleClient;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.ring.HubExportUserDataFactory;
import jetbrains.youtrack.jira.persistence.XdJiraUserData;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogger;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/jira/plugin/JiraExportUserDataFactory;", "Ljetbrains/youtrack/api/ring/HubExportUserDataFactory;", "()V", "createNewAuthModuleJSON", "Ljetbrains/jetpass/rest/dto/AuthmoduleJSON;", "url", "", "getAuthModuleJson", "client", "Ljetbrains/jetpass/client/accounts/AuthModuleClient;", "getOrCreate", "getUserDetailsJson", "", "Ljetbrains/jetpass/rest/dto/DetailsJSON;", "user", "Ljetbrains/exodus/entitystore/Entity;", "Companion", "youtrack-jira-import"})
public final class JiraExportUserDataFactory
implements HubExportUserDataFactory {
    @NotNull
    public static final String VOLFMAN_CONSTANT = "http://";
    @NotNull
    public static final String TYPE_NAME = "Atlassian Jira";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DetailsJSON> getUserDetailsJson(@NotNull Entity user) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Iterable iterable = $receiver$iv = (Iterable)XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdJiraUserData.Companion.all(), (Function2)((Function2)new Function2<FilteringContext, XdJiraUserData, XdSearchingNode>(user){
            final /* synthetic */ Entity $user;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdJiraUserData it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return $receiver.eq((XdEntity)it.getUser(), XdExtensionsKt.toXd((Entity)this.$user));
            }
            {
                this.$user = entity;
                super(2);
            }
        })));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void userData;
            XdJiraUserData xdJiraUserData = (XdJiraUserData)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JiradetailsJSON json = new JiradetailsJSON();
            json.setLogin(userData.getUser().getLogin());
            JiradetailsJSON jiradetailsJSON = json;
            collection.add(jiradetailsJSON);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public AuthmoduleJSON getAuthModuleJson(@NotNull AuthModuleClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Object object = ServiceLocator.getBean((String)"jiraIntegrationSettings");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.Entity");
        }
        Entity settings = (Entity)object;
        return PrimitiveAssociationSemantics.get((Entity)settings, (String)"jiraUrl", String.class, null) == null || Intrinsics.areEqual((Object)VOLFMAN_CONSTANT, (Object)((String)PrimitiveAssociationSemantics.get((Entity)settings, (String)"jiraUrl", String.class, null))) ? null : this.getOrCreate(client, (String)PrimitiveAssociationSemantics.get((Entity)settings, (String)"jiraUrl", String.class, null));
    }

    private final AuthmoduleJSON getOrCreate(AuthModuleClient client, String url) {
        AuthmoduleJSON authmoduleJSON;
        AuthmoduleJSON json;
        Companion.getLogger().debug("Try to find Atlassian Jira Hub auth module for url: " + url);
        if (url != null && (json = client.getAuthModuleByUrl(url, null)) != null) {
            Companion.getLogger().debug("Module Atlassian Jira for url: " + url + " found. Provider type: " + json.getClass().getSimpleName());
            return json;
        }
        Companion.getLogger().info("Creating Atlassian Jira Hub auth module for url: " + url);
        json = this.createNewAuthModuleJSON(url);
        String failHeader = "Failed to create Atlassian Jira";
        try {
            AuthmoduleJSON authmoduleJSON2 = json;
            if (authmoduleJSON2 == null) {
                Intrinsics.throwNpe();
            }
            authmoduleJSON = client.createAuthModule(authmoduleJSON2, null);
        }
        catch (WebApplicationException ex) {
            KLogger kLogger = Companion.getLogger();
            StringBuilder stringBuilder = new StringBuilder().append(failHeader).append(" code: ");
            Response response = ex.getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"ex.response");
            kLogger.warn(stringBuilder.append(response.getStatus()).append(". See more in Hub logs").toString(), (Throwable)ex);
            authmoduleJSON = null;
        }
        json = authmoduleJSON;
        if (json != null) {
            Companion.getLogger().info("Module Atlassian Jira created with id " + json.getId());
        } else {
            Companion.getLogger().warn(failHeader + " for url: " + url);
        }
        return json;
    }

    private final AuthmoduleJSON createNewAuthModuleJSON(String url) {
        JiraauthmoduleJSON jira = new JiraauthmoduleJSON();
        jira.setName("Atlassian Jira " + url);
        jira.setServerUrl(url);
        jira.setName(TYPE_NAME);
        return (AuthmoduleJSON)jira;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/jira/plugin/JiraExportUserDataFactory$Companion;", "Lmu/KLogging;", "()V", "TYPE_NAME", "", "VOLFMAN_CONSTANT", "youtrack-jira-import"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

