/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jira.tmpRest;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import jetbrains.charisma.persistent.UserActionJob;
import jetbrains.charisma.persistent.UserActionJobContainer;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.jira.oldImport.ConnectionStatus;
import jetbrains.youtrack.jira.oldImport.JiraApi;
import jetbrains.youtrack.jira.oldImport.ProjectInfo;
import jetbrains.youtrack.jira.tmpRest.JiraProject;
import jetbrains.youtrack.jira.tmpRest.SslKey;

@XmlRootElement(name="jira")
@XmlType(name="Jira")
public class Jira {
    @XmlAttribute(name="url")
    private String url;
    @XmlAttribute(name="login")
    private String login;
    @XmlAttribute(name="password")
    private String password;
    @XmlAttribute(name="connectionStatus")
    private ConnectionStatus connectionStatus;
    @XmlAttribute(name="connectionMessage")
    private String connectionMessage;
    @XmlAttribute(name="hasAdminPermission")
    private boolean hasAdminPermission;
    @XmlElement(name="sslKey")
    private SslKey sslKey;
    @XmlElement(name="projects")
    private List<JiraProject> projects;
    @XmlElement(name="currentJobId")
    private Object currentJobId;

    public Jira() {
    }

    public Jira(Entity jis, JiraApi jiraApi) {
        this.url = this.evalUrl(jis, jiraApi);
        this.login = this.evalLogin(jis, jiraApi);
        this.password = this.evalPassword(jis, jiraApi);
        this.connectionStatus = this.evalConnectionStatus(jis, jiraApi);
        this.connectionMessage = this.evalConnectionMessage(jis, jiraApi);
        this.hasAdminPermission = this.evalHasAdminPermission(jis, jiraApi);
        this.sslKey = this.evalSslKey(jis, jiraApi);
        this.projects = ListSequence.fromListWithValues(new ArrayList(), this.evalProjects(jis, jiraApi));
        this.currentJobId = this.evalCurrentJobId(jis, jiraApi);
    }

    public String getUrl() {
        return this.url;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public String getConnectionMessage() {
        return this.connectionMessage;
    }

    public boolean getHasAdminPermission() {
        return this.hasAdminPermission;
    }

    public SslKey getSslKey() {
        return this.sslKey;
    }

    public List<JiraProject> getProjects() {
        return this.projects;
    }

    public Object getCurrentJobId() {
        return this.currentJobId;
    }

    private String evalUrl(Entity jis, JiraApi jiraApi) {
        return (String)PrimitiveAssociationSemantics.get((Entity)jis, (String)"jiraUrl", String.class, null);
    }

    private String evalLogin(Entity jis, JiraApi jiraApi) {
        return (String)PrimitiveAssociationSemantics.get((Entity)jis, (String)"jiraLogin", String.class, null);
    }

    private String evalPassword(Entity jis, JiraApi jiraApi) {
        return "";
    }

    private ConnectionStatus evalConnectionStatus(Entity jis, JiraApi jiraApi) {
        ConnectionStatus connectionStatus = jiraApi.getConnectionStatus();
        return connectionStatus == null ? ConnectionStatus.UNKNOWN : connectionStatus;
    }

    private String evalConnectionMessage(Entity jis, JiraApi jiraApi) {
        return jiraApi.getConnectionMessage();
    }

    private boolean evalHasAdminPermission(Entity jis, JiraApi jiraApi) {
        return jiraApi.hasAdminPermission();
    }

    private SslKey evalSslKey(Entity jis, JiraApi jiraApi) {
        return EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)jis, (String)"sslKey"), null) ? null : new SslKey(AssociationSemantics.getToOne((Entity)jis, (String)"sslKey"));
    }

    private Iterable<JiraProject> evalProjects(Entity jis, JiraApi jiraApi) {
        return Sequence.fromIterable(jiraApi.getProjects()).select((_FunctionTypes._return_P1_E0)new ISelector<ProjectInfo, JiraProject>(){

            public JiraProject select(ProjectInfo it) {
                return new JiraProject(it);
            }
        });
    }

    private Object evalCurrentJobId(Entity jis, JiraApi jiraApi) {
        UserActionJob job = ((UserActionJobContainer)ServiceLocator.getBean((String)"userActionJobContainer")).getNotFinishedJobForParams(new Entity[]{jis});
        return job == null ? null : job.getId();
    }
}

