/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.persistence.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.exodus.query.NodeBase;
import jetbrains.youtrack.agile.persistence.AgileValuesUtilKt;
import jetbrains.youtrack.agile.persistence.SprintIssuesUtilKt;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.XdAgileColumnFieldValue;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.agile.persistence.listener.AgileEntityListener;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$handleCache$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$handleCache$2;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$handleCache$3;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$handleOwnerChange$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updateBacklog$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updateColumnSettings$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updateIssues$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updateIssues$2$1$1;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updateSwimlaneSettings$2;
import jetbrains.youtrack.agile.persistence.listener.AgileSettingsChangeListener$updatedSync$1;
import jetbrains.youtrack.agile.persistence.swimlane.BacklogUtilKt;
import jetbrains.youtrack.agile.persistence.swimlane.XdAttributeBasedSwimlaneSettings;
import jetbrains.youtrack.agile.persistence.swimlane.XdAttributeValue;
import jetbrains.youtrack.agile.persistence.swimlane.XdSwimlaneSettings;
import jetbrains.youtrack.agile.settings.BeansKt;
import jetbrains.youtrack.agile.sprint.logic.SprintLogic;
import jetbrains.youtrack.core.KSecurityLogging;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdSavedQuery;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0017\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/agile/persistence/listener/AgileSettingsChangeListener;", "Ljetbrains/youtrack/agile/persistence/listener/AgileEntityListener;", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "()V", "entityType", "Lkotlinx/dnq/XdEntityType;", "getEntityType", "()Lkotlinx/dnq/XdEntityType;", "addedSync", "", "added", "handleCache", "old", "handleOwnerChange", "current", "removedSync", "removed", "updateBacklog", "updateColumnSettings", "updateIssues", "updateSwimlaneSettings", "updatedSync", "Companion", "youtrack-scrumboard"})
public class AgileSettingsChangeListener
implements AgileEntityListener<XdAgile> {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public XdEntityType<XdAgile> getEntityType() {
        return (XdEntityType)XdAgile.Companion;
    }

    public void addedSync(@NotNull XdAgile added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        BeansKt.getAgileCache().init();
    }

    public void updatedSync(@NotNull XdAgile old, @NotNull XdAgile current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        if (ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)AgileSettingsChangeListener$updatedSync$1.INSTANCE)) {
            this.updateBacklog(old, current);
            this.updateSwimlaneSettings(old, current);
            this.updateColumnSettings(current);
            this.updateIssues(old, current);
        }
        this.handleCache(old);
        this.handleOwnerChange(old, current);
    }

    public void removedSync(@NotNull XdAgile removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        if (removed.getVisibleForProjectBased() || removed.getVisibleFor() != null) {
            Companion.getSecurityLogger().info("Board " + removed.getName() + " was removed");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateIssues(XdAgile old, XdAgile current) {
        Iterable $receiver$iv = HelpersKt.asIterable((XdQuery)ReflectionUtilKt.getRemovedLinks((XdEntity)old, (KProperty1)AgileSettingsChangeListener$updateIssues$1.INSTANCE));
        for (Object element$iv : $receiver$iv) {
            XdProject project2 = (XdProject)element$iv;
            boolean bl = false;
            if (project2.isRemoved()) continue;
            SprintLogic logic = current.getSprintLogic();
            Iterable $receiver$iv2 = HelpersKt.asIterable((XdQuery)((XdQuery)current.getSprints()));
            for (Object element$iv2 : $receiver$iv2) {
                void value$iv;
                Iterable $receiver$iv3;
                XdSprint sprint2 = (XdSprint)((Object)element$iv2);
                boolean bl2 = false;
                KProperty1 kProperty1 = (KProperty1)AgileSettingsChangeListener$updateIssues$2$1$1.INSTANCE;
                XdEntity xdEntity = (XdEntity)project2;
                XdQuery<XdIssue> xdQuery = logic.getExplicitIssues(sprint2);
                NodeBase nodeBase = NodeBaseOperationsKt.eq((KProperty1)$receiver$iv3, (KClass)Reflection.getOrCreateKotlinClass(XdIssue.class), (XdEntity)value$iv);
                $receiver$iv3 = HelpersKt.asIterable((XdQuery)XdQueryKt.query(xdQuery, (NodeBase)nodeBase));
                for (Object element$iv3 : $receiver$iv3) {
                    XdIssue it = (XdIssue)element$iv3;
                    boolean bl3 = false;
                    SprintIssuesUtilKt.removeIssueWithoutSwimlanes(sprint2, it);
                }
            }
        }
    }

    private final void updateColumnSettings(XdAgile current) {
        Iterable $receiver$iv;
        XdCustomFieldPrototype xdCustomFieldPrototype = current.getStatePrototype();
        if (xdCustomFieldPrototype == null) {
            return;
        }
        XdCustomFieldPrototype stateField = xdCustomFieldPrototype;
        Set possibleValues = CollectionsKt.toSet((Iterable)AgileValuesUtilKt.getPossibleValues$default(current, stateField, null, 2, null));
        XdQuery xdQuery = (XdQuery)current.getColumnSettings();
        KProperty1 field$iv = AgileSettingsChangeListener$updateColumnSettings$1.INSTANCE;
        $receiver$iv = HelpersKt.asIterable((XdQuery)XdQueryKt.flatMapDistinct((XdQuery)$receiver$iv, (String)ReflectionUtilKt.getDBName((KProperty1)field$iv, (XdEntityType)$receiver$iv.getEntityType()), (XdEntityType)ReflectionUtilKt.getEntityType((KClass)Reflection.getOrCreateKotlinClass(XdAgileColumnFieldValue.class))));
        for (Object element$iv : $receiver$iv) {
            XdAgileColumnFieldValue it = (XdAgileColumnFieldValue)((Object)element$iv);
            boolean bl = false;
            if (possibleValues.contains(it.getName())) continue;
            it.delete();
        }
    }

    private final void updateBacklog(XdAgile old, XdAgile current) {
        if (XdQueryKt.isNotEmpty((XdQuery)((XdQuery)current.getProjects())) && BacklogUtilKt.hasDefaultBacklogQuery(old) && !ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)((KProperty1)AgileSettingsChangeListener$updateBacklog$1.INSTANCE))) {
            XdSavedQuery xdSavedQuery = current.getBacklog();
            if (xdSavedQuery == null) {
                Intrinsics.throwNpe();
            }
            xdSavedQuery.setQuery(BacklogUtilKt.generateBacklogQuery(current));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSwimlaneSettings(XdAgile old, XdAgile current) {
        XdSwimlaneSettings swimlaneSettings2 = current.getSwimlaneSettings();
        if (swimlaneSettings2 instanceof XdAttributeBasedSwimlaneSettings && Intrinsics.areEqual((Object)swimlaneSettings2.getFilterField(), (Object)jetbrains.charisma.keyword.BeansKt.getPredefinedFieldProject())) {
            void $receiver$iv$iv;
            Object element$iv2;
            String string;
            Collection collection;
            void $receiver$iv$iv2;
            Iterable $receiver$iv;
            Iterable iterable2 = $receiver$iv = HelpersKt.asIterable((XdQuery)((XdQuery)current.getProjects()));
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                XdProject xdProject = (XdProject)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string = it.getShortName();
                collection.add(string);
            }
            Set currentProjects = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            List values2 = XdQueryKt.toList((XdQuery)((XdQuery)((XdAttributeBasedSwimlaneSettings)swimlaneSettings2).getValues()));
            Iterable $receiver$iv2 = values2;
            for (Object element$iv2 : $receiver$iv2) {
                XdAttributeValue it = (XdAttributeValue)((Object)element$iv2);
                boolean bl = false;
                if (currentProjects.contains(it.getName())) continue;
                it.delete();
            }
            Iterable $receiver$iv3 = values2;
            element$iv2 = $receiver$iv3;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                XdAttributeValue $i$f$mapTo = (XdAttributeValue)((Object)item$iv$iv);
                collection = destination$iv$iv2;
                boolean bl = false;
                string = it.getName();
                collection.add(string);
            }
            Set valueNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            $receiver$iv3 = XdQueryKt.asSequence((XdQuery)ReflectionUtilKt.getAddedLinks((XdEntity)old, (KProperty1)AgileSettingsChangeListener$updateSwimlaneSettings$2.INSTANCE));
            for (Object element$iv3 : $receiver$iv3) {
                XdProject it = (XdProject)element$iv3;
                boolean bl = false;
                if (valueNames.contains(it.getShortName())) continue;
                XdAttributeValue.Companion.new((Function1)new Function1<XdAttributeValue, Unit>(it, valueNames, swimlaneSettings2){
                    final /* synthetic */ XdProject $it;
                    final /* synthetic */ Set $valueNames$inlined;
                    final /* synthetic */ XdSwimlaneSettings $swimlaneSettings$inlined;
                    {
                        this.$it = xdProject;
                        this.$valueNames$inlined = set;
                        this.$swimlaneSettings$inlined = xdSwimlaneSettings;
                        super(1);
                    }

                    public final void invoke(@NotNull XdAttributeValue $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                        $receiver.setName(this.$it.getShortName());
                        $receiver.setParent((XdAttributeBasedSwimlaneSettings)this.$swimlaneSettings$inlined);
                    }
                });
            }
        }
    }

    private final void handleCache(XdAgile old) {
        boolean bl;
        block4: {
            Iterable $receiver$iv = CollectionsKt.listOf((Object[])new KProperty1[]{AgileSettingsChangeListener$handleCache$1.INSTANCE, (KProperty1)AgileSettingsChangeListener$handleCache$2.INSTANCE, (KProperty1)AgileSettingsChangeListener$handleCache$3.INSTANCE});
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KProperty1 it = (KProperty1)element$iv;
                    boolean bl2 = false;
                    if (!ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            BeansKt.getAgileCache().init();
        }
    }

    private final void handleOwnerChange(XdAgile old, XdAgile current) {
        if (ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)((KProperty1)AgileSettingsChangeListener$handleOwnerChange$1.INSTANCE))) {
            Companion.getSecurityLogger().info("Board owner changed for board " + current.getName() + ": " + old.getOwner().getLogin() + " -> " + current.getOwner().getLogin());
        }
    }

    @Override
    public void add() {
        AgileEntityListener.DefaultImpls.add(this);
    }

    @Override
    public void remove() {
        AgileEntityListener.DefaultImpls.remove(this);
    }

    public void addedAsync(@NotNull XdAgile added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        AgileEntityListener.DefaultImpls.addedAsync(this, (XdEntity)added);
    }

    public void addedSyncAfterConstraints(@NotNull XdAgile added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        AgileEntityListener.DefaultImpls.addedSyncAfterConstraints(this, (XdEntity)added);
    }

    public void addedSyncBeforeConstraints(@NotNull XdAgile added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        AgileEntityListener.DefaultImpls.addedSyncBeforeConstraints(this, (XdEntity)added);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
    public void addedSyncBeforeFlush(@NotNull XdAgile added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        AgileEntityListener.DefaultImpls.addedSyncBeforeFlush(this, (XdEntity)added);
    }

    public void removedAsync(@NotNull XdAgile removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        AgileEntityListener.DefaultImpls.removedAsync(this, (XdEntity)removed);
    }

    public void removedSyncAfterConstraints(@NotNull XdAgile removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        AgileEntityListener.DefaultImpls.removedSyncAfterConstraints(this, (XdEntity)removed);
    }

    public void removedSyncBeforeConstraints(@NotNull XdAgile removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        AgileEntityListener.DefaultImpls.removedSyncBeforeConstraints(this, (XdEntity)removed);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
    public void removedSyncBeforeFlush(@NotNull XdAgile added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        AgileEntityListener.DefaultImpls.removedSyncBeforeFlush(this, (XdEntity)added);
    }

    public void updatedAsync(@NotNull XdAgile old, @NotNull XdAgile current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        AgileEntityListener.DefaultImpls.updatedAsync(this, (XdEntity)old, (XdEntity)current);
    }

    public void updatedSyncAfterConstraints(@NotNull XdAgile old, @NotNull XdAgile current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        AgileEntityListener.DefaultImpls.updatedSyncAfterConstraints(this, (XdEntity)old, (XdEntity)current);
    }

    public void updatedSyncBeforeConstraints(@NotNull XdAgile old, @NotNull XdAgile current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        AgileEntityListener.DefaultImpls.updatedSyncBeforeConstraints(this, (XdEntity)old, (XdEntity)current);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
    public void updatedSyncBeforeFlush(@NotNull XdAgile old, @NotNull XdAgile current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        AgileEntityListener.DefaultImpls.updatedSyncBeforeFlush(this, (XdEntity)old, (XdEntity)current);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/agile/persistence/listener/AgileSettingsChangeListener$Companion;", "Ljetbrains/youtrack/core/KSecurityLogging;", "()V", "youtrack-scrumboard"})
    public static final class Companion
    extends KSecurityLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

