/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.security.Permission;
import jetbrains.jetpass.dao.access.cache.CachedPermissionManager;
import jetbrains.jetpass.dao.api.permissionCache.PermissionCache;
import jetbrains.jetpass.dao.api.security.PermissionDAO;
import jetbrains.jetpass.dao.dnq.api.security.JetPassPermissionDAO;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.oauth2.rest.security.OAuth;
import jetbrains.jetpass.oauth2.rest.security.OAuthResourceFilter;
import jetbrains.jetpass.oauth2.rest.security.SecurityContext;
import jetbrains.jetpass.rest.api.PermissionDAOResource;
import jetbrains.jetpass.rest.api.resource.MutableDAOResource;
import jetbrains.jetpass.rest.api.resource.ResourceUtilKt;
import jetbrains.jetpass.rest.api.serialization.impl.SerializationExtKt;
import jetbrains.jetpass.rest.dto.CachedPermissionJSON;
import jetbrains.jetpass.rest.dto.PermissionJSON;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.FieldQuery;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.RequestFieldQuery;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/permissions")
@OAuth
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0005J0\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0007R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Ljetbrains/jetpass/rest/api/PermissionDAOResource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource;", "Ljetbrains/jetpass/api/security/Permission;", "Ljetbrains/jetpass/rest/dto/PermissionJSON;", "Ljetbrains/jetpass/dao/api/security/PermissionDAO;", "()V", "dao", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassPermissionDAO;", "getDao", "()Ljetbrains/jetpass/dao/dnq/api/security/JetPassPermissionDAO;", "permissionCache", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionCache;", "getPermissionCache", "()Ljetbrains/jetpass/dao/api/permissionCache/PermissionCache;", "permissionCache$delegate", "Lkotlin/properties/ReadOnlyProperty;", "getCache", "", "Ljetbrains/jetpass/rest/dto/CachedPermissionJSON;", "query", "", "runAsPrincipal", "request", "Ljavax/servlet/http/HttpServletRequest;", "Companion", "jetbrains.jetpass.rest"})
public final class PermissionDAOResource
extends MutableDAOResource<Permission, PermissionJSON, PermissionDAO> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty permissionCache$delegate;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PermissionDAOResource.class), "permissionCache", "getPermissionCache()Ljetbrains/jetpass/dao/api/permissionCache/PermissionCache;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final PermissionCache getPermissionCache() {
        return (PermissionCache)this.permissionCache$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    @NotNull
    public JetPassPermissionDAO getDao() {
        return this.getApi().getPermissionDAO();
    }

    @GET
    @Path(value="/cache")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final List<CachedPermissionJSON> getCache(@QueryParam(value="query") @Nullable String query, @QueryParam(value="principal") @Nullable String runAsPrincipal, @Context @NotNull HttpServletRequest request) {
        String string;
        block7: {
            SecurityContext principal;
            block6: {
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                SecurityContext securityContext = OAuthResourceFilter.Companion.getSecurityContext();
                if (securityContext == null || (securityContext = securityContext.getAuthorityHolder()) == null) {
                    throw (Throwable)new ForbiddenException();
                }
                principal = securityContext;
                string = runAsPrincipal;
                if (string == null) break block6;
                String it = string2 = string;
                if (!(principal instanceof Service) || !((Service)principal).isTrusted().booleanValue()) {
                    throw (Throwable)new ForbiddenException("Only trusted service is allowed to request permission cache on behalf of others");
                }
                User user = (User)this.getApi().getUserDAO().get(runAsPrincipal);
                AuthorityHolder authorityHolder = user != null ? (AuthorityHolder)user : (AuthorityHolder)this.getApi().getServiceDAO().get(runAsPrincipal);
                if (authorityHolder == null) {
                    throw (Throwable)new NotFoundException("Principal with id " + runAsPrincipal + " wasn't found");
                }
                string = authorityHolder;
                if (authorityHolder != null) break block7;
            }
            string = principal;
        }
        String authHolder = string;
        RequestFieldQuery fieldQuery = new RequestFieldQuery(request, 0, null, 6, null);
        Companion.getLogger().debug((Function0)new Function0<String>(fieldQuery){
            final /* synthetic */ RequestFieldQuery $fieldQuery;

            @NotNull
            public final String invoke() {
                return "Permission cache request query: " + this.$fieldQuery.getQuery() + " skip: " + this.$fieldQuery.getSkip() + " top: " + this.$fieldQuery.getTop();
            }
            {
                this.$fieldQuery = requestFieldQuery;
                super(0);
            }
        });
        Companion.getLogger().debug((Function0)new Function0<String>((AuthorityHolder)authHolder){
            final /* synthetic */ AuthorityHolder $authHolder;

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final String invoke() {
                String string;
                StringBuilder stringBuilder = new StringBuilder().append("Given principal: ").append(this.$authHolder.getId()).append('-').append(this.$authHolder.getName());
                if (this.$authHolder instanceof User) {
                    Boolean bl = ((User)this.$authHolder).isBanned();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"authHolder.isBanned");
                    if (bl.booleanValue()) {
                        string = "-banned";
                        return stringBuilder.append(string).toString();
                    }
                }
                string = "";
                return stringBuilder.append(string).toString();
            }
            {
                this.$authHolder = authorityHolder;
                super(0);
            }
        });
        Companion.getLogger().debug((Function0)getCache.3.INSTANCE);
        return (List)ResourceUtilKt.daoAction((Function0)new Function0<List<? extends CachedPermissionJSON>>(this, (AuthorityHolder)authHolder, fieldQuery){
            final /* synthetic */ PermissionDAOResource this$0;
            final /* synthetic */ AuthorityHolder $authHolder;
            final /* synthetic */ RequestFieldQuery $fieldQuery;

            @NotNull
            public final List<CachedPermissionJSON> invoke() {
                return (List)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, List<? extends CachedPermissionJSON>>(this){
                    final /* synthetic */ getCache.4 this$0;

                    @NotNull
                    public final List<CachedPermissionJSON> invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return SerializationExtKt.asJSONList(new CachedPermissionManager(this.this$0.this$0.getPermissionCache(), (PermissionDAO)this.this$0.this$0.getDao()).getCachedPermissions(this.this$0.$authHolder, this.this$0.$fieldQuery.getQuery()), (FieldQuery)this.this$0.$fieldQuery);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)7, null);
            }
            {
                this.this$0 = permissionDAOResource;
                this.$authHolder = authorityHolder;
                this.$fieldQuery = requestFieldQuery;
                super(0);
            }
        });
    }

    public PermissionDAOResource() {
        ReadOnlyProperty readOnlyProperty;
        PermissionDAOResource permissionDAOResource = this;
        String name$iv = null;
        permissionDAOResource.permissionCache$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/rest/api/PermissionDAOResource$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.rest"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

