/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.api;

import com.intellij.hub.core.data.uri.DataURI;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.jetpass.api.security.Role;
import jetbrains.jetpass.api.security.Team;
import jetbrains.jetpass.avatar.ProjectIconGenerator;
import jetbrains.jetpass.dao.api.security.ProjectDAO;
import jetbrains.jetpass.dao.dnq.api.JetPassReadOnlyDAO;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO;
import jetbrains.jetpass.dao.dnq.api.security.JetPassTeam;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.oauth2.rest.security.OAuth;
import jetbrains.jetpass.rest.api.FilteringTeam;
import jetbrains.jetpass.rest.api.ProjectDAOResource;
import jetbrains.jetpass.rest.api.ProjectDAOResourceKt;
import jetbrains.jetpass.rest.api.ProjectTeamDAOResource;
import jetbrains.jetpass.rest.api.metadata.RootResourceMetaData;
import jetbrains.jetpass.rest.api.resource.DAOResource;
import jetbrains.jetpass.rest.api.resource.LinkDAO;
import jetbrains.jetpass.rest.api.resource.MutableDAOResource;
import jetbrains.jetpass.rest.api.resource.ResourceUtilKt;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.ResourceJSON;
import jetbrains.jetpass.rest.dto.TeamJSON;
import jetbrains.jetpass.sequence.Sequence;
import jetbrains.jetpass.userManagement.persistence.dnq.XdFile;
import jetbrains.jetpass.userManagement.persistence.dnq.XdGlobalProject;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProject;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/projects")
@OAuth
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0005J\"\u0010\n\u001a\u00060\u000bR\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00032\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0016Ja\u0010\u0015\u001a\u00020\u00032\b\b\u0001\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\r2\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\r2\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cH\u0007\u00a2\u0006\u0002\u0010\u001dJ\"\u0010\u001e\u001a\u0010\u0012\f\u0012\n  *\u0004\u0018\u00010\u00020\u00020\u001f*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Ljetbrains/jetpass/rest/api/ProjectDAOResource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource;", "Ljetbrains/jetpass/api/security/Project;", "Ljetbrains/jetpass/rest/dto/ProjectJSON;", "Ljetbrains/jetpass/dao/api/security/ProjectDAO;", "()V", "dao", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectDAO;", "getDao", "()Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectDAO;", "createEntitySubResource", "Ljetbrains/jetpass/rest/api/ProjectDAOResource$ProjectDAOEntitySubresource;", "key", "", "resolve", "Lkotlin/Function0;", "getGlobal", "request", "Ljavax/servlet/http/HttpServletRequest;", "getMetaData", "Ljetbrains/jetpass/rest/api/metadata/RootResourceMetaData;", "merge", "name", "description", "archived", "", "ownerId", "projects", "", "(Ljavax/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;[Ljetbrains/jetpass/rest/dto/ProjectJSON;)Ljetbrains/jetpass/rest/dto/ProjectJSON;", "getAll", "Ljetbrains/jetpass/sequence/Sequence;", "kotlin.jvm.PlatformType", "ProjectDAOEntitySubresource", "jetbrains.jetpass.rest"})
public final class ProjectDAOResource
extends MutableDAOResource<Project, ProjectJSON, ProjectDAO> {
    @Override
    @NotNull
    public JetPassProjectDAO getDao() {
        return this.getApi().getJetPassProjectDAO();
    }

    @Override
    @NotNull
    public RootResourceMetaData getMetaData() {
        RootResourceMetaData rootResourceMetaData;
        RootResourceMetaData $receiver = rootResourceMetaData = super.getMetaData();
        ResourceUtilKt.addQueryParam($receiver.getGetAllMethod(), ProjectDAOResourceKt.access$getARCHIVED_PARAM$p());
        return rootResourceMetaData;
    }

    @Override
    @NotNull
    public Sequence<Project> getAll(@NotNull ProjectDAO $receiver, @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return $receiver.getAllItems(ResourceUtilKt.get(request, ProjectDAOResourceKt.access$getARCHIVED_PARAM$p()));
    }

    @GET
    @Path(value="/global")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final ProjectJSON getGlobal(@Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return (ProjectJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<Project>(this){
            final /* synthetic */ ProjectDAOResource this$0;

            @NotNull
            public final Project invoke() {
                Project project = this.this$0.getDao().getGlobal();
                if (project == null) {
                    throw (Throwable)new NotFoundException("Access to the Global project is restricted");
                }
                return project;
            }
            {
                this.this$0 = projectDAOResource;
                super(0);
            }
        });
    }

    @POST
    @Path(value="/merge")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final ProjectJSON merge(@Context @NotNull HttpServletRequest request, @QueryParam(value="key") @Nullable String key, @QueryParam(value="name") @Nullable String name, @QueryParam(value="description") @Nullable String description, @QueryParam(value="archived") @Nullable Boolean archived, @QueryParam(value="owner") @Nullable String ownerId, @NotNull ProjectJSON[] projects) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)projects, (String)"projects");
        return (ProjectJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<Project>(this, projects, key, name, description, archived, ownerId){
            final /* synthetic */ ProjectDAOResource this$0;
            final /* synthetic */ ProjectJSON[] $projects;
            final /* synthetic */ String $key;
            final /* synthetic */ String $name;
            final /* synthetic */ String $description;
            final /* synthetic */ Boolean $archived;
            final /* synthetic */ String $ownerId;

            @NotNull
            public final Project invoke() {
                User user;
                JetPassProjectDAO jetPassProjectDAO = this.this$0.getDao();
                Iterable iterable = ArraysKt.asIterable((Object[])this.$projects);
                String string = this.$key;
                String string2 = this.$name;
                String string3 = this.$description;
                Boolean bl = this.$archived;
                String string4 = this.$ownerId;
                if (string4 != null) {
                    String string5 = string4;
                    Boolean bl2 = bl;
                    String string6 = string3;
                    String string7 = string2;
                    String string8 = string;
                    Iterable iterable2 = iterable;
                    JetPassProjectDAO jetPassProjectDAO2 = jetPassProjectDAO;
                    String it = string5;
                    User user2 = (User)this.this$0.getApi().getUserDAO().get(it);
                    jetPassProjectDAO = jetPassProjectDAO2;
                    iterable = iterable2;
                    string = string8;
                    string2 = string7;
                    string3 = string6;
                    bl = bl2;
                    user = user2;
                } else {
                    user = null;
                }
                return jetPassProjectDAO.merge(iterable, string, string2, string3, bl, user);
            }
            {
                this.this$0 = projectDAOResource;
                this.$projects = projectJSONArray;
                this.$key = string;
                this.$name = string2;
                this.$description = string3;
                this.$archived = bl;
                this.$ownerId = string4;
                super(0);
            }
        });
    }

    @NotNull
    public ProjectDAOEntitySubresource createEntitySubResource(@NotNull String key, @NotNull Function0<? extends Project> resolve2) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(resolve2, (String)"resolve");
        return new ProjectDAOEntitySubresource(resolve2);
    }

    @OAuth
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0087\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u0013\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ;\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\f\u0010\u001c\u001a\u00060\u001dR\u00020\u001eH\u0007R@\u0010\t\u001a.\u0012*\u0012(\u0012\u0006\b\u0001\u0012\u00020\f\u0012\u0002\b\u00030\u000bR\u00180\rR\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000e0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Ljetbrains/jetpass/rest/api/ProjectDAOResource$ProjectDAOEntitySubresource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource$MutableDAOEntitySubresource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource;", "Ljetbrains/jetpass/api/security/Project;", "Ljetbrains/jetpass/rest/dto/ProjectJSON;", "Ljetbrains/jetpass/dao/api/security/ProjectDAO;", "resolve", "Lkotlin/Function0;", "(Ljetbrains/jetpass/rest/api/ProjectDAOResource;Lkotlin/jvm/functions/Function0;)V", "links", "", "Ljetbrains/jetpass/rest/api/resource/DAOResource$DAOEntitySubresource$LinkDAOSubresource;", "", "Ljetbrains/jetpass/rest/api/resource/DAOResource$DAOEntitySubresource;", "Ljetbrains/jetpass/rest/api/resource/DAOResource;", "getLinks", "()Ljava/util/List;", "getIcon", "Ljavax/ws/rs/core/Response;", "size", "", "dpr", "", "requiredDefault", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "(Ljava/lang/Integer;Ljava/lang/Double;Ljava/lang/Boolean;Ljavax/servlet/http/HttpServletRequest;)Ljavax/ws/rs/core/Response;", "getTeam", "Ljetbrains/jetpass/rest/api/ProjectTeamDAOResource$ProjectTeamDAOEntitySubresource;", "Ljetbrains/jetpass/rest/api/ProjectTeamDAOResource;", "jetbrains.jetpass.rest"})
    public final class ProjectDAOEntitySubresource
    extends MutableDAOResource.MutableDAOEntitySubresource {
        @NotNull
        private final List<DAOResource.LinkDAOSubresource<? extends Object, ?>> links;

        @NotNull
        public List<DAOResource.LinkDAOSubresource<? extends Object, ?>> getLinks() {
            return this.links;
        }

        @Path(value="/team")
        @NotNull
        public final ProjectTeamDAOResource.ProjectTeamDAOEntitySubresource getTeam() {
            ProjectTeamDAOResource.ProjectTeamDAOEntitySubresource projectTeamDAOEntitySubresource;
            ProjectTeamDAOResource projectTeamDAOResource = new ProjectTeamDAOResource();
            ProjectTeamDAOResource.ProjectTeamDAOEntitySubresource projectTeamDAOEntitySubresource2 = projectTeamDAOEntitySubresource;
            ProjectTeamDAOResource.ProjectTeamDAOEntitySubresource projectTeamDAOEntitySubresource3 = projectTeamDAOEntitySubresource;
            ProjectTeamDAOResource $receiver = projectTeamDAOResource;
            $receiver.setProviders(ProjectDAOResource.this.getProviders());
            ProjectTeamDAOResource projectTeamDAOResource2 = projectTeamDAOResource;
            projectTeamDAOEntitySubresource2(projectTeamDAOResource2, (Function0<? extends ProjectTeam>)((Function0)new Function0<ProjectTeam>(this){
                final /* synthetic */ ProjectDAOEntitySubresource this$0;

                public final ProjectTeam invoke() {
                    ProjectTeam projectTeam = ((Project)this.this$0.getResolveEntity().invoke()).getTeam();
                    Intrinsics.checkExpressionValueIsNotNull((Object)projectTeam, (String)"resolveEntity().team");
                    return projectTeam;
                }
                {
                    this.this$0 = projectDAOEntitySubresource;
                    super(0);
                }
            }));
            return projectTeamDAOEntitySubresource3;
        }

        @Path(value="/icon")
        @GET
        @Produces(value={"*/*"})
        @NotNull
        public final Response getIcon(@QueryParam(value="size") @Nullable Integer size, @QueryParam(value="dpr") @Nullable Double dpr, @QueryParam(value="default") @Nullable Boolean requiredDefault, @Context @NotNull HttpServletRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Project project = (Project)ProjectDAOResourceKt.access$getHubPrincipalManager$p().runAsRoot(this.getResolveEntity());
            Object t = ResourceUtilKt.daoAction((Function0)new Function0<Response>(this, project, requiredDefault, size, dpr){
                final /* synthetic */ ProjectDAOEntitySubresource this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ Boolean $requiredDefault;
                final /* synthetic */ Integer $size;
                final /* synthetic */ Double $dpr;

                public final Response invoke() {
                    Object object = TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Response>(this){
                        final /* synthetic */ getIcon.1 this$0;

                        public final Response invoke(@NotNull TransientStoreSession $noName_0) {
                            DataURI dataURI;
                            String string;
                            DataURI dataURI2;
                            DataURI dataURI3;
                            String string2;
                            Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                            XdProject xdProject = (XdProject)JetPassReadOnlyDAO.resolve$default((JetPassReadOnlyDAO)this.this$0.this$0.ProjectDAOResource.this.getDao(), (IdItem)((IdItem)this.this$0.$project), (boolean)false, (boolean)false, (int)6, null);
                            XdFile xdIcon = xdProject.getIcon();
                            if (xdProject instanceof XdGlobalProject) {
                                DataURI dataURI4;
                                string2 = xdProject.getIconURI();
                                dataURI3 = dataURI4;
                                dataURI2 = dataURI4;
                                String string3 = string2;
                                if (string3 == null) {
                                    string3 = "";
                                }
                                string = string3;
                                dataURI = dataURI2;
                                dataURI3(string);
                            } else if (xdIcon != null && Intrinsics.areEqual((Object)this.this$0.$requiredDefault, (Object)true) ^ true) {
                                DataURI dataURI5;
                                string2 = xdIcon.getMimeType();
                                dataURI3 = dataURI5;
                                dataURI2 = dataURI5;
                                String string4 = string2;
                                if (string4 == null) {
                                    string4 = "";
                                }
                                string = string4;
                                dataURI = dataURI2;
                                dataURI3(string, ByteStreamsKt.readBytes$default((InputStream)xdIcon.getContent(), (int)0, (int)1, null));
                            } else {
                                ProjectIconGenerator.Size iconSize = this.this$0.$size != null ? ProjectIconGenerator.Size.Companion.approximate(this.this$0.$size.intValue()) : ProjectIconGenerator.Size.S48;
                                Double d = this.this$0.$dpr;
                                byte[] icon = ProjectIconGenerator.INSTANCE.generateIcon(xdProject.getKey(), xdProject.getName(), iconSize, d != null ? d : 2.0);
                                dataURI = new DataURI("image/svg+xml", icon);
                            }
                            DataURI dataURI6 = dataURI;
                            Response.ResponseBuilder responseBuilder = Response.ok((Object)dataURI6.getContent(), (String)dataURI6.getMimeType());
                            Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder, (String)"Response.ok(dataURI.content, dataURI.mimeType)");
                            Response response = jetbrains.jetpass.rest.common.ResourceUtilKt.cache$default((Response.ResponseBuilder)responseBuilder, (int)0, (int)1, null).build();
                            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(dataURI.cont\u2026mimeType).cache().build()");
                            return response;
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }), (int)7, null);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"legacyTransactional { _ \u2026build()\n                }");
                    return (Response)object;
                }
                {
                    this.this$0 = projectDAOEntitySubresource;
                    this.$project = project;
                    this.$requiredDefault = bl;
                    this.$size = n;
                    this.$dpr = d;
                    super(0);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"daoAction {\n            \u2026          }\n            }");
            return (Response)t;
        }

        public ProjectDAOEntitySubresource(Function0<? extends Project> resolve2) {
            Intrinsics.checkParameterIsNotNull(resolve2, (String)"resolve");
            super(resolve2);
            this.links = CollectionsKt.listOf((Object[])new DAOResource.DAOEntitySubresource.LinkDAOSubresource[]{new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "Resource"){
                @NotNull
                private final links.linkDAO.1 linkDAO;
                final /* synthetic */ ProjectDAOEntitySubresource this$0;

                @NotNull
                public links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<Project, Resource, ResourceJSON>(this){
                        final /* synthetic */ links.1 this$0;

                        public Iterable<Resource> getChildren(@NotNull Project $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getResources();
                        }

                        public String getChildKey(@NotNull Resource $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public Resource addChild(@NotNull Project $receiver, @NotNull Resource child, @NotNull HttpServletRequest request) {
                            Resource resource;
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            Resource it = resource = child;
                            JetPassProjectDAO jetPassProjectDAO = this.this$0.this$0.ProjectDAOResource.this.getDao();
                            String string = $receiver.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.id");
                            String string2 = child.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"child.id");
                            jetPassProjectDAO.addResource(string, string2);
                            return resource;
                        }

                        public void removeChild(@NotNull Project $receiver, @NotNull Resource child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            JetPassProjectDAO jetPassProjectDAO = this.this$0.this$0.ProjectDAOResource.this.getDao();
                            String string = $receiver.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.id");
                            String string2 = child.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"child.id");
                            jetPassProjectDAO.removeResource(string, string2);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "Team", true){
                @NotNull
                private final ProjectDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ ProjectDAOEntitySubresource this$0;

                @NotNull
                public ProjectDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }

                @GET
                @Path(value="/whole")
                @OAuth
                @Produces(value={"application/json;charset=UTF-8"})
                @NotNull
                public final TeamJSON getWhole(@Context @NotNull HttpServletRequest request) {
                    Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                    return (TeamJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<FilteringTeam>(this, request){
                        final /* synthetic */ links.2 this$0;
                        final /* synthetic */ HttpServletRequest $request;

                        @NotNull
                        public final FilteringTeam invoke() {
                            Project project = (Project)this.this$0.this$0.getResolveEntity().invoke();
                            JetPassProjectDAO jetPassProjectDAO = this.this$0.this$0.ProjectDAOResource.this.getDao();
                            String string = project.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.id");
                            JetPassTeam wholeTeam = jetPassProjectDAO.getWholeTeam(string);
                            return new FilteringTeam((Team)wholeTeam, this.$request);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$request = httpServletRequest;
                            super(0);
                        }
                    });
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, $super_call_param$2);
                    this.linkDAO = new LinkDAO<Project, Team, TeamJSON>(this){
                        final /* synthetic */ links.2 this$0;

                        @NotNull
                        public Sequence<FilteringTeam> getChildren(@NotNull Project $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            JetPassProjectDAO jetPassProjectDAO = this.this$0.this$0.ProjectDAOResource.this.getDao();
                            String string = $receiver.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
                            return jetPassProjectDAO.getTeams(string).map((Function1)new Function1<JetPassTeam, FilteringTeam>(request){
                                final /* synthetic */ HttpServletRequest $request;

                                @NotNull
                                public final FilteringTeam invoke(@NotNull JetPassTeam it) {
                                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                    return new FilteringTeam((Team)it, this.$request);
                                }
                                {
                                    this.$request = httpServletRequest;
                                    super(1);
                                }
                            });
                        }

                        @Nullable
                        public Team findChild(@NotNull Project $receiver, @NotNull String childKey, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)childKey, (String)"childKey");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            JetPassProjectDAO jetPassProjectDAO = this.this$0.this$0.ProjectDAOResource.this.getDao();
                            String string = $receiver.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
                            return new FilteringTeam((Team)jetPassProjectDAO.getTeam(string, childKey), request);
                        }

                        public String getChildKey(@NotNull Team $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Role role = $receiver.getRole();
                            Intrinsics.checkExpressionValueIsNotNull((Object)role, (String)"role");
                            return role.getId();
                        }

                        @NotNull
                        public FilteringTeam addChild(@NotNull Project $receiver, @NotNull Team child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            JetPassProjectDAO jetPassProjectDAO = this.this$0.this$0.ProjectDAOResource.this.getDao();
                            String string = $receiver.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.id");
                            return new FilteringTeam(jetPassProjectDAO.addTeam(string, child), request);
                        }

                        @NotNull
                        public Void removeChild(@NotNull Project $receiver, @NotNull Team child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            Void void_ = DAOResource.Companion.UNSUPPORTED();
                            throw null;
                        }
                        {
                            this.this$0 = $outer;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "TransitiveProjectRole"){
                @NotNull
                private final ProjectDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ ProjectDAOEntitySubresource this$0;

                @NotNull
                public ProjectDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<Project, ProjectRole, ProjectRoleJSON>(){

                        public Iterable<ProjectRole> getChildren(@NotNull Project $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getTransitiveProjectRoles();
                        }

                        public String getChildKey(@NotNull ProjectRole $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public Void addChild(@NotNull Project $receiver, @NotNull ProjectRole child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            Void void_ = DAOResource.Companion.UNSUPPORTED();
                            throw null;
                        }

                        @NotNull
                        public Void removeChild(@NotNull Project $receiver, @NotNull ProjectRole child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            Void void_ = DAOResource.Companion.UNSUPPORTED();
                            throw null;
                        }
                    };
                }
            }});
        }
    }
}

