/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.api;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.settings.BackupSettings;
import jetbrains.jetpass.api.settings.JabberSettings;
import jetbrains.jetpass.api.settings.LicenseSettings;
import jetbrains.jetpass.api.settings.Locale;
import jetbrains.jetpass.api.settings.SMTPMessage;
import jetbrains.jetpass.api.settings.SMTPSettings;
import jetbrains.jetpass.api.settings.Settings;
import jetbrains.jetpass.api.settings.UpdateStatus;
import jetbrains.jetpass.dao.api.ItemNotFoundException;
import jetbrains.jetpass.dao.api.settings.SettingsDAO;
import jetbrains.jetpass.dao.dnq.api.settings.JetPassSettingsDAO;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.locale.LocaleContainer;
import jetbrains.jetpass.oauth2.rest.security.OAuth;
import jetbrains.jetpass.rest.api.SettingsDAOResource;
import jetbrains.jetpass.rest.api.SettingsDAOResourceKt;
import jetbrains.jetpass.rest.api.metadata.LinkSubresourceMetaData;
import jetbrains.jetpass.rest.api.metadata.RootResourceMetaData;
import jetbrains.jetpass.rest.api.resource.DAOResource;
import jetbrains.jetpass.rest.api.resource.LinkDAO;
import jetbrains.jetpass.rest.api.resource.MutableDAOResource;
import jetbrains.jetpass.rest.api.resource.ResourceUtilKt;
import jetbrains.jetpass.rest.api.resource.SubtypeLinkDAO;
import jetbrains.jetpass.rest.api.serialization.impl.SerializationExtKt;
import jetbrains.jetpass.rest.dto.BackupStatusJSON;
import jetbrains.jetpass.rest.dto.LocaleJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.jetpass.rest.dto.SmtpMessageJSON;
import jetbrains.jetpass.rest.dto.UpdateStatusJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.FieldQuery;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.RequestFieldQuery;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/settings")
@OAuth(ignoreEUConsent=true)
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007J\"\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010 \u001a\u00020!2\b\b\u0001\u0010\"\u001a\u00020\u00132\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u0010$\u001a\u00020%2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007J!\u0010&\u001a\u00020!2\n\b\u0001\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0007\u00a2\u0006\u0002\u0010+R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006-"}, d2={"Ljetbrains/jetpass/rest/api/SettingsDAOResource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource;", "Ljetbrains/jetpass/api/settings/Settings;", "Ljetbrains/jetpass/rest/dto/SettingsJSON;", "Ljetbrains/jetpass/dao/api/settings/SettingsDAO;", "()V", "dao", "Ljetbrains/jetpass/dao/dnq/api/settings/JetPassSettingsDAO;", "getDao", "()Ljetbrains/jetpass/dao/dnq/api/settings/JetPassSettingsDAO;", "localeManager", "Ljetbrains/jetpass/locale/LocaleContainer;", "getLocaleManager", "()Ljetbrains/jetpass/locale/LocaleContainer;", "localeManager$delegate", "Lkotlin/properties/ReadOnlyProperty;", "backUp", "Ljetbrains/jetpass/rest/dto/BackupStatusJSON;", "targetVersion", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "createEntitySubResource", "Ljetbrains/jetpass/rest/api/SettingsDAOResource$SettingsDAOEntitySubresource;", "key", "resolve", "Lkotlin/Function0;", "getLocales", "", "Ljetbrains/jetpass/rest/dto/LocaleJSON;", "getMetaData", "Ljetbrains/jetpass/rest/api/metadata/RootResourceMetaData;", "getTranslation", "Ljavax/ws/rs/core/Response;", "name", "version", "getUpdateStatus", "Ljetbrains/jetpass/rest/dto/UpdateStatusJSON;", "sendSMTPMessage", "requireEmailVerification", "", "message", "Ljetbrains/jetpass/rest/dto/SmtpMessageJSON;", "(Ljava/lang/Boolean;Ljetbrains/jetpass/rest/dto/SmtpMessageJSON;)Ljavax/ws/rs/core/Response;", "SettingsDAOEntitySubresource", "jetbrains.jetpass.rest"})
public final class SettingsDAOResource
extends MutableDAOResource<Settings, SettingsJSON, SettingsDAO> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty localeManager$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SettingsDAOResource.class), "localeManager", "getLocaleManager()Ljetbrains/jetpass/locale/LocaleContainer;"))};
    }

    private final LocaleContainer getLocaleManager() {
        return (LocaleContainer)this.localeManager$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    @NotNull
    public JetPassSettingsDAO getDao() {
        return this.getApi().getSettingsDAO();
    }

    @Override
    @NotNull
    public RootResourceMetaData getMetaData() {
        RootResourceMetaData rootResourceMetaData;
        RootResourceMetaData $receiver = rootResourceMetaData = super.getMetaData();
        $receiver.setEntityName("Setting");
        return rootResourceMetaData;
    }

    @GET
    @Path(value="/locales")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final List<LocaleJSON> getLocales(@Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return (List)ResourceUtilKt.daoAction((Function0)new Function0<List<? extends LocaleJSON>>(this, request){
            final /* synthetic */ SettingsDAOResource this$0;
            final /* synthetic */ HttpServletRequest $request;

            @NotNull
            public final List<LocaleJSON> invoke() {
                return (List)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, List<? extends LocaleJSON>>(this){
                    final /* synthetic */ getLocales.1 this$0;

                    @NotNull
                    public final List<LocaleJSON> invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return SerializationExtKt.asJSONList(this.this$0.this$0.getDao().getAvailableLocales(), (FieldQuery)new RequestFieldQuery(this.this$0.$request, 0, null, 6, null));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)7, null);
            }
            {
                this.this$0 = settingsDAOResource;
                this.$request = httpServletRequest;
                super(0);
            }
        });
    }

    @POST
    @Path(value="/backupData")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final BackupStatusJSON backUp(@QueryParam(value="targetVersion") @Nullable String targetVersion, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return (BackupStatusJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<BackupSettings.Status>(this, targetVersion){
            final /* synthetic */ SettingsDAOResource this$0;
            final /* synthetic */ String $targetVersion;

            @NotNull
            public final BackupSettings.Status invoke() {
                return this.this$0.getDao().backup(this.$targetVersion);
            }
            {
                this.this$0 = settingsDAOResource;
                this.$targetVersion = string;
                super(0);
            }
        });
    }

    @GET
    @Path(value="/updateStatus")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final UpdateStatusJSON getUpdateStatus(@Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return (UpdateStatusJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<UpdateStatus>(this){
            final /* synthetic */ SettingsDAOResource this$0;

            @NotNull
            public final UpdateStatus invoke() {
                return this.this$0.getDao().getUpdateStatus();
            }
            {
                this.this$0 = settingsDAOResource;
                super(0);
            }
        });
    }

    @GET
    @Path(value="/translation")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final Response getTranslation(@QueryParam(value="name") @NotNull String name, @QueryParam(value="version") @Nullable String version) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        StreamingOutput out2 = (StreamingOutput)ResourceUtilKt.daoAction((Function0)new Function0<StreamingOutput>(this, name){
            final /* synthetic */ SettingsDAOResource this$0;
            final /* synthetic */ String $name;

            @NotNull
            public final StreamingOutput invoke() {
                Locale locale = this.this$0.getDao().getPublicSettings().getLocale();
                if (locale == null) {
                    throw (Throwable)new ItemNotFoundException("Current locale is undefined");
                }
                Locale currentLocale = locale;
                LocaleContainer localeContainer = SettingsDAOResource.access$getLocaleManager$p(this.this$0);
                Locale locale2 = currentLocale;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"currentLocale");
                InputStream inputStream = localeContainer.getCustomTranslation(locale2, this.$name);
                if (inputStream == null) {
                    throw (Throwable)new ItemNotFoundException("Translation with name: " + this.$name + " was not found for current locale");
                }
                InputStream customTranslationStream = inputStream;
                return new StreamingOutput(customTranslationStream){
                    final /* synthetic */ InputStream $customTranslationStream;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void write(OutputStream out2) {
                        Closeable closeable = this.$customTranslationStream;
                        Throwable throwable = null;
                        try {
                            InputStream it = (InputStream)closeable;
                            IOUtils.copy((InputStream)this.$customTranslationStream, (OutputStream)out2);
                            out2.flush();
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    {
                        this.$customTranslationStream = inputStream;
                    }
                };
            }
            {
                this.this$0 = settingsDAOResource;
                this.$name = string;
                super(0);
            }
        });
        CacheControl cacheControl = new CacheControl();
        Response.ResponseBuilder responseBuilder = Response.ok((Object)out2);
        CacheControl $receiver = cacheControl;
        $receiver.setMaxAge(7776000);
        CacheControl cacheControl2 = cacheControl;
        Response response = responseBuilder.cacheControl(cacheControl2).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response\n               \u2026\n                .build()");
        return response;
    }

    @POST
    @Path(value="/smtp/message")
    @NotNull
    public final Response sendSMTPMessage(@QueryParam(value="requireEmailVerification") @Nullable Boolean requireEmailVerification, @NotNull SmtpMessageJSON message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        ResourceUtilKt.daoAction((Function0)new Function0<Unit>(this, message, requireEmailVerification){
            final /* synthetic */ SettingsDAOResource this$0;
            final /* synthetic */ SmtpMessageJSON $message;
            final /* synthetic */ Boolean $requireEmailVerification;

            public final void invoke() {
                Boolean bl = this.$requireEmailVerification;
                this.this$0.getDao().sendSMTPMessage((SMTPMessage)this.$message, bl != null ? bl : true);
            }
            {
                this.this$0 = settingsDAOResource;
                this.$message = smtpMessageJSON;
                this.$requireEmailVerification = bl;
                super(0);
            }
        });
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @NotNull
    public SettingsDAOEntitySubresource createEntitySubResource(@NotNull String key, @NotNull Function0<? extends Settings> resolve2) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(resolve2, (String)"resolve");
        return new SettingsDAOEntitySubresource(resolve2);
    }

    public SettingsDAOResource() {
        ReadOnlyProperty readOnlyProperty;
        SettingsDAOResource settingsDAOResource = this;
        String name$iv = null;
        settingsDAOResource.localeManager$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @NotNull
    public static final /* synthetic */ LocaleContainer access$getLocaleManager$p(SettingsDAOResource $this) {
        return $this.getLocaleManager();
    }

    @OAuth(ignoreEUConsent=true)
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u0013\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0011\u001a\u00020\u00042\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0007J\u001c\u0010\u0014\u001a\u00020\u00042\b\b\u0001\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0007R@\u0010\t\u001a.\u0012*\u0012(\u0012\u0006\b\u0001\u0012\u00020\f\u0012\u0002\b\u00030\u000bR\u00180\rR\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000e0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Ljetbrains/jetpass/rest/api/SettingsDAOResource$SettingsDAOEntitySubresource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource$MutableDAOEntitySubresource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource;", "Ljetbrains/jetpass/api/settings/Settings;", "Ljetbrains/jetpass/rest/dto/SettingsJSON;", "Ljetbrains/jetpass/dao/api/settings/SettingsDAO;", "resolve", "Lkotlin/Function0;", "(Ljetbrains/jetpass/rest/api/SettingsDAOResource;Lkotlin/jvm/functions/Function0;)V", "links", "", "Ljetbrains/jetpass/rest/api/resource/DAOResource$DAOEntitySubresource$LinkDAOSubresource;", "Ljetbrains/jetpass/api/authority/AuthorityHolder;", "Ljetbrains/jetpass/rest/api/resource/DAOResource$DAOEntitySubresource;", "Ljetbrains/jetpass/rest/api/resource/DAOResource;", "getLinks", "()Ljava/util/List;", "reset", "request", "Ljavax/servlet/http/HttpServletRequest;", "test", "contact", "", "jetbrains.jetpass.rest"})
    public final class SettingsDAOEntitySubresource
    extends MutableDAOResource.MutableDAOEntitySubresource {
        @NotNull
        private final List<DAOResource.LinkDAOSubresource<? extends AuthorityHolder, ?>> links;

        @NotNull
        public List<DAOResource.LinkDAOSubresource<? extends AuthorityHolder, ?>> getLinks() {
            return this.links;
        }

        @POST
        @Path(value="/reset")
        @Produces(value={"application/json;charset=UTF-8"})
        @NotNull
        public final SettingsJSON reset(@Context @NotNull HttpServletRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            return (SettingsJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<Settings>(this){
                final /* synthetic */ SettingsDAOEntitySubresource this$0;

                @NotNull
                public final Settings invoke() {
                    JetPassSettingsDAO jetPassSettingsDAO = this.this$0.SettingsDAOResource.this.getDao();
                    String string = ((Settings)this.this$0.getResolveEntity().invoke()).getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolveEntity().id");
                    return jetPassSettingsDAO.reset(string);
                }
                {
                    this.this$0 = settingsDAOEntitySubresource;
                    super(0);
                }
            });
        }

        @POST
        @Path(value="/test")
        @Produces(value={"application/json;charset=UTF-8"})
        @NotNull
        public final SettingsJSON test(@QueryParam(value="contact") @NotNull String contact, @Context @NotNull HttpServletRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)contact, (String)"contact");
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            return (SettingsJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<Settings>(this, contact){
                final /* synthetic */ SettingsDAOEntitySubresource this$0;
                final /* synthetic */ String $contact;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Settings invoke() {
                    void var1_1;
                    Settings settings = (Settings)this.this$0.getResolveEntity().invoke();
                    Settings settings2 = settings;
                    if (settings2 instanceof SMTPSettings) {
                        ResourceUtilKt.daoAction((Function0)new Function0<Unit>(this){
                            final /* synthetic */ test.1 this$0;

                            public final void invoke() {
                                this.this$0.this$0.SettingsDAOResource.this.getDao().testEmail(this.this$0.$contact);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    } else if (settings2 instanceof JabberSettings) {
                        ResourceUtilKt.daoAction((Function0)new Function0<Unit>(this){
                            final /* synthetic */ test.1 this$0;

                            public final void invoke() {
                                this.this$0.this$0.SettingsDAOResource.this.getDao().testJabber(this.this$0.$contact);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    } else {
                        throw (Throwable)new NotFoundException("Unknown type of contact settings " + settings.getClass());
                    }
                    return var1_1;
                }
                {
                    this.this$0 = settingsDAOEntitySubresource;
                    this.$contact = string;
                    super(0);
                }
            });
        }

        public SettingsDAOEntitySubresource(Function0<? extends Settings> resolve2) {
            Intrinsics.checkParameterIsNotNull(resolve2, (String)"resolve");
            super(SettingsDAOResource.this, resolve2);
            this.links = CollectionsKt.listOf((Object[])new DAOResource.DAOEntitySubresource.LinkDAOSubresource[]{new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "User"){
                @NotNull
                private final SubtypeLinkDAO<Settings, LicenseSettings, User, UserJSON> linkDAO;
                final /* synthetic */ SettingsDAOEntitySubresource this$0;

                @NotNull
                public SubtypeLinkDAO<Settings, LicenseSettings, User, UserJSON> getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new SubtypeLinkDAO<I, SI, CI, CJ>(Reflection.getOrCreateKotlinClass(LicenseSettings.class), (LinkDAO)new LinkDAO<LicenseSettings, User, UserJSON>(this){
                        final /* synthetic */ links.1 this$0;

                        public Iterable<User> getChildren(@NotNull LicenseSettings $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getUsers();
                        }

                        public String getChildKey(@NotNull User $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public User addChild(@NotNull LicenseSettings $receiver, @NotNull User child, @NotNull HttpServletRequest request) {
                            User user;
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            User it = user = child;
                            this.this$0.this$0.SettingsDAOResource.this.getApi().getUserDAO().addLicense(child, $receiver);
                            return user;
                        }

                        public void removeChild(@NotNull LicenseSettings $receiver, @NotNull User child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            this.this$0.this$0.SettingsDAOResource.this.getApi().getUserDAO().removeLicense(child, $receiver);
                        }

                        @Nullable
                        public User findChild(@NotNull LicenseSettings $receiver, @NotNull String childKey, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)childKey, (String)"childKey");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return (User)this.this$0.this$0.SettingsDAOResource.this.getApi().getUserDAO().getAllItems().query("hasLicense: {" + $receiver.getId() + "} and id: {" + childKey + '}').first();
                        }
                        {
                            this.this$0 = $outer;
                        }
                    });
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "AutoJoinGroup"){
                @NotNull
                private final SubtypeLinkDAO<Settings, LicenseSettings, UserGroup, UserGroupJSON> linkDAO;
                final /* synthetic */ SettingsDAOEntitySubresource this$0;

                @NotNull
                public SubtypeLinkDAO<Settings, LicenseSettings, UserGroup, UserGroupJSON> getLinkDAO() {
                    return this.linkDAO;
                }

                @NotNull
                public LinkSubresourceMetaData getMetaData() {
                    LinkSubresourceMetaData linkSubresourceMetaData;
                    LinkSubresourceMetaData $receiver = linkSubresourceMetaData = super.getMetaData();
                    ResourceUtilKt.addQueryParam($receiver.getDeleteMethod(), SettingsDAOResourceKt.access$getKEEP_USERS$p());
                    return linkSubresourceMetaData;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new SubtypeLinkDAO<I, SI, CI, CJ>(Reflection.getOrCreateKotlinClass(LicenseSettings.class), (LinkDAO)new LinkDAO<LicenseSettings, UserGroup, UserGroupJSON>(this){
                        final /* synthetic */ links.2 this$0;

                        public Iterable<UserGroup> getChildren(@NotNull LicenseSettings $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getAutoJoinGroups();
                        }

                        public String getChildKey(@NotNull UserGroup $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public UserGroup addChild(@NotNull LicenseSettings $receiver, @NotNull UserGroup child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return this.this$0.this$0.SettingsDAOResource.this.getDao().addAutoJoinGroup($receiver, child);
                        }

                        public void removeChild(@NotNull LicenseSettings $receiver, @NotNull UserGroup child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            this.this$0.this$0.SettingsDAOResource.this.getDao().removeAutoJoinGroup($receiver, child, ResourceUtilKt.get(request, SettingsDAOResourceKt.access$getKEEP_USERS$p()));
                        }
                        {
                            this.this$0 = $outer;
                        }
                    });
                }
            }});
        }
    }
}

