/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.authority.Profile;
import jetbrains.jetpass.api.authority.SshPublicKey;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.authority.auth.ApprovedScope;
import jetbrains.jetpass.api.authority.auth.PermanentToken;
import jetbrains.jetpass.api.authority.auth.RefreshToken;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.api.authority.totp.ApplicationPassword;
import jetbrains.jetpass.api.authority.totp.TwoFactorAuthenticationSecret;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.security.access.SourcedProjectRole;
import jetbrains.jetpass.api.settings.LicenseSettings;
import jetbrains.jetpass.dao.api.authority.UserDAO;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassEndUserAgreementConsent;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassProfile;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassSshPublicKey;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUserDAO;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUserGroupDelegatingDAO;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.oauth2.rest.security.OAuth;
import jetbrains.jetpass.rest.api.UserDAOResource;
import jetbrains.jetpass.rest.api.resource.DAOResource;
import jetbrains.jetpass.rest.api.resource.LinkDAO;
import jetbrains.jetpass.rest.api.resource.MutableDAOResource;
import jetbrains.jetpass.rest.api.resource.ResourceUtilKt;
import jetbrains.jetpass.rest.api.serialization.impl.SerializationExtKt;
import jetbrains.jetpass.rest.common.ExceptionExtKt;
import jetbrains.jetpass.rest.common.doc.RestDoc;
import jetbrains.jetpass.rest.dto.ApplicationPasswordJSON;
import jetbrains.jetpass.rest.dto.ApprovedScopeJSON;
import jetbrains.jetpass.rest.dto.Confirm2FAJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.EndUserAgreementConsentJSON;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.PermanentTokenJSON;
import jetbrains.jetpass.rest.dto.ProfileJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.RefreshTokenJSON;
import jetbrains.jetpass.rest.dto.Setup2FAJSON;
import jetbrains.jetpass.rest.dto.SourcedProjectRoleJSON;
import jetbrains.jetpass.rest.dto.SshPublicKeyJSON;
import jetbrains.jetpass.rest.dto.TwoFactorAuthenticationSecretJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.FieldQuery;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.RequestFieldQuery;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/users")
@OAuth
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0007J\"\u0010\u000f\u001a\u00060\u0010R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00032\b\b\u0001\u0010\f\u001a\u00020\rH\u0007JB\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00172\b\b\u0001\u0010\f\u001a\u00020\r2\u000e\b\u0001\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0007J\u0016\u0010\u001b\u001a\u00060\u0010R\u00020\u00002\b\b\u0001\u0010\f\u001a\u00020\rH\u0007Jm\u0010\u001c\u001a\u00020\u00032\b\b\u0001\u0010\f\u001a\u00020\r2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010 \u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\"2\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030$H\u0007\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020'H\u0007R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006)"}, d2={"Ljetbrains/jetpass/rest/api/UserDAOResource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource;", "Ljetbrains/jetpass/api/authority/User;", "Ljetbrains/jetpass/rest/dto/UserJSON;", "Ljetbrains/jetpass/dao/api/authority/UserDAO;", "()V", "dao", "Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserDAO;", "getDao", "()Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserDAO;", "acceptEndUserAgreement", "Ljetbrains/jetpass/rest/dto/EndUserAgreementConsentJSON;", "request", "Ljavax/servlet/http/HttpServletRequest;", "requestBody", "createEntitySubResource", "Ljetbrains/jetpass/rest/api/UserDAOResource$UserDAOEntitySubresource;", "key", "", "resolve", "Lkotlin/Function0;", "getGuest", "invite", "", "emails", "groupID", "baseUrl", "me", "merge", "login", "name", "email", "jabber", "banned", "", "twoFactorAuthentication", "", "(Ljavax/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;[Ljetbrains/jetpass/rest/dto/UserJSON;)Ljetbrains/jetpass/rest/dto/UserJSON;", "revokeEndUserAgreementConsent", "Ljavax/ws/rs/core/Response;", "UserDAOEntitySubresource", "jetbrains.jetpass.rest"})
public final class UserDAOResource
extends MutableDAOResource<User, UserJSON, UserDAO> {
    @Override
    @NotNull
    public JetPassUserDAO getDao() {
        return this.getApi().getUserDAO();
    }

    @POST
    @Path(value="/invite")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final List<UserJSON> invite(@Context @NotNull HttpServletRequest request, @QueryParam(value="email") @NotNull List<String> emails, @QueryParam(value="group") @Nullable String groupID, @QueryParam(value="baseUrl") @Nullable String baseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(emails, (String)"emails");
        return (List)ResourceUtilKt.daoAction((Function0)new Function0<List<? extends UserJSON>>(this, request, emails, baseUrl, groupID){
            final /* synthetic */ UserDAOResource this$0;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ List $emails;
            final /* synthetic */ String $baseUrl;
            final /* synthetic */ String $groupID;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<UserJSON> invoke() {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                RequestFieldQuery fieldQuery = new RequestFieldQuery(this.$request, 0, null, 6, null);
                Iterable iterable = $receiver$iv = (Iterable)this.$emails;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    UserJSON userJSON;
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    User invitedUser = this.this$0.getDao().invite((String)it, this.$baseUrl);
                    if (invitedUser != null) {
                        User user;
                        User it2 = user;
                        String string2 = this.$groupID;
                        if (string2 != null) {
                            String string3;
                            String it3 = string3 = string2;
                            CharSequence charSequence = this.$groupID;
                            string2 = charSequence.length() > 0 ? string3 : null;
                            if (string2 != null) {
                                it3 = string3 = string2;
                                JetPassUserGroupDelegatingDAO jetPassUserGroupDelegatingDAO = this.this$0.getApi().getUserGroupDAO();
                                String string4 = invitedUser.getId();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"invitedUser.id");
                                jetPassUserGroupDelegatingDAO.addUser(this.$groupID, string4);
                            }
                        }
                        userJSON = (UserJSON)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, UserJSON>(invitedUser, this, fieldQuery){
                            final /* synthetic */ User $invitedUser$inlined;
                            final /* synthetic */ invite.1 this$0;
                            final /* synthetic */ RequestFieldQuery $fieldQuery$inlined;
                            {
                                this.$invitedUser$inlined = user;
                                this.this$0 = var2_2;
                                this.$fieldQuery$inlined = requestFieldQuery;
                                super(1);
                            }

                            @NotNull
                            public final UserJSON invoke(@NotNull TransientStoreSession it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return (UserJSON)SerializationExtKt.asJSON(this.$invitedUser$inlined, (FieldQuery)this.$fieldQuery$inlined);
                            }
                        }), (int)7, null);
                    } else {
                        userJSON = null;
                    }
                    UserJSON userJSON2 = userJSON;
                    collection.add(userJSON2);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = userDAOResource;
                this.$request = httpServletRequest;
                this.$emails = list;
                this.$baseUrl = string;
                this.$groupID = string2;
                super(0);
            }
        });
    }

    @Path(value="/me")
    @NotNull
    public final UserDAOEntitySubresource me(@Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return this.createEntitySubResource("me", me.1.INSTANCE);
    }

    @GET
    @Path(value="/guest")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final UserJSON getGuest(@Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return (UserJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<User>(this){
            final /* synthetic */ UserDAOResource this$0;

            @NotNull
            public final User invoke() {
                return (User)ExceptionExtKt.checkExists((Object)this.this$0.getDao().getGuest());
            }
            {
                this.this$0 = userDAOResource;
                super(0);
            }
        });
    }

    @POST
    @Path(value="/merge")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final UserJSON merge(@Context @NotNull HttpServletRequest request, @QueryParam(value="login") @Nullable String login, @QueryParam(value="name") @Nullable String name, @QueryParam(value="email") @Nullable String email, @QueryParam(value="jabber") @Nullable String jabber, @QueryParam(value="banned") @Nullable Boolean banned, @QueryParam(value="twoFactorAuthentication") @Nullable String twoFactorAuthentication, @NotNull UserJSON[] requestBody) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)requestBody, (String)"requestBody");
        return (UserJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<User>(this, requestBody, login, name, email, jabber, banned, twoFactorAuthentication){
            final /* synthetic */ UserDAOResource this$0;
            final /* synthetic */ UserJSON[] $requestBody;
            final /* synthetic */ String $login;
            final /* synthetic */ String $name;
            final /* synthetic */ String $email;
            final /* synthetic */ String $jabber;
            final /* synthetic */ Boolean $banned;
            final /* synthetic */ String $twoFactorAuthentication;

            @NotNull
            public final User invoke() {
                Iterable users = ArraysKt.asIterable((Object[])this.$requestBody);
                return this.this$0.getDao().merge(users, this.$login, this.$name, this.$email, this.$jabber, this.$banned, this.$twoFactorAuthentication);
            }
            {
                this.this$0 = userDAOResource;
                this.$requestBody = userJSONArray;
                this.$login = string;
                this.$name = string2;
                this.$email = string3;
                this.$jabber = string4;
                this.$banned = bl;
                this.$twoFactorAuthentication = string5;
                super(0);
            }
        });
    }

    @POST
    @Path(value="/endUserAgreementConsent")
    @OAuth(ignoreEUConsent=true)
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final EndUserAgreementConsentJSON acceptEndUserAgreement(@Context @NotNull HttpServletRequest request, @Nullable EndUserAgreementConsentJSON requestBody) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return (EndUserAgreementConsentJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<JetPassEndUserAgreementConsent>(this){
            final /* synthetic */ UserDAOResource this$0;

            @NotNull
            public final JetPassEndUserAgreementConsent invoke() {
                return this.this$0.getDao().acceptEndUserAgreement();
            }
            {
                this.this$0 = userDAOResource;
                super(0);
            }
        });
    }

    @DELETE
    @Path(value="/endUserAgreementConsent")
    @OAuth(ignoreEUConsent=true)
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final Response revokeEndUserAgreementConsent() {
        ResourceUtilKt.daoAction((Function0)new Function0<Unit>(this){
            final /* synthetic */ UserDAOResource this$0;

            public final void invoke() {
                this.this$0.getDao().revokeEndUserAgreementConsent();
            }
            {
                this.this$0 = userDAOResource;
                super(0);
            }
        });
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @NotNull
    public UserDAOEntitySubresource createEntitySubResource(@NotNull String key, @NotNull Function0<? extends User> resolve2) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(resolve2, (String)"resolve");
        return new UserDAOEntitySubresource(resolve2);
    }

    @OAuth
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0087\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u0013\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0012\u0010\u0017\u001a\u00020\u00042\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\b\u0010\u001a\u001a\u00020\u0019H\u0007J\u0012\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0007J\u001a\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001fH\u0007J\u001a\u0010 \u001a\u00020!2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020!H\u0007R@\u0010\t\u001a.\u0012*\u0012(\u0012\u0006\b\u0001\u0012\u00020\f\u0012\u0002\b\u00030\u000bR\u00180\rR\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000e0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Ljetbrains/jetpass/rest/api/UserDAOResource$UserDAOEntitySubresource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource$MutableDAOEntitySubresource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource;", "Ljetbrains/jetpass/api/authority/User;", "Ljetbrains/jetpass/rest/dto/UserJSON;", "Ljetbrains/jetpass/dao/api/authority/UserDAO;", "resolve", "Lkotlin/Function0;", "(Ljetbrains/jetpass/rest/api/UserDAOResource;Lkotlin/jvm/functions/Function0;)V", "links", "", "Ljetbrains/jetpass/rest/api/resource/DAOResource$DAOEntitySubresource$LinkDAOSubresource;", "", "Ljetbrains/jetpass/rest/api/resource/DAOResource$DAOEntitySubresource;", "Ljetbrains/jetpass/rest/api/resource/DAOResource;", "getLinks", "()Ljava/util/List;", "confirm2FA", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "body", "Ljetbrains/jetpass/rest/dto/Confirm2FAJSON;", "erasePersonalData", "getOne", "Ljavax/ws/rs/core/Response;", "getPersonalData", "removeLocale", "", "setup2FA", "Ljetbrains/jetpass/rest/dto/TwoFactorAuthenticationSecretJSON;", "Ljetbrains/jetpass/rest/dto/Setup2FAJSON;", "verifyContact", "Ljetbrains/jetpass/rest/dto/ProfileJSON;", "jetbrains.jetpass.rest"})
    public final class UserDAOEntitySubresource
    extends MutableDAOResource.MutableDAOEntitySubresource {
        @NotNull
        private final List<DAOResource.LinkDAOSubresource<? extends Object, ?>> links;

        @Override
        @OAuth(ignoreEUConsent=true)
        @NotNull
        public Response getOne(@NotNull HttpServletRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            return super.getOne(request);
        }

        @POST
        @Path(value="/verifyContact")
        @Produces(value={"application/json;charset=UTF-8"})
        @NotNull
        public final ProfileJSON verifyContact(@Context @NotNull HttpServletRequest request, @NotNull ProfileJSON body) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            return (ProfileJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<JetPassProfile>(this, body){
                final /* synthetic */ UserDAOEntitySubresource this$0;
                final /* synthetic */ ProfileJSON $body;

                @NotNull
                public final JetPassProfile invoke() {
                    JetPassUserDAO jetPassUserDAO = this.this$0.UserDAOResource.this.getDao();
                    String string = ((User)this.this$0.getResolveEntity().invoke()).getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolveEntity().id");
                    return jetPassUserDAO.verifyContact(string, (Profile)this.$body);
                }
                {
                    this.this$0 = userDAOEntitySubresource;
                    this.$body = profileJSON;
                    super(0);
                }
            });
        }

        @POST
        @Path(value="/removeLocale")
        @Produces(value={"application/json;charset=UTF-8"})
        public final void removeLocale(@Context @NotNull HttpServletRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            ResourceUtilKt.daoAction((Function0)new Function0<Unit>(this){
                final /* synthetic */ UserDAOEntitySubresource this$0;

                public final void invoke() {
                    this.this$0.UserDAOResource.this.getDao().removeUserLocale((User)this.this$0.getResolveEntity().invoke());
                }
                {
                    this.this$0 = userDAOEntitySubresource;
                    super(0);
                }
            });
        }

        @RestDoc(operationName="Personal Data")
        @GET
        @Path(value="/data")
        @OAuth(ignoreEUConsent=true)
        @Produces(value={"text/csv", "application/json;charset=UTF-8"})
        @NotNull
        public final Response getPersonalData() {
            Object t = ResourceUtilKt.daoAction((Function0)new Function0<Response>(this){
                final /* synthetic */ UserDAOEntitySubresource this$0;

                public final Response invoke() {
                    Response response = Response.ok((Object)this.this$0.UserDAOResource.this.getDao().getPersonalData((User)this.this$0.getResolveEntity().invoke())).header("Content-Disposition", (Object)"attachment; filename=\"personal-data.csv\"").build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(dao.getPerso\u2026                 .build()");
                    return response;
                }
                {
                    this.this$0 = userDAOEntitySubresource;
                    super(0);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"daoAction {\n            \u2026       .build()\n        }");
            return (Response)t;
        }

        @POST
        @Path(value="/data/erase")
        @Produces(value={"application/json;charset=UTF-8"})
        @NotNull
        public final UserJSON erasePersonalData(@Context @NotNull HttpServletRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            return (UserJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<User>(this){
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public final User invoke() {
                    return this.this$0.UserDAOResource.this.getDao().erasePersonalData((User)this.this$0.getResolveEntity().invoke());
                }
                {
                    this.this$0 = userDAOEntitySubresource;
                    super(0);
                }
            });
        }

        @POST
        @Path(value="twoFactorAuthentication")
        @Produces(value={"application/json;charset=UTF-8"})
        @NotNull
        public final TwoFactorAuthenticationSecretJSON setup2FA(@Context @NotNull HttpServletRequest request, @NotNull Setup2FAJSON body) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            return (TwoFactorAuthenticationSecretJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<TwoFactorAuthenticationSecret>(this, body){
                final /* synthetic */ UserDAOEntitySubresource this$0;
                final /* synthetic */ Setup2FAJSON $body;

                @NotNull
                public final TwoFactorAuthenticationSecret invoke() {
                    Boolean bl = this.$body.getConfirm();
                    return this.this$0.UserDAOResource.this.getDao().setup2FA((User)this.this$0.getResolveEntity().invoke(), bl != null ? bl : false);
                }
                {
                    this.this$0 = userDAOEntitySubresource;
                    this.$body = setup2FAJSON;
                    super(0);
                }
            });
        }

        @POST
        @Path(value="twoFactorAuthentication/confirm")
        @Produces(value={"application/json;charset=UTF-8"})
        public final boolean confirm2FA(@Context @NotNull HttpServletRequest request, @NotNull Confirm2FAJSON body) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            Integer n = body.getCode();
            if (n == null) {
                throw (Throwable)new BadRequestException("Integer parameter 'code' is expected");
            }
            int code = n;
            return (Boolean)ResourceUtilKt.daoAction((Function0)new Function0<Boolean>(this, code){
                final /* synthetic */ UserDAOEntitySubresource this$0;
                final /* synthetic */ int $code;

                public final boolean invoke() {
                    this.this$0.UserDAOResource.this.getDao().confirm2FA((User)this.this$0.getResolveEntity().invoke(), this.$code);
                    return true;
                }
                {
                    this.this$0 = userDAOEntitySubresource;
                    this.$code = n;
                    super(0);
                }
            });
        }

        @NotNull
        public List<DAOResource.LinkDAOSubresource<? extends Object, ?>> getLinks() {
            return this.links;
        }

        public UserDAOEntitySubresource(Function0<? extends User> resolve2) {
            Intrinsics.checkParameterIsNotNull(resolve2, (String)"resolve");
            super(UserDAOResource.this, resolve2);
            this.links = CollectionsKt.listOf((Object[])new DAOResource.DAOEntitySubresource.LinkDAOSubresource[]{new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "UserDetail"){
                @NotNull
                private final links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<User, UserDetails, DetailsJSON>(this){
                        final /* synthetic */ links.1 this$0;

                        public Iterable<UserDetails> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getDetails();
                        }

                        public String getChildKey(@NotNull UserDetails $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public UserDetails addChild(@NotNull User $receiver, @NotNull UserDetails child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            JetPassUserDAO jetPassUserDAO = this.this$0.this$0.UserDAOResource.this.getDao();
                            String string = $receiver.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.id");
                            return jetPassUserDAO.addUserDetails(string, child);
                        }

                        public void removeChild(@NotNull User $receiver, @NotNull UserDetails child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            JetPassUserDAO jetPassUserDAO = this.this$0.this$0.UserDAOResource.this.getDao();
                            String string = $receiver.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.id");
                            String string2 = child.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"child.id");
                            jetPassUserDAO.removeUserDetails(string, string2);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "ProjectRole"){
                @NotNull
                private final UserDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public UserDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<User, ProjectRole, ProjectRoleJSON>(this){
                        final /* synthetic */ links.2 this$0;

                        public Iterable<ProjectRole> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getProjectRoles();
                        }

                        public String getChildKey(@NotNull ProjectRole $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public ProjectRole addChild(@NotNull User $receiver, @NotNull ProjectRole child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            JetPassUserDAO jetPassUserDAO = this.this$0.this$0.UserDAOResource.this.getDao();
                            String string = $receiver.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.id");
                            return jetPassUserDAO.addRole(string, child);
                        }

                        public void removeChild(@NotNull User $receiver, @NotNull ProjectRole child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            this.this$0.this$0.UserDAOResource.this.getDao().removeRole($receiver.getId(), child.getId());
                        }
                        {
                            this.this$0 = $outer;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "TransitiveProjectRole"){
                @NotNull
                private final UserDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public UserDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<User, ProjectRole, ProjectRoleJSON>(){

                        public Iterable<ProjectRole> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getTransitiveProjectRoles();
                        }

                        public String getChildKey(@NotNull ProjectRole $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public Void addChild(@NotNull User $receiver, @NotNull ProjectRole child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            Void void_ = DAOResource.Companion.UNSUPPORTED();
                            throw null;
                        }

                        @NotNull
                        public Void removeChild(@NotNull User $receiver, @NotNull ProjectRole child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            Void void_ = DAOResource.Companion.UNSUPPORTED();
                            throw null;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "SourcedProjectRole"){
                @NotNull
                private final UserDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public UserDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<User, SourcedProjectRole, SourcedProjectRoleJSON>(){

                        public Iterable<SourcedProjectRole> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getSourcedProjectRoles();
                        }

                        public String getChildKey(@NotNull SourcedProjectRole $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public Void addChild(@NotNull User $receiver, @NotNull SourcedProjectRole child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            Void void_ = DAOResource.Companion.UNSUPPORTED();
                            throw null;
                        }

                        @NotNull
                        public Void removeChild(@NotNull User $receiver, @NotNull SourcedProjectRole child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            Void void_ = DAOResource.Companion.UNSUPPORTED();
                            throw null;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "Group"){
                @NotNull
                private final UserDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public UserDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<User, UserGroup, UserGroupJSON>(this){
                        final /* synthetic */ links.5 this$0;

                        public Iterable<UserGroup> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getGroups();
                        }

                        public String getChildKey(@NotNull UserGroup $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @Nullable
                        public UserGroup findChild(@NotNull User $receiver, @NotNull String childKey, @NotNull HttpServletRequest request) {
                            UserGroup userGroup;
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)childKey, (String)"childKey");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            UserGroup userGroup2 = this.this$0.this$0.UserDAOResource.this.getApi().getUserGroupDAO().get(childKey);
                            if (userGroup2 != null) {
                                UserGroup userGroup3;
                                UserGroup group = userGroup3 = userGroup2;
                                Boolean bl = group.isAllUsers();
                                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"group.isAllUsers");
                                userGroup = bl.booleanValue() ? group : (UserGroup)this.this$0.this$0.UserDAOResource.this.getApi().getUserGroupDAO().getAllItems().query("user: {" + $receiver.getId() + "} and id: {" + childKey + '}').first();
                            } else {
                                userGroup = null;
                            }
                            return userGroup;
                        }

                        @NotNull
                        public UserGroup addChild(@NotNull User $receiver, @NotNull UserGroup child, @NotNull HttpServletRequest request) {
                            UserGroup userGroup;
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            UserGroup it = userGroup = child;
                            JetPassUserGroupDelegatingDAO jetPassUserGroupDelegatingDAO = this.this$0.this$0.UserDAOResource.this.getApi().getUserGroupDAO();
                            String string = child.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"child.id");
                            String string2 = $receiver.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"this.id");
                            jetPassUserGroupDelegatingDAO.addUser(string, string2);
                            return userGroup;
                        }

                        public void removeChild(@NotNull User $receiver, @NotNull UserGroup child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            JetPassUserGroupDelegatingDAO jetPassUserGroupDelegatingDAO = this.this$0.this$0.UserDAOResource.this.getApi().getUserGroupDAO();
                            String string = child.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"child.id");
                            String string2 = $receiver.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"this.id");
                            jetPassUserGroupDelegatingDAO.removeUser(string, string2);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "TransitiveGroup"){
                @NotNull
                private final UserDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public UserDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<User, UserGroup, UserGroupJSON>(){

                        public Iterable<UserGroup> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getTransitiveGroups();
                        }

                        public String getChildKey(@NotNull UserGroup $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public Void addChild(@NotNull User $receiver, @NotNull UserGroup child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            Void void_ = DAOResource.Companion.UNSUPPORTED();
                            throw null;
                        }

                        @NotNull
                        public Void removeChild(@NotNull User $receiver, @NotNull UserGroup child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            Void void_ = DAOResource.Companion.UNSUPPORTED();
                            throw null;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "SshPublicKey"){
                @NotNull
                private final UserDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public UserDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<User, SshPublicKey, SshPublicKeyJSON>(this){
                        final /* synthetic */ links.7 this$0;

                        public Iterable<SshPublicKey> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getSshPublicKeys();
                        }

                        public String getChildKey(@NotNull SshPublicKey $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getFingerPrint();
                        }

                        @NotNull
                        public JetPassSshPublicKey addChild(@NotNull User $receiver, @NotNull SshPublicKey child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            JetPassUserDAO jetPassUserDAO = this.this$0.this$0.UserDAOResource.this.getDao();
                            String string = $receiver.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.id");
                            return jetPassUserDAO.addSshPublicKey(string, child);
                        }

                        public void removeChild(@NotNull User $receiver, @NotNull SshPublicKey child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            JetPassUserDAO jetPassUserDAO = this.this$0.this$0.UserDAOResource.this.getDao();
                            String string = $receiver.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.id");
                            String string2 = child.getFingerPrint();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"child.fingerPrint");
                            jetPassUserDAO.removeSshPublicKey(string, string2);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "License"){
                @NotNull
                private final UserDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public UserDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<User, LicenseSettings, LicenseJSON>(this){
                        final /* synthetic */ links.8 this$0;

                        public Iterable<LicenseSettings> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getLicenses();
                        }

                        public String getChildKey(@NotNull LicenseSettings $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public LicenseSettings addChild(@NotNull User $receiver, @NotNull LicenseSettings child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return this.this$0.this$0.UserDAOResource.this.getDao().addLicense($receiver, child);
                        }

                        public void removeChild(@NotNull User $receiver, @NotNull LicenseSettings child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            this.this$0.this$0.UserDAOResource.this.getDao().removeLicense($receiver, child);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "RefreshToken"){
                @NotNull
                private final UserDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public UserDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<User, RefreshToken, RefreshTokenJSON>(this){
                        final /* synthetic */ links.9 this$0;

                        public Iterable<RefreshToken> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getRefreshTokens();
                        }

                        public String getChildKey(@NotNull RefreshToken $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public Void addChild(@NotNull User $receiver, @NotNull RefreshToken child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            Void void_ = DAOResource.Companion.UNSUPPORTED();
                            throw null;
                        }

                        public void removeChild(@NotNull User $receiver, @NotNull RefreshToken child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            this.this$0.this$0.UserDAOResource.this.getDao().removeRefreshToken($receiver, child);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "PermanentToken"){
                @NotNull
                private final UserDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public UserDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<User, PermanentToken, PermanentTokenJSON>(this){
                        final /* synthetic */ links.10 this$0;

                        public Iterable<PermanentToken> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getPermanentTokens();
                        }

                        public String getChildKey(@NotNull PermanentToken $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public PermanentToken addChild(@NotNull User $receiver, @NotNull PermanentToken child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return this.this$0.this$0.UserDAOResource.this.getDao().addPermanentToken($receiver, child);
                        }

                        public void removeChild(@NotNull User $receiver, @NotNull PermanentToken child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            this.this$0.this$0.UserDAOResource.this.getDao().removePermanentToken($receiver, child);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "ApplicationPassword"){
                @NotNull
                private final String itemsPropertyName = "applicationPasswords";
                @NotNull
                private final UserDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public String getItemsPropertyName() {
                    return this.itemsPropertyName;
                }

                @NotNull
                public UserDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.itemsPropertyName = "applicationPasswords";
                    this.linkDAO = new LinkDAO<User, ApplicationPassword, ApplicationPasswordJSON>(this){
                        final /* synthetic */ links.11 this$0;

                        public Iterable<ApplicationPassword> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getApplicationPasswords();
                        }

                        public String getChildKey(@NotNull ApplicationPassword $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public ApplicationPassword addChild(@NotNull User $receiver, @NotNull ApplicationPassword child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return this.this$0.this$0.UserDAOResource.this.getDao().addApplicationPassword($receiver, child);
                        }

                        public void removeChild(@NotNull User $receiver, @NotNull ApplicationPassword child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            this.this$0.this$0.UserDAOResource.this.getDao().removeApplicationPassword($receiver, child);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "ApprovedScope"){
                @NotNull
                private final UserDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public UserDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<User, ApprovedScope, ApprovedScopeJSON>(this){
                        final /* synthetic */ links.12 this$0;

                        public Iterable<ApprovedScope> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getApprovedScopes();
                        }

                        public String getChildKey(@NotNull ApprovedScope $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public Void addChild(@NotNull User $receiver, @NotNull ApprovedScope child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            Void void_ = DAOResource.Companion.UNSUPPORTED();
                            throw null;
                        }

                        public void removeChild(@NotNull User $receiver, @NotNull ApprovedScope child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            this.this$0.this$0.UserDAOResource.this.getDao().removeApprovedScope($receiver, child);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    };
                }
            }, new DAOResource.DAOEntitySubresource.LinkDAOSubresource(this, "FavoriteProject"){
                @NotNull
                private final UserDAOEntitySubresource.links.linkDAO.1 linkDAO;
                final /* synthetic */ UserDAOEntitySubresource this$0;

                @NotNull
                public UserDAOEntitySubresource.links.linkDAO.1 getLinkDAO() {
                    return this.linkDAO;
                }
                {
                    this.this$0 = $outer;
                    super($outer, $super_call_param$1, false, 2, null);
                    this.linkDAO = new LinkDAO<User, Project, ProjectJSON>(this){
                        final /* synthetic */ links.13 this$0;

                        public Iterable<Project> getChildren(@NotNull User $receiver, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return $receiver.getFavoriteProjects();
                        }

                        public String getChildKey(@NotNull Project $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            return $receiver.getId();
                        }

                        @NotNull
                        public Project addChild(@NotNull User $receiver, @NotNull Project child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            return this.this$0.this$0.UserDAOResource.this.getDao().addFavoriteProject($receiver, child);
                        }

                        public void removeChild(@NotNull User $receiver, @NotNull Project child, @NotNull HttpServletRequest request) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            this.this$0.this$0.UserDAOResource.this.getDao().removeFavoriteProject($receiver, child);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    };
                }
            }});
        }
    }
}

