/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.api;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import jetbrains.jetpass.api.widget.Widget;
import jetbrains.jetpass.api.widget.WidgetCapability;
import jetbrains.jetpass.dao.api.widget.WidgetDAO;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.widget.JetPassWidgetDAO;
import jetbrains.jetpass.oauth2.rest.security.OAuth;
import jetbrains.jetpass.rest.api.WidgetDAOResource;
import jetbrains.jetpass.rest.api.resource.DynamicServerPage;
import jetbrains.jetpass.rest.api.resource.DynamicServerPageKt;
import jetbrains.jetpass.rest.api.resource.MutableDAOResource;
import jetbrains.jetpass.rest.api.resource.ResourceUtilKt;
import jetbrains.jetpass.rest.common.sizeLimit.SizeLimited;
import jetbrains.jetpass.rest.dto.WidgetJSON;
import jetbrains.jetpass.sequence.Sequence;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.FieldQuery;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.RequestFieldQuery;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/widgets")
@OAuth
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 #2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002#$B\u0005\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0010\u001a\u00060\u0011R\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016JE\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u00132\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007\u00a2\u0006\u0002\u0010\u001fJ\u001c\u0010 \u001a\u00020\u00032\b\b\u0001\u0010!\u001a\u00020\"2\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0007R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Ljetbrains/jetpass/rest/api/WidgetDAOResource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource;", "Ljetbrains/jetpass/api/widget/Widget;", "Ljetbrains/jetpass/rest/dto/WidgetJSON;", "Ljetbrains/jetpass/dao/api/widget/WidgetDAO;", "()V", "dao", "Ljetbrains/jetpass/dao/dnq/api/widget/JetPassWidgetDAO;", "getDao", "()Ljetbrains/jetpass/dao/dnq/api/widget/JetPassWidgetDAO;", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "daoContainer$delegate", "Lkotlin/properties/ReadOnlyProperty;", "createEntitySubResource", "Ljetbrains/jetpass/rest/api/WidgetDAOResource$WidgetDAOEntitySubresource;", "key", "", "resolve", "Lkotlin/Function0;", "getAllRepositoryWidgets", "Ljavax/ws/rs/core/Response;", "request", "Ljavax/servlet/http/HttpServletRequest;", "info", "Ljavax/ws/rs/core/UriInfo;", "version", "latestOnly", "", "(Ljavax/servlet/http/HttpServletRequest;Ljavax/ws/rs/core/UriInfo;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "preview", "archive", "Ljava/io/InputStream;", "Companion", "WidgetDAOEntitySubresource", "jetbrains.jetpass.rest"})
public final class WidgetDAOResource
extends MutableDAOResource<Widget, WidgetJSON, WidgetDAO> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty daoContainer$delegate;
    private static final long MAX_ARCHIVE_SIZE = 0xA00000L;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(WidgetDAOResource.class), "daoContainer", "getDaoContainer()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;"))};
        Companion = new Companion(null);
    }

    private final JetPassDAOContainer getDaoContainer() {
        return (JetPassDAOContainer)this.daoContainer$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    @NotNull
    public JetPassWidgetDAO getDao() {
        return this.getDaoContainer().getJetPassWidgetDAO();
    }

    @POST
    @Path(value="/preview")
    @Consumes(value={"application/zip"})
    @NotNull
    public final WidgetJSON preview(@SizeLimited(value=0xA00000L) @NotNull InputStream archive, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return (WidgetJSON)ResourceUtilKt.restDAOAction(request, (Function0)new Function0<Widget>(this, archive){
            final /* synthetic */ WidgetDAOResource this$0;
            final /* synthetic */ InputStream $archive;

            @NotNull
            public final Widget invoke() {
                return WidgetDAOResource.access$getDaoContainer$p(this.this$0).getJetPassWidgetDAO().previewArchive(this.$archive);
            }
            {
                this.this$0 = widgetDAOResource;
                this.$archive = inputStream;
                super(0);
            }
        });
    }

    @GET
    @Path(value="/repository")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final Response getAllRepositoryWidgets(@Context @NotNull HttpServletRequest request, @Context @NotNull UriInfo info, @QueryParam(value="key") @Nullable String key, @QueryParam(value="version") @Nullable String version, @QueryParam(value="latestOnly") @Nullable Boolean latestOnly) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Object t = ResourceUtilKt.daoAction((Function0)new Function0<Response>(this, request, info, key, version, latestOnly){
            final /* synthetic */ WidgetDAOResource this$0;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ UriInfo $info;
            final /* synthetic */ String $key;
            final /* synthetic */ String $version;
            final /* synthetic */ Boolean $latestOnly;

            public final Response invoke() {
                RequestFieldQuery fieldQuery = new RequestFieldQuery(this.$request, this.this$0.getJetPass().getDefaultTop(), null, 4, null);
                URI resourceURI = this.$info.getAbsolutePath();
                Boolean bl = this.$latestOnly;
                Sequence sequence = this.this$0.getDao().getRepositoryWidgets(this.$key, this.$version, bl != null ? bl : false);
                String string = this.this$0.getItemsPropertyName();
                URI uRI = resourceURI;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"resourceURI");
                Response response = Response.ok(DynamicServerPageKt.asJSONPage(sequence, string, uRI, (FieldQuery)fieldQuery, new DynamicServerPage.CalculatedField[0])).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(dao.getRepos\u2026URI, fieldQuery)).build()");
                return response;
            }
            {
                this.this$0 = widgetDAOResource;
                this.$request = httpServletRequest;
                this.$info = uriInfo;
                this.$key = string;
                this.$version = string2;
                this.$latestOnly = bl;
                super(0);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"daoAction {\n        val \u2026ieldQuery)).build()\n    }");
        return (Response)t;
    }

    @NotNull
    public WidgetDAOEntitySubresource createEntitySubResource(@NotNull String key, @NotNull Function0<? extends Widget> resolve2) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(resolve2, (String)"resolve");
        return new WidgetDAOEntitySubresource(resolve2);
    }

    public WidgetDAOResource() {
        ReadOnlyProperty readOnlyProperty;
        WidgetDAOResource widgetDAOResource = this;
        String name$iv = null;
        widgetDAOResource.daoContainer$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @NotNull
    public static final /* synthetic */ JetPassDAOContainer access$getDaoContainer$p(WidgetDAOResource $this) {
        return $this.getDaoContainer();
    }

    @OAuth
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u0013\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u00a8\u0006\u0014"}, d2={"Ljetbrains/jetpass/rest/api/WidgetDAOResource$WidgetDAOEntitySubresource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource$MutableDAOEntitySubresource;", "Ljetbrains/jetpass/rest/api/resource/MutableDAOResource;", "Ljetbrains/jetpass/api/widget/Widget;", "Ljetbrains/jetpass/rest/dto/WidgetJSON;", "Ljetbrains/jetpass/dao/api/widget/WidgetDAO;", "resolve", "Lkotlin/Function0;", "(Ljetbrains/jetpass/rest/api/WidgetDAOResource;Lkotlin/jvm/functions/Function0;)V", "getArchiveSubresource", "", "guessMimeType", "", "fileName", "content", "", "guessMimeTypeFromName", "setCSP", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "widget", "jetbrains.jetpass.rest"})
    public final class WidgetDAOEntitySubresource
    extends MutableDAOResource.MutableDAOEntitySubresource {
        @Path(value="/archive")
        @NotNull
        public final Object getArchiveSubresource() {
            return new Object(this){
                final /* synthetic */ WidgetDAOEntitySubresource this$0;

                @GET
                @Produces(value={"application/zip"})
                @OAuth
                @NotNull
                public final InputStream getArchive() {
                    return (InputStream)ResourceUtilKt.daoAction((Function0)new Function0<InputStream>(this){
                        final /* synthetic */ getArchiveSubresource.1 this$0;

                        @NotNull
                        public final InputStream invoke() {
                            JetPassWidgetDAO jetPassWidgetDAO = WidgetDAOResource.access$getDaoContainer$p(this.this$0.this$0.WidgetDAOResource.this).getJetPassWidgetDAO();
                            String string = ((Widget)this.this$0.this$0.getResolveEntity().invoke()).getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolveEntity().id");
                            return jetPassWidgetDAO.getArchive(string);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }

                @GET
                @Path(value="/{filePath:.+}")
                public final Response getFile(@PathParam(value="filePath") @NotNull String filePath, @Context @NotNull Request request) {
                    Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
                    Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                    return (Response)ResourceUtilKt.daoAction((Function0)new Function0<Response>(this, filePath, request){
                        final /* synthetic */ getArchiveSubresource.1 this$0;
                        final /* synthetic */ String $filePath;
                        final /* synthetic */ Request $request;

                        public final Response invoke() {
                            Response response;
                            JetPassWidgetDAO jetPassWidgetDAO = WidgetDAOResource.access$getDaoContainer$p(this.this$0.this$0.WidgetDAOResource.this).getJetPassWidgetDAO();
                            String string = ((Widget)this.this$0.this$0.getResolveEntity().invoke()).getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolveEntity().id");
                            InputStream inputStream = jetPassWidgetDAO.getFileFromArchive(string, this.$filePath);
                            int n = 8192;
                            byte[] content = ByteStreamsKt.readBytes$default((InputStream)(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n)), (int)0, (int)1, null);
                            EntityTag etag = new EntityTag(Hex.encodeHexString((byte[])MessageDigest.getInstance("MD5").digest(content)));
                            Response.ResponseBuilder responseBuilder = this.$request.evaluatePreconditions(etag);
                            if (responseBuilder == null) {
                                String type = WidgetDAOEntitySubresource.access$guessMimeType(this.this$0.this$0, this.$filePath, content);
                                WidgetDAOEntitySubresource widgetDAOEntitySubresource = this.this$0.this$0;
                                Response.ResponseBuilder responseBuilder2 = Response.ok((Object)content, (String)type);
                                Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder2, (String)"Response.ok(content, type)");
                                response = WidgetDAOEntitySubresource.access$setCSP(widgetDAOEntitySubresource, responseBuilder2, (Widget)this.this$0.this$0.getResolveEntity().invoke()).tag(etag).build();
                            } else {
                                response = responseBuilder.build();
                            }
                            return response;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$filePath = string;
                            this.$request = request;
                            super(0);
                        }
                    });
                }
                {
                    this.this$0 = $outer;
                }
            };
        }

        private final String guessMimeType(String fileName, byte[] content) {
            String string;
            String string2 = this.guessMimeTypeFromName(fileName);
            if (string2 == null) {
                string2 = string = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(content));
            }
            if (string2 == null) {
                string = "application/octet-stream";
            }
            return string;
        }

        private final String guessMimeTypeFromName(String fileName) {
            return StringsKt.endsWith$default((String)fileName, (String)".js", (boolean)false, (int)2, null) ? "application/javascript" : (StringsKt.endsWith$default((String)fileName, (String)".css", (boolean)false, (int)2, null) ? "text/css" : (StringsKt.endsWith$default((String)fileName, (String)".json", (boolean)false, (int)2, null) ? "application/json" : (StringsKt.endsWith$default((String)fileName, (String)".jpg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".jpeg", (boolean)false, (int)2, null) ? "image/jpeg" : (StringsKt.endsWith$default((String)fileName, (String)".png", (boolean)false, (int)2, null) ? "image/png" : (StringsKt.endsWith$default((String)fileName, (String)".svg", (boolean)false, (int)2, null) ? "image/svg+xml" : (StringsKt.endsWith$default((String)fileName, (String)".webp", (boolean)false, (int)2, null) ? "image/webp" : (StringsKt.endsWith$default((String)fileName, (String)".gif", (boolean)false, (int)2, null) ? "image/gif" : URLConnection.guessContentTypeFromName(fileName))))))));
        }

        /*
         * WARNING - void declaration
         */
        private final Response.ResponseBuilder setCSP(@NotNull Response.ResponseBuilder $receiver, Widget widget) {
            List list;
            List defaultValues = CollectionsKt.listOf((Object[])new String[]{"sandbox", "allow-scripts", "allow-pointer-lock"});
            Iterable iterable = widget.getCapabilities();
            if (iterable != null) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable2 = $receiver$iv = iterable;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    String it = (String)element$iv$iv;
                    WidgetCapability widgetCapability = WidgetCapability.fromString((String)it);
                    String string2 = widgetCapability != null ? widgetCapability.getCspValue() : null;
                    if (string2 == null) continue;
                    String it$iv$iv = string = string2;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List requestedCapabilities = list;
            String values = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)defaultValues, (Iterable)requestedCapabilities), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            Response.ResponseBuilder responseBuilder = $receiver.header("Content-Security-Policy", (Object)values).header("X-Content-Security-Policy", (Object)values);
            Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder, (String)"this.header(\"Content-Sec\u2026Security-Policy\", values)");
            return responseBuilder;
        }

        public WidgetDAOEntitySubresource(Function0<? extends Widget> resolve2) {
            Intrinsics.checkParameterIsNotNull(resolve2, (String)"resolve");
            super(resolve2);
        }

        @NotNull
        public static final /* synthetic */ String access$guessMimeType(WidgetDAOEntitySubresource $this, @NotNull String fileName, @NotNull byte[] content) {
            return $this.guessMimeType(fileName, content);
        }

        @NotNull
        public static final /* synthetic */ Response.ResponseBuilder access$setCSP(WidgetDAOEntitySubresource $this, @NotNull Response.ResponseBuilder $receiver, @NotNull Widget widget) {
            return $this.setCSP($receiver, widget);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/jetpass/rest/api/WidgetDAOResource$Companion;", "", "()V", "MAX_ARCHIVE_SIZE", "", "jetbrains.jetpass.rest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

