/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.api.avatar;

import com.intellij.hub.core.data.uri.DataURI;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.avatar.AvatarGenerator;
import jetbrains.jetpass.rest.common.ExceptionExtKt;
import jetbrains.jetpass.rest.common.ResourceUtilKt;
import jetbrains.jetpass.service.api.UrlDAO;
import jetbrains.jetpass.spring.SpringUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/avatar")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J=\u0010\u000f\u001a\u00020\u00102\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J;\u0010\u0019\u001a\u00020\u00102\b\b\u0001\u0010\u001a\u001a\u00020\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018JE\u0010\u001b\u001a\u00020\u00102\b\b\u0001\u0010\u001c\u001a\u00020\u00122\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0001\u0010\u001d\u001a\u00020\u001eH\u0007\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\nH\u0002J)\u0010!\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\"\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010#R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Ljetbrains/jetpass/rest/api/avatar/AvatarResource;", "", "()V", "urlDAO", "Ljetbrains/jetpass/service/api/UrlDAO;", "getUrlDAO", "()Ljetbrains/jetpass/service/api/UrlDAO;", "urlDAO$delegate", "Lkotlin/properties/ReadOnlyProperty;", "avatarRedirect", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "kotlin.jvm.PlatformType", "uri", "Ljava/net/URI;", "avatarRender", "getDefaultAvatar", "Ljavax/ws/rs/core/Response;", "username", "", "size", "", "s", "dpr", "", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Double;)Ljavax/ws/rs/core/Response;", "getEmailAvatar", "email", "getUserAvatar", "userId", "request", "Ljavax/servlet/http/HttpServletRequest;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Double;Ljavax/servlet/http/HttpServletRequest;)Ljavax/ws/rs/core/Response;", "renderAnonymousAvatar", "renderDefaultAvatar", "devicePixelRatio", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Double;)Ljavax/ws/rs/core/Response$ResponseBuilder;", "Companion", "jetbrains.jetpass.rest"})
public final class AvatarResource {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty urlDAO$delegate;
    @NotNull
    public static final String IMAGE_ANY = "image/*";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AvatarResource.class), "urlDAO", "getUrlDAO()Ljetbrains/jetpass/service/api/UrlDAO;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final UrlDAO getUrlDAO() {
        return (UrlDAO)this.urlDAO$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @GET
    @Path(value="/default")
    @Produces(value={"image/*"})
    @NotNull
    public final Response getDefaultAvatar(@QueryParam(value="username") @Nullable String username, @QueryParam(value="size") @Nullable Integer size, @QueryParam(value="s") @Nullable Integer s, @QueryParam(value="dpr") @Nullable Double dpr) {
        Response.ResponseBuilder responseBuilder;
        String string;
        String string2;
        String string3 = username;
        if (string3 != null) {
            String string4 = string2 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string = null;
        }
        String trimmedUsername = string2 = string;
        if (trimmedUsername != null) {
            Integer n = size;
            if (n == null) {
                n = s;
            }
            responseBuilder = this.renderDefaultAvatar(trimmedUsername, n, dpr);
        } else {
            responseBuilder = this.renderAnonymousAvatar();
        }
        Response.ResponseBuilder response = responseBuilder;
        Response response2 = ResourceUtilKt.cache$default((Response.ResponseBuilder)response, (int)0, (int)1, null).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response.cache().build()");
        return response2;
    }

    @GET
    @Path(value="/email/{email}")
    @Produces(value={"*/*"})
    @NotNull
    public final Response getEmailAvatar(@PathParam(value="email") @NotNull String email, @QueryParam(value="size") @Nullable Integer size, @QueryParam(value="s") @Nullable Integer s, @QueryParam(value="dpr") @Nullable Double dpr) {
        Response.ResponseBuilder response;
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        UrlDAO urlDAO = this.getUrlDAO();
        Integer n = size;
        if (n == null) {
            n = s;
        }
        Response.ResponseBuilder responseBuilder = response = this.avatarRedirect(urlDAO.getEmailAvatar(email, n, dpr));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder, (String)"response");
        Response response2 = ResourceUtilKt.nocache((Response.ResponseBuilder)responseBuilder).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response.nocache().build()");
        return response2;
    }

    @GET
    @Path(value="/{userId}")
    @Produces(value={"*/*"})
    @NotNull
    public final Response getUserAvatar(@PathParam(value="userId") @NotNull String userId, @QueryParam(value="size") @Nullable Integer size, @QueryParam(value="s") @Nullable Integer s, @QueryParam(value="dpr") @Nullable Double dpr, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        UrlDAO urlDAO = this.getUrlDAO();
        Integer n = size;
        if (n == null) {
            n = s;
        }
        UrlDAO.AvatarInfo info = (UrlDAO.AvatarInfo)ExceptionExtKt.checkExists((Object)urlDAO.getInfo(userId, n, dpr));
        URI uri = info.getUri();
        String string = uri.toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.toASCIIString()");
        Response.ResponseBuilder response = StringsKt.startsWith$default((String)string, (String)"data:", (boolean)false, (int)2, null) ? ResourceUtilKt.cache$default((Response.ResponseBuilder)this.avatarRender(uri), (int)0, (int)1, null) : this.avatarRedirect(uri);
        Response response2 = response.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response.build()");
        return response2;
    }

    private final Response.ResponseBuilder avatarRedirect(URI uri) {
        return Response.temporaryRedirect((URI)uri);
    }

    private final Response.ResponseBuilder avatarRender(URI uri) {
        String string = uri.toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.toASCIIString()");
        DataURI dataURI = new DataURI(string);
        Response.ResponseBuilder responseBuilder = Response.ok((Object)dataURI.getContent()).type(dataURI.getMimeType());
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder, (String)"Response.ok(dataURI.cont\u2026t).type(dataURI.mimeType)");
        return responseBuilder;
    }

    private final Response.ResponseBuilder renderDefaultAvatar(String username, Integer size, Double devicePixelRatio) {
        AvatarGenerator.Size s = size != null ? AvatarGenerator.Size.Companion.approximate(size.intValue()) : AvatarGenerator.Size.S40;
        Double d = devicePixelRatio;
        byte[] avatar = AvatarGenerator.INSTANCE.generateAvatar(username, s, d != null ? d : 2.0);
        Response.ResponseBuilder responseBuilder = Response.ok((Object)avatar, (String)"image/svg+xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder, (String)"Response.ok(avatar, \"image/svg+xml\")");
        return responseBuilder;
    }

    private final Response.ResponseBuilder renderAnonymousAvatar() {
        Response.ResponseBuilder responseBuilder = Response.ok().type("image/svg+xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder, (String)"Response.ok().type(\"image/svg+xml\")");
        return ResourceUtilKt.classpathResourceEntity((Response.ResponseBuilder)responseBuilder, (String)"jetpass/images/default-avatar.svg");
    }

    public AvatarResource() {
        ReadOnlyProperty readOnlyProperty;
        AvatarResource avatarResource = this;
        String name$iv = null;
        avatarResource.urlDAO$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/jetpass/rest/api/avatar/AvatarResource$Companion;", "", "()V", "IMAGE_ANY", "", "jetbrains.jetpass.rest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

