/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.api.mergeDetails;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.login.HierarchicalAuthResults;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.EmptyFieldException;
import jetbrains.jetpass.dao.api.userDetails.MergeDetailsHandler;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.oauth2.rest.security.OAuth;
import jetbrains.jetpass.oauth2.rest.security.OAuthResourceFilter;
import jetbrains.jetpass.oauth2.rest.security.SecurityContext;
import jetbrains.jetpass.rest.api.mergeDetails.MergeDetailsResource;
import jetbrains.jetpass.rest.api.serialization.impl.SerializationExtKt;
import jetbrains.jetpass.rest.common.ExceptionExtKt;
import jetbrains.jetpass.rest.dto.AuthRequestJSON;
import jetbrains.jetpass.rest.dto.AuthResultsJSON;
import jetbrains.jetpass.rest.dto.CredentialsJSON;
import jetbrains.jetpass.rest.dto.MergeTokensJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.FieldQuery;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.RequestFieldQuery;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KCallable;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OAuth
@Path(value="/mergedetails")
@Produces(value={"application/json;charset=UTF-8"})
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007J2\u0010\u0014\u001a\u00020\u0004\"\n\b\u0000\u0010\u0015\u0018\u0001*\u00020\u0001\"\u0004\b\u0001\u0010\u0016*\u0002H\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0082\b\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u001c*\b\u0012\u0004\u0012\u0002H\u001c0\u0018H\u0002\u00a8\u0006\u001e"}, d2={"Ljetbrains/jetpass/rest/api/mergeDetails/MergeDetailsResource;", "", "()V", "assertAuthRequestIsValid", "", "authRequest", "Ljetbrains/jetpass/rest/dto/AuthRequestJSON;", "assertMergeTokensValid", "mergeTokens", "Ljetbrains/jetpass/rest/dto/MergeTokensJSON;", "authenticate", "Ljetbrains/jetpass/rest/dto/AuthResultsJSON;", "requestBody", "request", "Ljavax/servlet/http/HttpServletRequest;", "getAuthHolder", "Ljetbrains/jetpass/api/authority/User;", "getAuthHolderChecked", "merge", "Ljetbrains/jetpass/rest/dto/UserJSON;", "checkFieldNotNull", "T", "R", "prop", "Lkotlin/reflect/KCallable;", "(Ljava/lang/Object;Lkotlin/reflect/KCallable;)V", "kotlinName", "", "V", "Companion", "jetbrains.jetpass.rest"})
public final class MergeDetailsResource {
    public static final Companion Companion = new Companion(null);

    @POST
    @Path(value="/authenticate")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final AuthResultsJSON authenticate(@NotNull AuthRequestJSON requestBody, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)requestBody, (String)"requestBody");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            this.assertAuthRequestIsValid(requestBody);
            User currentUser = this.getAuthHolderChecked();
            AuthRequestJSON authRequest = requestBody;
            CredentialsJSON credentialsJSON = authRequest.getCredentials();
            if (credentialsJSON == null) {
                Intrinsics.throwNpe();
            }
            CredentialsJSON credentials = credentialsJSON;
            String name$iv = null;
            MergeDetailsHandler mergeDetailsHandler = (MergeDetailsHandler)SpringUtils.resolveBean(MergeDetailsHandler.class, (String)name$iv);
            String string = authRequest.getUserId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            CredentialsJSON credentialsJSON2 = credentials;
            Intrinsics.checkExpressionValueIsNotNull((Object)credentialsJSON2, (String)"credentials");
            String string2 = credentialsJSON2.getUsername();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = credentials.getPassword();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            HierarchicalAuthResults authResults = mergeDetailsHandler.authenticate(currentUser, string, string2, string3);
            return (AuthResultsJSON)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, AuthResultsJSON>(authResults, request){
                final /* synthetic */ HierarchicalAuthResults $authResults;
                final /* synthetic */ HttpServletRequest $request;

                @NotNull
                public final AuthResultsJSON invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return (AuthResultsJSON)SerializationExtKt.asJSON(this.$authResults, (FieldQuery)new RequestFieldQuery(this.$request, 0, null, 6, null));
                }
                {
                    this.$authResults = hierarchicalAuthResults;
                    this.$request = httpServletRequest;
                    super(1);
                }
            }), (int)7, null);
        }
        catch (DataAccessException ex) {
            Companion.getLogger().error((Throwable)ex, (Function0)new Function0<String>(this, requestBody){
                final /* synthetic */ MergeDetailsResource this$0;
                final /* synthetic */ AuthRequestJSON $requestBody;

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Authentication error while authenticating user [");
                    Object object = this.$requestBody.getCredentials();
                    if (object == null || (object = object.getUsername()) == null) {
                        object = "no credentials were provided";
                    }
                    User user = MergeDetailsResource.access$getAuthHolder(this.this$0);
                    return stringBuilder.append((String)object).append("] ").append("in context of user [").append(user != null ? user.getLogin() : null).append(']').toString();
                }
                {
                    this.this$0 = mergeDetailsResource;
                    this.$requestBody = authRequestJSON;
                    super(0);
                }
            });
            throw (Throwable)ExceptionExtKt.wrapWithRestException((DataAccessException)ex);
        }
    }

    @POST
    @Path(value="/merge")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final UserJSON merge(@NotNull MergeTokensJSON requestBody, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)requestBody, (String)"requestBody");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            Boolean bl;
            Iterable iterable;
            Iterable iterable2;
            this.assertMergeTokensValid(requestBody);
            User currentUser = this.getAuthHolderChecked();
            String name$iv = null;
            MergeDetailsHandler mergeDetailsHandler = (MergeDetailsHandler)SpringUtils.resolveBean(MergeDetailsHandler.class, (String)name$iv);
            String string = requestBody.getUserId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if ((iterable2 = requestBody.getFoundUsers()) == null) {
                iterable2 = CollectionsKt.emptyList();
            }
            if ((iterable = requestBody.getNoUserAttempts()) == null) {
                iterable = CollectionsKt.emptyList();
            }
            if ((bl = requestBody.isCreateHubDetails()) == null) {
                bl = false;
            }
            User mergedUser = mergeDetailsHandler.merge(currentUser, string, iterable2, iterable, bl.booleanValue());
            return (UserJSON)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, UserJSON>(mergedUser, request){
                final /* synthetic */ User $mergedUser;
                final /* synthetic */ HttpServletRequest $request;

                @NotNull
                public final UserJSON invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return (UserJSON)SerializationExtKt.asJSON(this.$mergedUser, (FieldQuery)new RequestFieldQuery(this.$request, 0, null, 6, null));
                }
                {
                    this.$mergedUser = user;
                    this.$request = httpServletRequest;
                    super(1);
                }
            }), (int)7, null);
        }
        catch (DataAccessException ex) {
            Companion.getLogger().error((Throwable)ex, (Function0)new Function0<String>(this){
                final /* synthetic */ MergeDetailsResource this$0;

                @NotNull
                public final String invoke() {
                    User user = MergeDetailsResource.access$getAuthHolder(this.this$0);
                    return "Merge auth results error for user [" + (user != null ? user.getLogin() : null) + ']';
                }
                {
                    this.this$0 = mergeDetailsResource;
                    super(0);
                }
            });
            throw (Throwable)ExceptionExtKt.wrapWithRestException((DataAccessException)ex);
        }
    }

    private final void assertAuthRequestIsValid(AuthRequestJSON authRequest) {
        MergeDetailsResource this_$iv;
        AuthRequestJSON $receiver$iv;
        AuthRequestJSON authRequestJSON = authRequest;
        MergeDetailsResource mergeDetailsResource = this;
        KCallable prop$iv = (KCallable)assertAuthRequestIsValid.1.INSTANCE;
        if (prop$iv.call(new Object[]{$receiver$iv}) == null) {
            throw (Throwable)new EmptyFieldException(AuthRequestJSON.class.getSimpleName(), this_$iv.kotlinName(prop$iv));
        }
        $receiver$iv = authRequest;
        this_$iv = this;
        prop$iv = (KCallable)assertAuthRequestIsValid.2.INSTANCE;
        if (prop$iv.call(new Object[]{$receiver$iv}) == null) {
            throw (Throwable)new EmptyFieldException(AuthRequestJSON.class.getSimpleName(), this_$iv.kotlinName(prop$iv));
        }
        CredentialsJSON credentialsJSON = authRequest.getCredentials();
        if (credentialsJSON != null) {
            $receiver$iv = credentialsJSON;
            this_$iv = this;
            prop$iv = (KCallable)assertAuthRequestIsValid.3.INSTANCE;
            if (prop$iv.call(new Object[]{$receiver$iv}) == null) {
                throw (Throwable)new EmptyFieldException(CredentialsJSON.class.getSimpleName(), this_$iv.kotlinName(prop$iv));
            }
        }
        CredentialsJSON credentialsJSON2 = authRequest.getCredentials();
        if (credentialsJSON2 != null) {
            $receiver$iv = credentialsJSON2;
            this_$iv = this;
            prop$iv = (KCallable)assertAuthRequestIsValid.4.INSTANCE;
            if (prop$iv.call(new Object[]{$receiver$iv}) == null) {
                throw (Throwable)new EmptyFieldException(CredentialsJSON.class.getSimpleName(), this_$iv.kotlinName(prop$iv));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertMergeTokensValid(MergeTokensJSON mergeTokens) {
        void $receiver$iv;
        MergeTokensJSON mergeTokensJSON = mergeTokens;
        MergeDetailsResource mergeDetailsResource = this;
        KCallable prop$iv = (KCallable)assertMergeTokensValid.1.INSTANCE;
        if (prop$iv.call(new Object[]{$receiver$iv}) == null) {
            void this_$iv;
            throw (Throwable)new EmptyFieldException(MergeTokensJSON.class.getSimpleName(), ((MergeDetailsResource)this_$iv).kotlinName(prop$iv));
        }
    }

    private final <T, R> void checkFieldNotNull(@NotNull T $receiver, KCallable<? extends R> prop) {
        if (prop.call(new Object[]{$receiver}) == null) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw (Throwable)new EmptyFieldException(Object.class.getSimpleName(), this.kotlinName(prop));
        }
    }

    private final User getAuthHolderChecked() {
        User user = this.getAuthHolder();
        if (user == null) {
            throw (Throwable)new DataAccessException("Operation is supported only for users");
        }
        return user;
    }

    private final User getAuthHolder() {
        SecurityContext securityContext = OAuthResourceFilter.Companion.getSecurityContext();
        Object object = securityContext != null ? securityContext.getAuthorityHolder() : null;
        if (!(object instanceof User)) {
            object = null;
        }
        return (User)object;
    }

    private final <V> String kotlinName(@NotNull KCallable<? extends V> $receiver) {
        return StringsKt.decapitalize((String)StringsKt.removePrefix((String)$receiver.getName(), (CharSequence)"get"));
    }

    @Nullable
    public static final /* synthetic */ User access$getAuthHolder(MergeDetailsResource $this) {
        return $this.getAuthHolder();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/rest/api/mergeDetails/MergeDetailsResource$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.rest"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

