/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.api.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.gap.filter.query.FilterQuery;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.dao.api.DAO;
import jetbrains.jetpass.dao.api.NamedDAO;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.query.QueryAssistProvider;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.oauth2.rest.security.OAuth;
import jetbrains.jetpass.rest.api.metadata.LinkSubresourceMetaData;
import jetbrains.jetpass.rest.api.metadata.ResourceMetaDataBuilderKt;
import jetbrains.jetpass.rest.api.metadata.RootResourceMetaData;
import jetbrains.jetpass.rest.api.resource.DAOResource;
import jetbrains.jetpass.rest.api.resource.DynamicServerPage;
import jetbrains.jetpass.rest.api.resource.DynamicServerPageKt;
import jetbrains.jetpass.rest.api.resource.LinkDAO;
import jetbrains.jetpass.rest.api.resource.ResourceUtilKt;
import jetbrains.jetpass.rest.api.serialization.bean.QueryAssist;
import jetbrains.jetpass.rest.api.serialization.impl.SerializationExtKt;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.jetpass.sequence.Sequence;
import jetbrains.jetpass.sequence.impl.HubSequenceUtilKt;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.FieldQuery;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.RequestFieldQuery;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.mazine.infer.type.parameter.InferHierarchyTypeKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 M*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u0002H\u0001*\u000e\b\u0002\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00010\u00052\u00020\u0006:\u0002MNB\u0005\u00a2\u0006\u0002\u0010\u0007J(\u0010/\u001a\u001800R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\b\b\u0001\u00101\u001a\u00020\u0012H\u0007J(\u00102\u001a\u001800R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\b\b\u0001\u00103\u001a\u00020\u0012H\u0007J4\u00104\u001a\u001800R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u00105\u001a\u00020\u00122\f\u00106\u001a\b\u0012\u0004\u0012\u00028\u000007H\u0016J\u001c\u00108\u001a\u0002092\b\b\u0001\u0010:\u001a\u00020;2\b\b\u0001\u0010<\u001a\u00020=H\u0017J\b\u0010>\u001a\u00020?H\u0016J/\u0010@\u001a\u00020A2\n\b\u0001\u0010B\u001a\u0004\u0018\u00010\u00122\n\b\u0001\u0010C\u001a\u0004\u0018\u00010D2\b\b\u0001\u0010:\u001a\u00020;H\u0017\u00a2\u0006\u0002\u0010EJ=\u00108\u001a&\u0012\f\u0012\n G*\u0004\u0018\u00018\u00008\u0000 G*\u0012\u0012\f\u0012\n G*\u0004\u0018\u00018\u00008\u0000\u0018\u00010F0F*\u00028\u00022\u0006\u0010:\u001a\u00020;H\u0016\u00a2\u0006\u0002\u0010HJ'\u0010I\u001a\u0002HJ\"\b\b\u0003\u0010J*\u00020\u0006*\u00020;2\f\u0010K\u001a\b\u0012\u0004\u0012\u0002HJ0\u001d\u00a2\u0006\u0002\u0010LR\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\u000e\u001a\u00028\u0002X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\r\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010 \u001a\u00020!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0016\u001a\u0004\b\"\u0010#R\u001e\u0010%\u001a\u00020&8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001fR\u0014\u0010-\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0014\u00a8\u0006O"}, d2={"Ljetbrains/jetpass/rest/api/resource/DAOResource;", "I", "Ljetbrains/jetpass/api/IdItem;", "J", "D", "Ljetbrains/jetpass/dao/api/DAO;", "", "()V", "api", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getApi", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "api$delegate", "Lkotlin/properties/ReadOnlyProperty;", "dao", "getDao", "()Ljetbrains/jetpass/dao/api/DAO;", "itemsPropertyName", "", "getItemsPropertyName", "()Ljava/lang/String;", "itemsPropertyName$delegate", "Lkotlin/Lazy;", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "getJetPass", "()Ljetbrains/jetpass/service/api/JetPassMainApp;", "jetPass$delegate", "jsonType", "Ljava/lang/Class;", "getJsonType", "()Ljava/lang/Class;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "providers", "Ljavax/ws/rs/ext/Providers;", "getProviders", "()Ljavax/ws/rs/ext/Providers;", "setProviders", "(Ljavax/ws/rs/ext/Providers;)V", "type", "getType", "typeName", "getTypeName", "byID", "Ljetbrains/jetpass/rest/api/resource/DAOResource$DAOEntitySubresource;", "id", "byName", "name", "createEntitySubResource", "key", "resolve", "Lkotlin/Function0;", "getAll", "Ljavax/ws/rs/core/Response;", "request", "Ljavax/servlet/http/HttpServletRequest;", "info", "Ljavax/ws/rs/core/UriInfo;", "getMetaData", "Ljetbrains/jetpass/rest/api/metadata/RootResourceMetaData;", "queryAssist", "Ljetbrains/jetpass/rest/dto/QueryAssistJSON;", "query", "caret", "", "(Ljava/lang/String;Ljava/lang/Integer;Ljavax/servlet/http/HttpServletRequest;)Ljetbrains/jetpass/rest/dto/QueryAssistJSON;", "Ljetbrains/jetpass/sequence/Sequence;", "kotlin.jvm.PlatformType", "(Ljetbrains/jetpass/dao/api/DAO;Ljavax/servlet/http/HttpServletRequest;)Ljetbrains/jetpass/sequence/Sequence;", "readBody", "JSON", "clazz", "(Ljavax/servlet/http/HttpServletRequest;Ljava/lang/Class;)Ljava/lang/Object;", "Companion", "DAOEntitySubresource", "jetbrains.jetpass.rest"})
public abstract class DAOResource<I extends IdItem, J extends I, D extends DAO<I>> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty api$delegate;
    @NotNull
    private final ReadOnlyProperty jetPass$delegate;
    @NotNull
    private final Class<I> type;
    @NotNull
    private final Class<J> jsonType;
    @NotNull
    private final Lazy itemsPropertyName$delegate;
    @Context
    @NotNull
    public Providers providers;
    @NotNull
    private final Lazy objectMapper$delegate;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DAOResource.class), "api", "getApi()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DAOResource.class), "jetPass", "getJetPass()Ljetbrains/jetpass/service/api/JetPassMainApp;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DAOResource.class), "itemsPropertyName", "getItemsPropertyName()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DAOResource.class), "objectMapper", "getObjectMapper()Lcom/fasterxml/jackson/databind/ObjectMapper;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final JetPassDAOContainer getApi() {
        return (JetPassDAOContainer)this.api$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final JetPassMainApp getJetPass() {
        return (JetPassMainApp)this.jetPass$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @NotNull
    public abstract D getDao();

    @NotNull
    public Class<I> getType() {
        return this.type;
    }

    @NotNull
    public Class<J> getJsonType() {
        return this.jsonType;
    }

    @NotNull
    public String getTypeName() {
        String string = this.getType().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.simpleName");
        return string;
    }

    @NotNull
    public String getItemsPropertyName() {
        Lazy lazy = this.itemsPropertyName$delegate;
        DAOResource dAOResource = this;
        KProperty kProperty = $$delegatedProperties[2];
        return (String)lazy.getValue();
    }

    @NotNull
    public final Providers getProviders() {
        Providers providers = this.providers;
        if (providers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"providers");
        }
        return providers;
    }

    public final void setProviders(@NotNull Providers providers) {
        Intrinsics.checkParameterIsNotNull((Object)providers, (String)"<set-?>");
        this.providers = providers;
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        Lazy lazy = this.objectMapper$delegate;
        DAOResource dAOResource = this;
        KProperty kProperty = $$delegatedProperties[3];
        return (ObjectMapper)lazy.getValue();
    }

    @NotNull
    public RootResourceMetaData getMetaData() {
        return ResourceMetaDataBuilderKt.collectMetaData(this);
    }

    @Path(value="/{id}")
    @NotNull
    public final DAOEntitySubresource byID(@PathParam(value="id") @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.createEntitySubResource(id, (Function0)new Function0<I>(this, id){
            final /* synthetic */ DAOResource this$0;
            final /* synthetic */ String $id;

            @NotNull
            public final I invoke() {
                IdItem idItem = this.this$0.getDao().get(this.$id);
                if (idItem == null) {
                    throw (Throwable)new NotFoundException(this.this$0.getTypeName() + " with id=\"" + this.$id + "\" was not found");
                }
                return (I)idItem;
            }
            {
                this.this$0 = dAOResource;
                this.$id = string;
                super(0);
            }
        });
    }

    @Path(value="/byname/{name}")
    @NotNull
    public final DAOEntitySubresource byName(@PathParam(value="name") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.createEntitySubResource(name, (Function0)new Function0<I>(this, name){
            final /* synthetic */ DAOResource this$0;
            final /* synthetic */ String $name;

            @NotNull
            public final I invoke() {
                D d = this.this$0.getDao();
                if (!(d instanceof NamedDAO)) {
                    d = null;
                }
                NamedDAO namedDAO = (NamedDAO)d;
                if (namedDAO == null) {
                    throw (Throwable)new NotFoundException("Find " + this.this$0.getTypeName() + " by name is not supported");
                }
                NamedDAO namedDAO2 = namedDAO;
                IdItem idItem = (IdItem)namedDAO2.getFirstByName(this.$name);
                if (idItem == null) {
                    throw (Throwable)new NotFoundException(this.this$0.getTypeName() + " with name=\"" + this.$name + "\" was not found");
                }
                return (I)idItem;
            }
            {
                this.this$0 = dAOResource;
                this.$name = string;
                super(0);
            }
        });
    }

    @NotNull
    public DAOEntitySubresource createEntitySubResource(@NotNull String key, @NotNull Function0<? extends I> resolve2) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(resolve2, (String)"resolve");
        return new DAOEntitySubresource(resolve2);
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public Response getAll(@Context @NotNull HttpServletRequest request, @Context @NotNull UriInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        RequestFieldQuery fieldQuery = new RequestFieldQuery(request, this.getJetPass().getDefaultTop(), null, 4, null);
        URI resourceURI = info.getAbsolutePath();
        Sequence<I> sequence = this.getAll(this.getDao(), request);
        Intrinsics.checkExpressionValueIsNotNull(sequence, (String)"dao.getAll(request)");
        String string = this.getItemsPropertyName();
        URI uRI = resourceURI;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"resourceURI");
        Response response = Response.ok(DynamicServerPageKt.asJSONPage(sequence, string, uRI, (FieldQuery)fieldQuery, new DynamicServerPage.CalculatedField[0])).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(dao.getAll(r\u2026URI, fieldQuery)).build()");
        return response;
    }

    public Sequence<I> getAll(@NotNull D $receiver, @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return $receiver.getAllItems();
    }

    @GET
    @Path(value="/queryAssist")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public QueryAssistJSON queryAssist(@QueryParam(value="query") @Nullable String query, @QueryParam(value="caret") @Nullable Integer caret, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        D d = this.getDao();
        if (!(d instanceof QueryAssistProvider)) {
            d = null;
        }
        QueryAssistProvider queryAssistProvider = (QueryAssistProvider)d;
        if (queryAssistProvider == null) {
            throw (Throwable)new WebApplicationException(Response.Status.NOT_IMPLEMENTED);
        }
        QueryAssistProvider dao = queryAssistProvider;
        String string = query;
        if (string == null) {
            string = "";
        }
        String querySafe = string;
        Integer n = caret;
        int caretSafe = n != null ? n.intValue() : querySafe.length();
        RequestFieldQuery fieldQuery = new RequestFieldQuery(request, this.getJetPass().getDefaultTop(), SetsKt.setOf((Object)"suggestions"));
        return (QueryAssistJSON)dao.evalWithQueryAssist(querySafe, (Function1)new Function1<FilterQuery, QueryAssistJSON>(querySafe, caretSafe, fieldQuery){
            final /* synthetic */ String $querySafe;
            final /* synthetic */ int $caretSafe;
            final /* synthetic */ RequestFieldQuery $fieldQuery;

            @NotNull
            public final QueryAssistJSON invoke(@NotNull FilterQuery filterQuery) {
                Intrinsics.checkParameterIsNotNull((Object)filterQuery, (String)"filterQuery");
                return (QueryAssistJSON)SerializationExtKt.asJSON(new QueryAssist(this.$querySafe, this.$caretSafe, filterQuery), (FieldQuery)this.$fieldQuery);
            }
            {
                this.$querySafe = string;
                this.$caretSafe = n;
                this.$fieldQuery = requestFieldQuery;
                super(1);
            }
        });
    }

    @NotNull
    public final <JSON> JSON readBody(@NotNull HttpServletRequest $receiver, @NotNull Class<JSON> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Object object = this.getObjectMapper().readValue((InputStream)$receiver.getInputStream(), clazz);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper.readValue(this.inputStream, clazz)");
        return (JSON)object;
    }

    public DAOResource() {
        ReadOnlyProperty readOnlyProperty;
        DAOResource dAOResource = this;
        String name$iv = null;
        dAOResource.api$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        dAOResource = this;
        name$iv = null;
        dAOResource.jetPass$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        this.type = InferHierarchyTypeKt.inferTypeParameterClass(DAOResource.class, (String)"I", this.getClass());
        this.jsonType = InferHierarchyTypeKt.inferTypeParameterClass(DAOResource.class, (String)"J", this.getClass());
        this.itemsPropertyName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DAOResource this$0;

            @NotNull
            public final String invoke() {
                return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)ResourceMetaDataBuilderKt.getPathAnnotation(this.this$0.getClass()).value(), (CharSequence)"/"), (CharSequence)"/");
            }
            {
                this.this$0 = dAOResource;
                super(0);
            }
        }));
        this.objectMapper$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ObjectMapper>(this){
            final /* synthetic */ DAOResource this$0;

            public final ObjectMapper invoke() {
                return (ObjectMapper)this.this$0.getProviders().getContextResolver(ObjectMapper.class, MediaType.valueOf((String)"application/json;charset=UTF-8")).getContext(Object.class);
            }
            {
                this.this$0 = dAOResource;
                super(0);
            }
        }));
    }

    @OAuth
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0097\u0004\u0018\u00002\u00020\u0001:\u0001\u0014B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\r\u001a$\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007R\u00180\u0000R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\b2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017R<\u0010\u0005\u001a*\u0012&\u0012$\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007R\u00180\u0000R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Ljetbrains/jetpass/rest/api/resource/DAOResource$DAOEntitySubresource;", "", "resolveEntity", "Lkotlin/Function0;", "(Ljetbrains/jetpass/rest/api/resource/DAOResource;Lkotlin/jvm/functions/Function0;)V", "links", "", "Ljetbrains/jetpass/rest/api/resource/DAOResource$DAOEntitySubresource$LinkDAOSubresource;", "Ljetbrains/jetpass/rest/api/resource/DAOResource;", "getLinks", "()Ljava/util/List;", "getResolveEntity", "()Lkotlin/jvm/functions/Function0;", "getLinkSubresource", "link", "", "getOne", "Ljavax/ws/rs/core/Response;", "request", "Ljavax/servlet/http/HttpServletRequest;", "LinkDAOSubresource", "jetbrains.jetpass.rest"})
    public class DAOEntitySubresource {
        @NotNull
        private final List<jetbrains.jetpass.rest.api.resource.DAOResource$DAOEntitySubresource.LinkDAOSubresource<?, ?>> links;
        @NotNull
        private final Function0<I> resolveEntity;

        @GET
        @Produces(value={"application/json;charset=UTF-8"})
        @NotNull
        public Response getOne(@Context @NotNull HttpServletRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Response response = Response.ok(ResourceUtilKt.restDAOAction(request, (Function0)new Function0<I>(this){
                final /* synthetic */ DAOEntitySubresource this$0;

                @NotNull
                public final I invoke() {
                    return (I)((IdItem)this.this$0.getResolveEntity().invoke());
                }
                {
                    this.this$0 = dAOEntitySubresource;
                    super(0);
                }
            })).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(restDAOActio\u2026esolveEntity() }).build()");
            return response;
        }

        @NotNull
        public List<jetbrains.jetpass.rest.api.resource.DAOResource$DAOEntitySubresource.LinkDAOSubresource<?, ?>> getLinks() {
            return this.links;
        }

        @Path(value="/{link}")
        @NotNull
        public final jetbrains.jetpass.rest.api.resource.DAOResource$DAOEntitySubresource.LinkDAOSubresource<?, ?> getLinkSubresource(@PathParam(value="link") @NotNull String link) {
            Object v0;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
                Iterable $receiver$iv = this.getLinks();
                for (Object element$iv : $receiver$iv) {
                    LinkDAOSubresource it = (LinkDAOSubresource)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getPath(), (Object)link)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            LinkDAOSubresource linkDAOSubresource = v0;
            if (linkDAOSubresource == null) {
                throw (Throwable)new NotFoundException();
            }
            return linkDAOSubresource;
        }

        @NotNull
        public final Function0<I> getResolveEntity() {
            return this.resolveEntity;
        }

        public DAOEntitySubresource(Function0<? extends I> resolveEntity) {
            List list;
            Intrinsics.checkParameterIsNotNull(resolveEntity, (String)"resolveEntity");
            this.resolveEntity = resolveEntity;
            DAOEntitySubresource dAOEntitySubresource = this;
            dAOEntitySubresource.links = list = CollectionsKt.emptyList();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00a6\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u0002*\b\b\u0004\u0010\u0003*\u0002H\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0007J\u001c\u0010\u001e\u001a\u00020\u00192\b\b\u0001\u0010\u001f\u001a\u00020\u00052\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0007J\u001c\u0010 \u001a\u00020\u00192\b\b\u0001\u0010\u001f\u001a\u00020\u00052\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0007J\u001c\u0010!\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0007J\b\u0010\"\u001a\u00020#H\u0016J%\u0010$\u001a\u00028\u00032\u0006\u0010%\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0004\u00a2\u0006\u0002\u0010&J\u001c\u0010'\u001a\u00020\u00192\b\b\u0001\u0010\u001f\u001a\u00020\u00052\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0007R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00040\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0014\u0010\u0016\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010\u00a8\u0006("}, d2={"Ljetbrains/jetpass/rest/api/resource/DAOResource$DAOEntitySubresource$LinkDAOSubresource;", "CI", "", "CJ", "linkName", "", "isDeprecated", "", "(Ljetbrains/jetpass/rest/api/resource/DAOResource$DAOEntitySubresource;Ljava/lang/String;Z)V", "childJSONType", "Ljava/lang/Class;", "getChildJSONType", "()Ljava/lang/Class;", "()Z", "itemsPropertyName", "getItemsPropertyName", "()Ljava/lang/String;", "linkDAO", "Ljetbrains/jetpass/rest/api/resource/LinkDAO;", "getLinkDAO", "()Ljetbrains/jetpass/rest/api/resource/LinkDAO;", "getLinkName", "path", "getPath", "addElement", "Ljavax/ws/rs/core/Response;", "request", "Ljavax/servlet/http/HttpServletRequest;", "info", "Ljavax/ws/rs/core/UriInfo;", "deleteElement", "childKey", "getElement", "getElements", "getMetaData", "Ljetbrains/jetpass/rest/api/metadata/LinkSubresourceMetaData;", "resolveChild", "parentEntity", "(Ljetbrains/jetpass/api/IdItem;Ljava/lang/String;Ljavax/servlet/http/HttpServletRequest;)Ljava/lang/Object;", "updateElement", "jetbrains.jetpass.rest"})
        public abstract class LinkDAOSubresource<CI, CJ extends CI> {
            @NotNull
            private final Class<CJ> childJSONType;
            @NotNull
            private final String itemsPropertyName;
            @NotNull
            private final String linkName;
            private final boolean isDeprecated;
            final /* synthetic */ DAOEntitySubresource this$0;

            @NotNull
            public abstract LinkDAO<I, CI, CJ> getLinkDAO();

            @NotNull
            public Class<CJ> getChildJSONType() {
                return this.childJSONType;
            }

            @NotNull
            public String getItemsPropertyName() {
                return this.itemsPropertyName;
            }

            @NotNull
            public String getPath() {
                return this.getItemsPropertyName();
            }

            @NotNull
            public LinkSubresourceMetaData getMetaData() {
                return ResourceMetaDataBuilderKt.collectMetaData(this);
            }

            @GET
            @OAuth
            @Produces(value={"application/json;charset=UTF-8"})
            @NotNull
            public final Response getElements(@Context @NotNull HttpServletRequest request, @Context @NotNull UriInfo info) {
                LinkDAO linkDAO2;
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                IdItem parentEntity = (IdItem)this.this$0.getResolveEntity().invoke();
                LinkDAO $receiver = linkDAO2 = this.getLinkDAO();
                Iterable<CI> children = $receiver.getChildren(parentEntity, request);
                Sequence sequence = HubSequenceUtilKt.asHubSequence(children);
                String string = this.getItemsPropertyName();
                URI uRI = info.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"info.absolutePath");
                DynamicServerPage page = DynamicServerPageKt.asJSONPage(sequence, string, uRI, (FieldQuery)new RequestFieldQuery(request, this.this$0.DAOResource.this.getJetPass().getDefaultTop(), null, 4, null), new DynamicServerPage.CalculatedField[0]);
                Response response = Response.ok(page).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(page).build()");
                return response;
            }

            @NotNull
            protected final CI resolveChild(@NotNull I parentEntity, @NotNull String childKey, @NotNull HttpServletRequest request) {
                LinkDAO linkDAO2;
                Intrinsics.checkParameterIsNotNull(parentEntity, (String)"parentEntity");
                Intrinsics.checkParameterIsNotNull((Object)childKey, (String)"childKey");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                LinkDAO $receiver = linkDAO2 = this.getLinkDAO();
                CI CI = $receiver.findChild(parentEntity, childKey, request);
                if (CI == null) {
                    throw (Throwable)new NotFoundException("Cannot find " + this.linkName + " [" + childKey + ']');
                }
                return CI;
            }

            @GET
            @OAuth
            @Path(value="/{key}")
            @Produces(value={"application/json;charset=UTF-8"})
            @NotNull
            public final Response getElement(@PathParam(value="key") @NotNull String childKey, @Context @NotNull HttpServletRequest request) {
                Intrinsics.checkParameterIsNotNull((Object)childKey, (String)"childKey");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                IdItem parentEntity = (IdItem)this.this$0.getResolveEntity().invoke();
                CI childEntity = this.resolveChild(parentEntity, childKey, request);
                Response response = Response.ok(ResourceUtilKt.restDAOAction(request, (Function0)new Function0<CI>(childEntity){
                    final /* synthetic */ Object $childEntity;

                    @NotNull
                    public final CI invoke() {
                        return (CI)this.$childEntity;
                    }
                    {
                        this.$childEntity = object;
                        super(0);
                    }
                })).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(restDAOActio\u2026 { childEntity }).build()");
                return response;
            }

            @POST
            @OAuth
            @Produces(value={"application/json;charset=UTF-8"})
            @NotNull
            public final Response addElement(@Context @NotNull HttpServletRequest request, @Context @NotNull UriInfo info) {
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                IdItem parentEntity = (IdItem)this.this$0.getResolveEntity().invoke();
                CJ childEntity = this.this$0.DAOResource.this.readBody(request, this.getChildJSONType());
                Object t = ResourceUtilKt.daoAction((Function0)new Function0<Response>(this, parentEntity, childEntity, request, info){
                    final /* synthetic */ LinkDAOSubresource this$0;
                    final /* synthetic */ IdItem $parentEntity;
                    final /* synthetic */ Object $childEntity;
                    final /* synthetic */ HttpServletRequest $request;
                    final /* synthetic */ UriInfo $info;

                    public final Response invoke() {
                        LinkDAO<I, Object, CJ> linkDAO2;
                        LinkDAO<I, Object, CJ> $receiver = linkDAO2 = this.this$0.getLinkDAO();
                        Object child = $receiver.addChild(this.$parentEntity, this.$childEntity, this.$request);
                        LinkDAO<I, Object, CJ> $receiver2 = $receiver = this.this$0.getLinkDAO();
                        String childID = $receiver2.getChildKey(child);
                        URI locationURI = this.$info.getAbsolutePathBuilder().path(childID).build(new Object[0]);
                        Response response = Response.ok((Object)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, CJ>(this, child){
                            final /* synthetic */ addElement.1 this$0;
                            final /* synthetic */ Object $child;

                            @NotNull
                            public final CJ invoke(@NotNull TransientStoreSession it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return (CJ)SerializationExtKt.asJSON(this.$child, (FieldQuery)new RequestFieldQuery(this.this$0.$request, 0, null, 6, null));
                            }
                            {
                                this.this$0 = var1_1;
                                this.$child = object;
                                super(1);
                            }
                        }), (int)7, null)).location(locationURI).build();
                        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(legacyTransa\u2026                 .build()");
                        return response;
                    }
                    {
                        this.this$0 = linkDAOSubresource;
                        this.$parentEntity = idItem;
                        this.$childEntity = object;
                        this.$request = httpServletRequest;
                        this.$info = uriInfo;
                        super(0);
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"daoAction {\n            \u2026build()\n                }");
                return (Response)t;
            }

            @POST
            @OAuth
            @Path(value="/{key}")
            @Produces(value={"application/json;charset=UTF-8"})
            @NotNull
            public final Response updateElement(@PathParam(value="key") @NotNull String childKey, @Context @NotNull HttpServletRequest request) {
                Intrinsics.checkParameterIsNotNull((Object)childKey, (String)"childKey");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                IdItem parentEntity = (IdItem)this.this$0.getResolveEntity().invoke();
                CJ childBody = this.this$0.DAOResource.this.readBody(request, this.getChildJSONType());
                ResourceUtilKt.daoAction((Function0)new Function0<Unit>(this, parentEntity, childKey, request, childBody){
                    final /* synthetic */ LinkDAOSubresource this$0;
                    final /* synthetic */ IdItem $parentEntity;
                    final /* synthetic */ String $childKey;
                    final /* synthetic */ HttpServletRequest $request;
                    final /* synthetic */ Object $childBody;

                    public final void invoke() {
                        LinkDAO<I, Object, CJ> linkDAO2;
                        CI childEntity = this.this$0.resolveChild(this.$parentEntity, this.$childKey, this.$request);
                        LinkDAO<I, Object, CJ> $receiver = linkDAO2 = this.this$0.getLinkDAO();
                        $receiver.updateChild(this.$parentEntity, childEntity, this.$childBody, this.$request);
                    }
                    {
                        this.this$0 = linkDAOSubresource;
                        this.$parentEntity = idItem;
                        this.$childKey = string;
                        this.$request = httpServletRequest;
                        this.$childBody = object;
                        super(0);
                    }
                });
                Response response = Response.ok().build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
                return response;
            }

            @DELETE
            @OAuth
            @Path(value="/{key}")
            @Produces(value={"application/json;charset=UTF-8"})
            @NotNull
            public final Response deleteElement(@PathParam(value="key") @NotNull String childKey, @Context @NotNull HttpServletRequest request) {
                Intrinsics.checkParameterIsNotNull((Object)childKey, (String)"childKey");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                IdItem parentEntity = (IdItem)this.this$0.getResolveEntity().invoke();
                ResourceUtilKt.daoAction((Function0)new Function0<Unit>(this, parentEntity, childKey, request){
                    final /* synthetic */ LinkDAOSubresource this$0;
                    final /* synthetic */ IdItem $parentEntity;
                    final /* synthetic */ String $childKey;
                    final /* synthetic */ HttpServletRequest $request;

                    public final void invoke() {
                        LinkDAO<I, CI, CJ> linkDAO2;
                        CI childEntity = this.this$0.resolveChild(this.$parentEntity, this.$childKey, this.$request);
                        LinkDAO<I, CI, CJ> $receiver = linkDAO2 = this.this$0.getLinkDAO();
                        $receiver.removeChild(this.$parentEntity, childEntity, this.$request);
                    }
                    {
                        this.this$0 = linkDAOSubresource;
                        this.$parentEntity = idItem;
                        this.$childKey = string;
                        this.$request = httpServletRequest;
                        super(0);
                    }
                });
                Response response = Response.ok().build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
                return response;
            }

            @NotNull
            public final String getLinkName() {
                return this.linkName;
            }

            public final boolean isDeprecated() {
                return this.isDeprecated;
            }

            public LinkDAOSubresource(@NotNull DAOEntitySubresource $outer, String linkName, boolean isDeprecated) {
                Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
                this.this$0 = $outer;
                this.linkName = linkName;
                this.isDeprecated = isDeprecated;
                this.childJSONType = InferHierarchyTypeKt.inferTypeParameterClass(LinkDAOSubresource.class, (String)"CJ", this.getClass());
                String string = this.linkName;
                StringBuilder stringBuilder = new StringBuilder();
                LinkDAOSubresource linkDAOSubresource = this;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String string4 = string3;
                linkDAOSubresource.itemsPropertyName = stringBuilder.append(string4).append("s").toString();
            }

            public /* synthetic */ LinkDAOSubresource(DAOEntitySubresource dAOEntitySubresource, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    bl = false;
                }
                this(dAOEntitySubresource, string, bl);
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/jetpass/rest/api/resource/DAOResource$Companion;", "", "()V", "UNSUPPORTED", "", "jetbrains.jetpass.rest"})
    public static final class Companion {
        @NotNull
        public final Void UNSUPPORTED() {
            throw (Throwable)new UnsupportedOperationException();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

