/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.api.serialization;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jetbrains.jetpass.rest.api.serialization.JSONSerializerManager;
import jetbrains.jetpass.rest.api.serialization.impl.JSONSerializer;
import jetbrains.jetpass.rest.api.serialization.impl.TopologicalSortKt;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.FieldQuery;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component(value="jsonSerializerManager")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J6\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u0010\u0018\u00010\u0004\"\b\b\u0000\u0010\u000f*\u00020\u0001\"\b\b\u0001\u0010\u0010*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0007J/\u0010\u0014\u001a\u0002H\u0010\"\b\b\u0000\u0010\u000f*\u00020\u0001\"\b\b\u0001\u0010\u0010*\u00020\u00012\u0006\u0010\u0015\u001a\u0002H\u000f2\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J6\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0019\"\b\b\u0000\u0010\u000f*\u00020\u0001\"\b\b\u0001\u0010\u0010*\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00192\u0006\u0010\u0016\u001a\u00020\u0017R&\u0010\u0006\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR(\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u0005\u00a8\u0006\u001a"}, d2={"Ljetbrains/jetpass/rest/api/serialization/JSONSerializerManager;", "", "jsonSerializers", "", "Ljetbrains/jetpass/rest/api/serialization/impl/JSONSerializer;", "(Ljava/util/List;)V", "class2serializerCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "getJsonSerializers", "()Ljava/util/List;", "orderedSerializers", "getOrderedSerializers", "setOrderedSerializers", "findSerializer", "I", "J", "sourceType", "initSerializers", "", "serialize", "source", "fieldQuery", "Ljetbrains/mps/webr/rpc/rest/json/runtime/fieldQuery/FieldQuery;", "(Ljava/lang/Object;Ljetbrains/mps/webr/rpc/rest/json/runtime/fieldQuery/FieldQuery;)Ljava/lang/Object;", "", "jetbrains.jetpass.rest"})
public class JSONSerializerManager {
    @NotNull
    public List<? extends JSONSerializer<?, ?>> orderedSerializers;
    private final ConcurrentHashMap<Class<?>, JSONSerializer<?, ?>> class2serializerCache;
    @NotNull
    private final List<JSONSerializer<?, ?>> jsonSerializers;

    @NotNull
    public final List<JSONSerializer<?, ?>> getOrderedSerializers() {
        List<JSONSerializer<?, ?>> list = this.orderedSerializers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"orderedSerializers");
        }
        return list;
    }

    public final void setOrderedSerializers(@NotNull List<? extends JSONSerializer<?, ?>> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.orderedSerializers = list;
    }

    @PostConstruct
    public final void initSerializers() {
        JSONSerializer it;
        Iterable $receiver$iv = this.jsonSerializers;
        for (Object element$iv : $receiver$iv) {
            it = (JSONSerializer)element$iv;
            it.setManager(this);
        }
        this.orderedSerializers = TopologicalSortKt.topologicalSort(this.jsonSerializers, initSerializers.2.INSTANCE);
        $receiver$iv = this.jsonSerializers;
        for (Object element$iv : $receiver$iv) {
            it = (JSONSerializer)element$iv;
            it.collectFields();
        }
    }

    @Nullable
    public final <I, J> JSONSerializer<I, J> findSerializer(@NotNull Class<I> sourceType) {
        Intrinsics.checkParameterIsNotNull(sourceType, (String)"sourceType");
        JSONSerializer jSONSerializer = this.class2serializerCache.get(sourceType);
        if (jSONSerializer == null) {
            Object v2;
            block6: {
                List<? extends JSONSerializer<?, ?>> list = this.orderedSerializers;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"orderedSerializers");
                }
                Iterable $receiver$iv = list;
                for (Object element$iv : $receiver$iv) {
                    JSONSerializer it = (JSONSerializer)element$iv;
                    if (!it.getSourceType().isAssignableFrom(sourceType)) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            JSONSerializer jSONSerializer2 = v2;
            if (jSONSerializer2 != null) {
                JSONSerializer jSONSerializer3 = jSONSerializer2;
                JSONSerializer resolvedSerializer = jSONSerializer3;
                JSONSerializer jSONSerializer4 = this.class2serializerCache.putIfAbsent(sourceType, resolvedSerializer);
                if (jSONSerializer4 == null) {
                    jSONSerializer4 = resolvedSerializer;
                }
                jSONSerializer = jSONSerializer3;
            } else {
                jSONSerializer = null;
            }
        }
        JSONSerializer serializer = jSONSerializer;
        return serializer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <I, J> J serialize(@NotNull I source, @NotNull FieldQuery fieldQuery) {
        void $receiver$iv;
        J j;
        JSONSerializer<?, J> serializer;
        Intrinsics.checkParameterIsNotNull(source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)fieldQuery, (String)"fieldQuery");
        JSONSerializer<?, J> jSONSerializer = this.findSerializer(source.getClass());
        if (jSONSerializer == null) {
            throw (Throwable)new UnsupportedOperationException("No custom serializer found for type " + source.getClass().getName());
        }
        JSONSerializer<?, J> $receiver = serializer = jSONSerializer;
        J target = j = $receiver.getTargetType().newInstance();
        Sequence sequence = SequencesKt.filter((Sequence)MapsKt.asSequence((Map)$receiver.getFieldMapping()), (Function1)new Function1<Map.Entry<? extends String, ? extends Function3<? super I, ? super J, ? super FieldQuery, ? extends Unit>>, Boolean>($receiver, fieldQuery, source){
            final /* synthetic */ JSONSerializer receiver$0$inlined;
            final /* synthetic */ FieldQuery $fieldQuery$inlined;
            final /* synthetic */ Object $source$inlined;
            {
                this.$fieldQuery$inlined = fieldQuery;
                this.$source$inlined = object;
                this.receiver$0$inlined = jSONSerializer;
                super(1);
            }

            public final boolean invoke(@NotNull Map.Entry<String, ? extends Function3<? super I, ? super J, ? super FieldQuery, Unit>> $name_$_$) {
                Intrinsics.checkParameterIsNotNull($name_$_$, (String)"<name for destructuring parameter 0>");
                Map.Entry<String, Function3<I, J, FieldQuery, Unit>> entry = $name_$_$;
                String name = entry.getKey();
                return this.$fieldQuery$inlined.isSelected(name, this.receiver$0$inlined.getFieldsSelectedByDefault().contains(name));
            }
        });
        for (Object element$iv : $receiver$iv) {
            Map.Entry $name_mapField;
            Map.Entry entry = $name_mapField = (Map.Entry)element$iv;
            String name = (String)entry.getKey();
            entry = $name_mapField;
            Function3 mapField = (Function3)entry.getValue();
            J j2 = target;
            Intrinsics.checkExpressionValueIsNotNull(j2, (String)"target");
            mapField.invoke(source, j2, (Object)fieldQuery.getSubFieldQuery(name));
        }
        J j3 = j;
        Intrinsics.checkExpressionValueIsNotNull(j3, (String)"targetType.newInstance()\u2026          }\n            }");
        Intrinsics.checkExpressionValueIsNotNull(j3, (String)"with(serializer) {\n     \u2026}\n            }\n        }");
        return j3;
    }

    @NotNull
    public final <I, J> Iterable<J> serialize(@NotNull Iterable<? extends I> source, @NotNull FieldQuery fieldQuery) {
        Sequence sequence;
        Intrinsics.checkParameterIsNotNull(source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)fieldQuery, (String)"fieldQuery");
        Sequence it = sequence = CollectionsKt.asSequence(source);
        it = sequence = fieldQuery.getSkip() > 0 ? SequencesKt.drop((Sequence)it, (int)fieldQuery.getSkip()) : it;
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)(fieldQuery.getTop() >= 0 ? SequencesKt.take((Sequence)it, (int)fieldQuery.getTop()) : it), (Function1)new Function1<I, J>(this, fieldQuery){
            final /* synthetic */ JSONSerializerManager this$0;
            final /* synthetic */ FieldQuery $fieldQuery;

            @NotNull
            public final J invoke(@NotNull I it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return this.this$0.serialize(it, this.$fieldQuery);
            }
            {
                this.this$0 = jSONSerializerManager;
                this.$fieldQuery = fieldQuery;
                super(1);
            }
        }));
    }

    @NotNull
    public final List<JSONSerializer<?, ?>> getJsonSerializers() {
        return this.jsonSerializers;
    }

    @Inject
    public JSONSerializerManager(@NotNull List<? extends JSONSerializer<?, ?>> jsonSerializers) {
        Intrinsics.checkParameterIsNotNull(jsonSerializers, (String)"jsonSerializers");
        this.jsonSerializers = jsonSerializers;
        this.class2serializerCache = new ConcurrentHashMap();
    }
}

