/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.htmlComponent.runtime;

import java.util.List;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.webr.htmlComponent.runtime.IKey;
import jetbrains.mps.webr.htmlComponent.runtime.IKeyCode;
import jetbrains.mps.webr.htmlComponent.runtime.IKeyStroke;
import jetbrains.mps.webr.htmlComponent.runtime.IKeyStrokeMapping;
import jetbrains.mps.webr.htmlComponent.runtime.KeyType;
import jetbrains.mps.webr.runtime.util.UserAgentUtil;
import jetbrains.mps.webr.runtime.util.UserBrowser;
import jetbrains.mps.webr.runtime.util.UserOS;

public abstract class BaseKeyStroke
implements IKeyStroke {
    private String name;
    private List<IKeyStrokeMapping> mappings;

    @Override
    public String getName() {
        return this.name;
    }

    public List<IKeyStrokeMapping> getMappings() {
        return this.mappings;
    }

    @Override
    public String getPresentation() {
        return this.getPresentation(UserAgentUtil.getUserOS(), UserAgentUtil.getUserBrowser());
    }

    @Override
    public String getPresentation(final UserOS os, UserBrowser browser) {
        final Wrappers._T result = new Wrappers._T(null);
        this.traverseClosure(os, browser, (_FunctionTypes._void_P1_E0<? super IKey>)new _FunctionTypes._void_P1_E0<IKey>(){

            public void invoke(IKey key) {
                StringBuilder sb = new StringBuilder();
                BaseKeyStroke.this.appendKey(os, sb, "Ctrl", "\u2303", key.getCtrl());
                BaseKeyStroke.this.appendKey(os, sb, "Alt", "\u2325", key.getAlt());
                BaseKeyStroke.this.appendKey(os, sb, "Meta", "\u2318", key.getMeta());
                BaseKeyStroke.this.appendKey(os, sb, "Shift", "\u21e7", key.getShift());
                IKeyCode keyCode = key.getKeyCode();
                String codePresentation = BaseKeyStroke.isEmpty_nypqkj_a0h0a0a2a0b0d(keyCode.getName()) ? Integer.toString(keyCode.getCode()) : (keyCode.getMacName() == null || os != UserOS.MACINTOSH ? keyCode.getName() : keyCode.getMacName());
                result.value = sb.append(codePresentation).toString();
            }
        });
        return (String)result.value;
    }

    private void appendKey(UserOS os, StringBuilder sb, String key, String macKey, KeyType type) {
        if (type != KeyType.FALSE) {
            String k;
            String string = k = os == UserOS.MACINTOSH ? macKey : key;
            if (type == KeyType.IGNORE) {
                sb.append('[');
                sb.append(k);
                sb.append("]");
            } else {
                sb.append(k);
            }
            if (os == UserOS.MACINTOSH) {
                sb.append(" ");
            } else {
                sb.append(" + ");
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMappings(List<IKeyStrokeMapping> mappings) {
        this.mappings = mappings;
    }

    public void traverseClosure(UserOS os, UserBrowser browser, _FunctionTypes._void_P1_E0<? super IKey> closure) {
        for (IKeyStrokeMapping mapping : ListSequence.fromList(this.mappings)) {
            if (!mapping.isApplicable(os, browser)) continue;
            closure.invoke((Object)mapping.getKey());
            return;
        }
    }

    public static boolean isEmpty_nypqkj_a0h0a0a2a0b0d(String str) {
        return str == null || str.length() == 0;
    }
}

